/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.Messages;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.VisualizePanel;

public class DataVisualizer
extends JPanel
implements DataSourceListener,
TrainingSetListener,
TestSetListener,
Visible,
UserRequestAcceptor,
Serializable,
BeanContextChild {
    private static final long serialVersionUID = 1949062132560159028L;
    protected BeanVisual m_visual;
    protected transient Instances m_visualizeDataSet;
    protected transient JFrame m_popupFrame;
    protected boolean m_framePoppedUp = false;
    protected boolean m_design;
    protected transient BeanContext m_beanContext = null;
    private VisualizePanel m_visPanel;
    private Vector m_dataSetListeners = new Vector();
    protected BeanContextChildSupport m_bcSupport = new BeanContextChildSupport(this);

    public DataVisualizer() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!GraphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("DataVisualizer_GlobalInfo_Text");
    }

    protected void appearanceDesign() {
        this.m_visPanel = null;
        this.removeAll();
        this.m_visual = new BeanVisual("DataVisualizer", "weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    protected void appearanceFinal() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.removeAll();
        if (!GraphicsEnvironment.isHeadless()) {
            this.setLayout(new BorderLayout());
            this.setUpFinal();
        }
    }

    protected void setUpFinal() {
        if (this.m_visPanel == null) {
            this.m_visPanel = new VisualizePanel();
        }
        this.add((Component)this.m_visPanel, "Center");
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances trainingSet = e.getTrainingSet();
        DataSetEvent dse = new DataSetEvent(this, trainingSet);
        this.acceptDataSet(dse);
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances testSet = e.getTestSet();
        DataSetEvent dse = new DataSetEvent(this, testSet);
        this.acceptDataSet(dse);
    }

    @Override
    public synchronized void acceptDataSet(DataSetEvent e) {
        if (e.isStructureOnly()) {
            return;
        }
        this.m_visualizeDataSet = new Instances(e.getDataSet());
        if (this.m_visualizeDataSet.classIndex() < 0) {
            this.m_visualizeDataSet.setClassIndex(this.m_visualizeDataSet.numAttributes() - 1);
        }
        if (!this.m_design) {
            try {
                this.setInstances(this.m_visualizeDataSet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.notifyDataSetListeners(e);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_visualizeDataSet != null) {
            newVector.addElement("Show plot");
        }
        return newVector.elements();
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.addPropertyChangeListener(name, pcl);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bcSupport.removePropertyChangeListener(name, pcl);
    }

    @Override
    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.addVetoableChangeListener(name, vcl);
    }

    @Override
    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bcSupport.removeVetoableChangeListener(name, vcl);
    }

    @Override
    public void setBeanContext(BeanContext bc) {
        this.m_beanContext = bc;
        this.m_design = this.m_beanContext.isDesignTime();
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (!GraphicsEnvironment.isHeadless()) {
                this.appearanceFinal();
            }
        }
    }

    @Override
    public BeanContext getBeanContext() {
        return this.m_beanContext;
    }

    public void setInstances(Instances inst) throws Exception {
        if (this.m_design) {
            Messages.getInstance();
            throw new Exception(Messages.getString("DataVisualizer_SetInstances_Exception_Text"));
        }
        this.m_visualizeDataSet = inst;
        PlotData2D pd1 = new PlotData2D(this.m_visualizeDataSet);
        pd1.setPlotName(this.m_visualizeDataSet.relationName());
        try {
            this.m_visPanel.setMasterPlot(pd1);
        }
        catch (Exception ex) {
            Messages.getInstance();
            System.err.println(Messages.getString("DataVisualizer_SetInstances_Error_Text"));
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataSetListeners(DataSetEvent ge) {
        Vector l;
        DataVisualizer dataVisualizer = this;
        synchronized (dataVisualizer) {
            l = (Vector)this.m_dataSetListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(ge);
                ++i;
            }
        }
    }

    @Override
    public void performRequest(String request) {
        block7: {
            if (request.compareTo("Show plot") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        VisualizePanel vis = new VisualizePanel();
                        PlotData2D pd1 = new PlotData2D(this.m_visualizeDataSet);
                        pd1.setPlotName(this.m_visualizeDataSet.relationName());
                        try {
                            vis.setMasterPlot(pd1);
                        }
                        catch (Exception ex) {
                            Messages.getInstance();
                            System.err.println(Messages.getString("DataVisualizer_PerformRequest_Error_Text"));
                            ex.printStackTrace();
                        }
                        Messages.getInstance();
                        final JFrame jf = new JFrame(Messages.getString("DataVisualizer_PerformRequest_Jf_JFrame_Text"));
                        jf.setSize(800, 600);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)vis, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                DataVisualizer.this.m_framePoppedUp = false;
                            }
                        });
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block7;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(request));
                Messages.getInstance();
                throw new IllegalArgumentException(stringBuilder.append(Messages.getString("DataVisualizer_PerformRequest_IllegalArgumentException_Text")).toString());
            }
        }
    }

    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataSetListeners.addElement(dsl);
    }

    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataSetListeners.remove(dsl);
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                Messages.getInstance();
                System.err.println(Messages.getString("DataVisualizer_Main_Error_Text_First"));
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            DataVisualizer as = new DataVisualizer();
            as.setInstances(inst);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

