/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.experiment.Task;
import weka.experiment.TaskStatusInfo;
import weka.gui.ExtensionFileFilter;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Messages;
import weka.gui.beans.SerializedModelSaver;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Classifier
extends JPanel
implements BeanCommon,
Visible,
WekaWrapper,
EventConstraints,
Serializable,
UserRequestAcceptor,
TrainingSetListener,
TestSetListener,
InstanceListener {
    private static final long serialVersionUID = 659603893917736008L;
    protected BeanVisual m_visual = new BeanVisual("Classifier", "weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
    private static int IDLE = 0;
    private static int BUILDING_MODEL = 1;
    private static int CLASSIFYING = 2;
    private int m_state = IDLE;
    protected String m_globalInfo;
    private final Hashtable m_listenees = new Hashtable();
    private final Vector m_batchClassifierListeners = new Vector();
    private final Vector m_incrementalClassifierListeners = new Vector();
    private final Vector m_graphListeners = new Vector();
    private final Vector m_textListeners = new Vector();
    private Instances m_trainingSet;
    private transient Instances m_testingSet;
    private weka.classifiers.Classifier m_Classifier;
    private weka.classifiers.Classifier m_ClassifierTemplate = this.m_Classifier = new ZeroR();
    private final IncrementalClassifierEvent m_ie = new IncrementalClassifierEvent(this);
    public static final String FILE_EXTENSION = "model";
    private transient JFileChooser m_fileChooser = null;
    protected FileFilter m_binaryFilter;
    protected FileFilter m_KOMLFilter;
    protected FileFilter m_XStreamFilter;
    private boolean m_updateIncrementalClassifier;
    private transient Logger m_log;
    private InstanceEvent m_incrementalEvent;
    protected int m_executionSlots;
    protected transient ThreadPoolExecutor m_executorPool;
    protected transient BatchClassifierEvent[][] m_outputQueues;
    protected transient boolean[][] m_completedSets;
    protected transient Date m_currentBatchIdentifier;
    protected transient boolean m_batchStarted;
    protected String m_oldText;
    protected boolean m_block;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Classifier() {
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_BinaryFilter_ExtensionFileFilter_Text_First"))).append(FILE_EXTENSION);
        Messages.getInstance();
        this.m_binaryFilter = new ExtensionFileFilter(".model", stringBuilder.append(Messages.getString("Classifier_BinaryFilter_ExtensionFileFilter_Text_Second")).toString());
        Messages.getInstance();
        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("Classifier_KOMLFilter_ExtensionFileFilter_Text_First"))).append(".koml").append(FILE_EXTENSION);
        Messages.getInstance();
        this.m_KOMLFilter = new ExtensionFileFilter(".komlmodel", stringBuilder2.append(Messages.getString("Classifier_KOMLFilter_ExtensionFileFilter_Text_Second")).toString());
        Messages.getInstance();
        StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("Classifier_XStreamFilter_ExtensionFileFilter_Text_First"))).append(".xstream").append(FILE_EXTENSION);
        Messages.getInstance();
        this.m_XStreamFilter = new ExtensionFileFilter(".xstreammodel", stringBuilder3.append(Messages.getString("Classifier_XStreamFilter_ExtensionFileFilter_Text_Second")).toString());
        this.m_updateIncrementalClassifier = true;
        this.m_log = null;
        this.m_executionSlots = 2;
        this.m_batchStarted = false;
        this.m_oldText = "";
        this.m_block = false;
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.setClassifierTemplate(this.m_ClassifierTemplate);
    }

    private void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = new ThreadPoolExecutor(this.m_executionSlots, this.m_executionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    protected void setupFileChooser() {
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        }
        this.m_fileChooser.addChoosableFileFilter(this.m_binaryFilter);
        if (KOML.isPresent()) {
            this.m_fileChooser.addChoosableFileFilter(this.m_KOMLFilter);
        }
        if (XStream.isPresent()) {
            this.m_fileChooser.addChoosableFileFilter(this.m_XStreamFilter);
        }
        this.m_fileChooser.setFileFilter(this.m_binaryFilter);
    }

    public int getExecutionSlots() {
        return this.m_executionSlots;
    }

    public void setExecutionSlots(int slots) {
        this.m_executionSlots = slots;
    }

    public void setClassifierTemplate(weka.classifiers.Classifier c) {
        boolean loadImages = true;
        if (c.getClass().getName().compareTo(this.m_ClassifierTemplate.getClass().getName()) == 0) {
            loadImages = false;
        } else {
            this.m_trainingSet = null;
        }
        this.m_ClassifierTemplate = c;
        String classifierName = c.getClass().toString();
        classifierName = classifierName.substring(classifierName.lastIndexOf(46) + 1, classifierName.length());
        if (loadImages) {
            if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + classifierName + ".gif", "weka/gui/beans/icons/" + classifierName + "_animated.gif")) {
                this.useDefaultVisual();
            }
            this.m_visual.setText(classifierName);
        }
        if (!(this.m_ClassifierTemplate instanceof UpdateableClassifier) && this.m_listenees.containsKey("instance") && this.m_log != null) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_SetClassifierTemplate_LogMessage_Text_First"))).append(this.statusMessagePrefix());
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Classifier_SetClassifierTemplate_LogMessage_Text_Second")).append(this.getCustomName());
            Messages.getInstance();
            this.m_log.logMessage(stringBuilder2.append(Messages.getString("Classifier_SetClassifierTemplate_LogMessage_Text_Third")).toString());
        }
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_ClassifierTemplate);
    }

    public weka.classifiers.Classifier getClassifierTemplate() {
        return this.m_ClassifierTemplate;
    }

    private void setTrainedClassifier(weka.classifiers.Classifier tc) throws Exception {
        weka.classifiers.Classifier newTemplate = null;
        String[] options = tc.getOptions();
        newTemplate = weka.classifiers.Classifier.forName(tc.getClass().getName(), options);
        if (!newTemplate.getClass().equals(this.m_ClassifierTemplate.getClass())) {
            throw new Exception("Classifier model " + tc.getClass().getName() + " is not the same type " + "of classifier as this one (" + this.m_ClassifierTemplate.getClass().getName() + ")");
        }
        this.setClassifierTemplate(newTemplate);
        this.m_Classifier = tc;
    }

    public boolean hasIncomingStreamInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("instance");
    }

    public boolean hasIncomingBatchInstances() {
        if (this.m_listenees.size() == 0) {
            return false;
        }
        return this.m_listenees.containsKey("trainingSet") || this.m_listenees.containsKey("testSet");
    }

    public weka.classifiers.Classifier getClassifier() {
        return this.m_Classifier;
    }

    @Override
    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.classifiers.Classifier)) {
            StringBuilder stringBuilder = new StringBuilder().append(algorithm.getClass());
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("Classifier_SetWrappedAlgorithm_IllegalArgumentException_Text_First")).toString());
        }
        this.setClassifierTemplate((weka.classifiers.Classifier)algorithm);
    }

    @Override
    public Object getWrappedAlgorithm() {
        return this.getClassifierTemplate();
    }

    public boolean getUpdateIncrementalClassifier() {
        return this.m_updateIncrementalClassifier;
    }

    public void setUpdateIncrementalClassifier(boolean update) {
        this.m_updateIncrementalClassifier = update;
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        this.m_incrementalEvent = e;
        this.handleIncrementalEvent();
    }

    private void handleIncrementalEvent() {
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_Messg_Text_First"))).append(this.statusMessagePrefix());
            Messages.getInstance();
            String messg = stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_Messg_Text_Second")).toString();
            if (this.m_log != null) {
                this.m_log.logMessage(messg);
                StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder2.append(Messages.getString("Classifier_HandleIncrementalEvent_StatusMessage_Text_First")).toString());
            } else {
                System.err.println(messg);
            }
            return;
        }
        if (this.m_incrementalEvent.getStatus() == 0) {
            Instances dataset;
            if (this.m_log != null) {
                this.m_log.statusMessage(String.valueOf(this.statusMessagePrefix()) + "remove");
            }
            if ((dataset = this.m_incrementalEvent.getStructure()).classIndex() < 0) {
                this.stop();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                String errorMessage = stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_ErrorMessage_Text_First")).toString();
                if (this.m_log != null) {
                    this.m_log.statusMessage(errorMessage);
                    Messages.getInstance();
                    StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_First"))).append(this.getCustomName());
                    Messages.getInstance();
                    this.m_log.logMessage(stringBuilder3.append(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_Second")).append(errorMessage).toString());
                } else {
                    Messages.getInstance();
                    StringBuilder stringBuilder4 = new StringBuilder(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_Error_Text_First"))).append(this.getCustomName());
                    Messages.getInstance();
                    System.err.println(stringBuilder4.append(Messages.getString("Classifier_HandleIncrementalEvent_Error_Text_Second")).append(errorMessage).toString());
                }
                return;
            }
            try {
                if (this.m_trainingSet == null || !dataset.equalHeaders(this.m_trainingSet)) {
                    if (!(this.m_ClassifierTemplate instanceof UpdateableClassifier)) {
                        this.stop();
                        if (this.m_log != null) {
                            String string;
                            if (this.m_trainingSet == null) {
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                                Messages.getInstance();
                                string = stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_Msg_Text_First")).toString();
                            } else {
                                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                                Messages.getInstance();
                                string = stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_Msg_Text_Second")).toString();
                            }
                            String msg = string;
                            Messages.getInstance();
                            this.m_log.logMessage(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_Third")) + msg);
                            this.m_log.statusMessage(msg);
                        }
                        return;
                    }
                    if (this.m_trainingSet != null && !dataset.equalHeaders(this.m_trainingSet)) {
                        if (this.m_log != null) {
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                            Messages.getInstance();
                            String msg = stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_Msg_Text_Third")).toString();
                            Messages.getInstance();
                            this.m_log.logMessage(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_Fourth")) + msg);
                            this.m_log.statusMessage(msg);
                        }
                        this.m_trainingSet = null;
                    }
                    if (this.m_trainingSet == null) {
                        this.m_trainingSet = new Instances(dataset, 0);
                        this.m_Classifier = weka.classifiers.Classifier.makeCopy(this.m_ClassifierTemplate);
                        this.m_Classifier.buildClassifier(this.m_trainingSet);
                    }
                }
            }
            catch (Exception ex) {
                this.stop();
                if (this.m_log != null) {
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                    Messages.getInstance();
                    this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_StatusMessage_Text_Second")).toString());
                    Messages.getInstance();
                    StringBuilder stringBuilder5 = new StringBuilder(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_Fifth"))).append(this.statusMessagePrefix());
                    Messages.getInstance();
                    this.m_log.logMessage(stringBuilder5.append(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_Sixth")).append(ex.getMessage()).toString());
                }
                ex.printStackTrace();
                return;
            }
            System.err.println("NOTIFYING NEW BATCH");
            this.m_ie.setStructure(dataset);
            this.m_ie.setClassifier(this.m_Classifier);
            this.notifyIncrementalClassifierListeners(this.m_ie);
            return;
        }
        if (this.m_trainingSet == null) {
            return;
        }
        try {
            if (this.m_incrementalEvent.getInstance().dataset().classIndex() < 0) {
                this.m_incrementalEvent.getInstance().dataset().setClassIndex(this.m_incrementalEvent.getInstance().dataset().numAttributes() - 1);
            }
            int status = 1;
            if (this.m_incrementalEvent.getStatus() == 2) {
                status = 2;
            }
            this.m_ie.setStatus(status);
            this.m_ie.setClassifier(this.m_Classifier);
            this.m_ie.setCurrentInstance(this.m_incrementalEvent.getInstance());
            this.notifyIncrementalClassifierListeners(this.m_ie);
            if (this.m_ClassifierTemplate instanceof UpdateableClassifier && this.m_updateIncrementalClassifier && !this.m_incrementalEvent.getInstance().isMissing(this.m_incrementalEvent.getInstance().dataset().classIndex())) {
                ((UpdateableClassifier)((Object)this.m_Classifier)).updateClassifier(this.m_incrementalEvent.getInstance());
            }
            if (this.m_incrementalEvent.getStatus() == 2 && this.m_textListeners.size() > 0) {
                String modelString = this.m_Classifier.toString();
                String titleString = this.m_Classifier.getClass().getName();
                titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_ModelString_Text_First"))).append(titleString).append("\n");
                Messages.getInstance();
                modelString = stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_ModelString_Text_Second")).append(this.m_trainingSet.relationName()).append("\n\n").append(modelString).toString();
                Messages.getInstance();
                titleString = String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_TitleString_Text_First")) + titleString;
                TextEvent nt = new TextEvent(this, modelString, titleString);
                this.notifyTextListeners(nt);
            }
        }
        catch (Exception ex) {
            this.stop();
            if (this.m_log != null) {
                Messages.getInstance();
                this.m_log.logMessage(String.valueOf(Messages.getString("Classifier_HandleIncrementalEvent_LogMessage_Text_Seventh")) + this.statusMessagePrefix() + ex.getMessage());
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_HandleIncrementalEvent_StatusMessage_Text_Third")).toString());
                ex.printStackTrace();
            }
            ex.printStackTrace();
        }
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        if (e.isStructureOnly()) {
            BatchClassifierEvent ce = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, e.getTrainingSet()), new DataSetEvent(this, e.getTrainingSet()), e.getSetNumber(), e.getMaxSetNumber());
            this.notifyBatchClassifierListeners(ce);
            return;
        }
        if (this.m_block) {
            if (this.m_log != null) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_AcceptTrainingSet_StatusMessage_Text_First")).toString());
                Messages.getInstance();
                StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTrainingSet_LogMessage_Text_First"))).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder2.append(Messages.getString("Classifier_AcceptTrainingSet_LogMessage_Text_Second")).toString());
            }
            return;
        }
        if (e.getRunNumber() == 1 && e.getSetNumber() == 1) {
            this.m_trainingSet = new Instances(e.getTrainingSet(), 0);
            this.m_state = BUILDING_MODEL;
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_First"))).append(this.statusMessagePrefix());
            Messages.getInstance();
            StringBuilder stringBuilder3 = stringBuilder.append(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Second")).append(this.getExecutionSlots());
            Messages.getInstance();
            String msg = stringBuilder3.append(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Third")).toString();
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            this.startExecutorPool();
            Messages.getInstance();
            StringBuilder stringBuilder4 = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Fourth"))).append(this.statusMessagePrefix());
            Messages.getInstance();
            msg = stringBuilder4.append(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Fifth")).toString();
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            if (!this.m_batchStarted) {
                this.m_outputQueues = new BatchClassifierEvent[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_completedSets = new boolean[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_currentBatchIdentifier = new Date();
                this.m_batchStarted = true;
            }
        }
        TrainingTask newTask = new TrainingTask(e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber(), e.getTrainingSet());
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Sixth"))).append(this.statusMessagePrefix());
        Messages.getInstance();
        StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Seventh")).append(e.getRunNumber());
        Messages.getInstance();
        StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Eighth")).append(e.getSetNumber());
        Messages.getInstance();
        String msg = stringBuilder6.append(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Nineth")).toString();
        if (this.m_log != null) {
            this.m_log.logMessage(msg);
        } else {
            System.err.println(msg);
        }
        this.m_executorPool.execute(newTask);
    }

    @Override
    public synchronized void acceptTestSet(TestSetEvent e) {
        if (this.m_block) {
            if (this.m_log != null) {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_AcceptTrainingSet_StatusMessage_Text_Second")).toString());
                Messages.getInstance();
                StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTrainingSet_Msg_Text_Nineth"))).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder2.append(Messages.getString("Classifier_AcceptTrainingSet_StatusMessage_Text_Second")).toString());
            }
            return;
        }
        Instances testSet = e.getTestSet();
        if (testSet != null && testSet.classIndex() < 0) {
            this.stop();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
            Messages.getInstance();
            String errorMessage = stringBuilder.append(Messages.getString("Classifier_AcceptTestSet_ErrorMessage_Text_First")).toString();
            if (this.m_log != null) {
                this.m_log.statusMessage(errorMessage);
                Messages.getInstance();
                this.m_log.logMessage(String.valueOf(Messages.getString("Classifier_AcceptTestSet_LogMessage_Text_First")) + errorMessage);
            } else {
                Messages.getInstance();
                System.err.println(String.valueOf(Messages.getString("Classifier_AcceptTestSet_Error_Text_First")) + errorMessage);
            }
            return;
        }
        if (this.m_Classifier != null && this.m_state == IDLE && !this.m_listenees.containsKey("trainingSet")) {
            if (e.getTestSet() != null && e.isStructureOnly()) {
                return;
            }
            if (this.m_trainingSet == null) {
                this.stop();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                String errorMessage = stringBuilder.append(Messages.getString("Classifier_AcceptTestSet_ErrorMessage_Text_First_Alpha")).toString();
                if (this.m_log != null) {
                    this.m_log.statusMessage(errorMessage);
                    Messages.getInstance();
                    this.m_log.logMessage(String.valueOf(Messages.getString("Classifier_AcceptTestSet_LogMessage_Text_Second")) + errorMessage);
                } else {
                    Messages.getInstance();
                    System.err.println(String.valueOf(Messages.getString("Classifier_AcceptTestSet_Error_Text_Second")) + errorMessage);
                }
                return;
            }
            testSet = e.getTestSet();
            if (e.getRunNumber() == 1 && e.getSetNumber() == 1) {
                this.m_currentBatchIdentifier = new Date();
            }
            if (testSet != null && this.m_trainingSet.equalHeaders(testSet)) {
                BatchClassifierEvent ce = new BatchClassifierEvent(this, this.m_Classifier, new DataSetEvent(this, this.m_trainingSet), new DataSetEvent(this, e.getTestSet()), e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber());
                ce.setGroupIdentifier(this.m_currentBatchIdentifier.getTime());
                if (this.m_log != null && !e.isStructureOnly()) {
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                    Messages.getInstance();
                    this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_AcceptTestSet_StatusMessage_Text_First")).toString());
                }
                this.m_batchStarted = false;
                this.notifyBatchClassifierListeners(ce);
            }
        } else {
            if (e.getRunNumber() == 1 && e.getSetNumber() == 1 && !this.m_batchStarted) {
                this.m_outputQueues = new BatchClassifierEvent[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_completedSets = new boolean[e.getMaxRunNumber()][e.getMaxSetNumber()];
                this.m_currentBatchIdentifier = new Date();
                this.m_batchStarted = true;
            }
            if (this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1] == null) {
                this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1] = new BatchClassifierEvent(this, null, null, new DataSetEvent(this, e.getTestSet()), e.getRunNumber(), e.getMaxRunNumber(), e.getSetNumber(), e.getMaxSetNumber());
                if (e.getRunNumber() == e.getMaxRunNumber() && e.getSetNumber() == e.getMaxSetNumber() && e.getMaxSetNumber() != 1) {
                    this.m_block = true;
                }
            } else {
                this.m_outputQueues[e.getRunNumber() - 1][e.getSetNumber() - 1].setTestSet(new DataSetEvent(this, e.getTestSet()));
                this.checkCompletedRun(e.getRunNumber(), e.getMaxRunNumber(), e.getMaxSetNumber());
            }
        }
    }

    private synchronized void classifierTrainingComplete(BatchClassifierEvent ce) {
        if (this.m_listenees.containsKey("testSet")) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTestSet_Msg_Text_First"))).append(this.statusMessagePrefix());
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Second")).append(ce.getRunNumber());
            Messages.getInstance();
            String msg = stringBuilder2.append(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Third")).append(ce.getSetNumber()).toString();
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            if (this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1] == null) {
                this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1] = ce;
            } else {
                this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1].setClassifier(ce.getClassifier());
                this.m_outputQueues[ce.getRunNumber() - 1][ce.getSetNumber() - 1].setTrainSet(ce.getTrainSet());
            }
            this.checkCompletedRun(ce.getRunNumber(), ce.getMaxRunNumber(), ce.getMaxSetNumber());
        }
    }

    private synchronized void checkCompletedRun(int runNum, int maxRunNum, int maxSets) {
        int i = 0;
        while (i < maxSets) {
            if (this.m_outputQueues[runNum - 1][i] != null && this.m_outputQueues[runNum - 1][i].getClassifier() != null && this.m_outputQueues[runNum - 1][i].getTestSet() != null) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Fourth"))).append(this.statusMessagePrefix());
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Fifth")).append(runNum).append("/").append(i + 1);
                Messages.getInstance();
                String msg = stringBuilder2.append(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Sixth")).toString();
                if (this.m_log != null) {
                    this.m_log.logMessage(msg);
                } else {
                    System.err.println(msg);
                }
                this.m_outputQueues[runNum - 1][i].setGroupIdentifier(this.m_currentBatchIdentifier.getTime());
                this.notifyBatchClassifierListeners(this.m_outputQueues[runNum - 1][i]);
                this.m_outputQueues[runNum - 1][i] = null;
                this.m_completedSets[runNum - 1][i] = true;
            }
            ++i;
        }
        boolean done = true;
        int i2 = 0;
        while (i2 < maxRunNum) {
            int j = 0;
            while (j < maxSets) {
                if (!this.m_completedSets[i2][j]) {
                    done = false;
                    break;
                }
                ++j;
            }
            if (!done) break;
            ++i2;
        }
        if (done) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Seventh"))).append(this.statusMessagePrefix());
            Messages.getInstance();
            String msg = stringBuilder.append(Messages.getString("Classifier_AcceptTestSet_Msg_Text_Eighth")).toString();
            if (this.m_log != null) {
                this.m_log.logMessage(msg);
            } else {
                System.err.println(msg);
            }
            if (this.m_log != null) {
                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder3.append(Messages.getString("Classifier_AcceptTestSet_StatusMessage_Text_Second")).toString());
            }
            this.m_batchStarted = false;
            this.block(false);
            this.m_block = false;
            this.m_state = IDLE;
        }
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        String name = this.m_ClassifierTemplate.getClass().toString();
        String packageName = name.substring(0, name.lastIndexOf(46));
        if (!this.m_visual.loadIcons("weka/gui/beans/icons/Default_" + (packageName = packageName.substring(packageName.lastIndexOf(46) + 1, packageName.length())) + "Classifier.gif", "weka/gui/beans/icons/Default_" + packageName + "Classifier_animated.gif")) {
            this.m_visual.loadIcons("weka/gui/beans/icons/DefaultClassifier.gif", "weka/gui/beans/icons/DefaultClassifier_animated.gif");
        }
    }

    public synchronized void addBatchClassifierListener(BatchClassifierListener cl) {
        this.m_batchClassifierListeners.addElement(cl);
    }

    public synchronized void removeBatchClassifierListener(BatchClassifierListener cl) {
        this.m_batchClassifierListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyBatchClassifierListeners(BatchClassifierEvent ce) {
        Vector l;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_batchClassifierListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((BatchClassifierListener)l.elementAt(i)).acceptClassifier(ce);
                ++i;
            }
        }
    }

    public synchronized void addGraphListener(GraphListener cl) {
        this.m_graphListeners.addElement(cl);
    }

    public synchronized void removeGraphListener(GraphListener cl) {
        this.m_graphListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyGraphListeners(GraphEvent ge) {
        Vector l;
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_graphListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((GraphListener)l.elementAt(i)).acceptGraph(ge);
                ++i;
            }
        }
    }

    public synchronized void addTextListener(TextListener cl) {
        this.m_textListeners.addElement(cl);
    }

    public synchronized void removeTextListener(TextListener cl) {
        this.m_textListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyTextListeners(TextEvent ge) {
        Vector l;
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_textListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((TextListener)l.elementAt(i)).acceptText(ge);
                ++i;
            }
        }
    }

    public synchronized void addIncrementalClassifierListener(IncrementalClassifierListener cl) {
        this.m_incrementalClassifierListeners.add(cl);
    }

    public synchronized void removeIncrementalClassifierListener(IncrementalClassifierListener cl) {
        this.m_incrementalClassifierListeners.remove(cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIncrementalClassifierListeners(IncrementalClassifierEvent ce) {
        Vector l;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Classifier classifier = this;
        synchronized (classifier) {
            l = (Vector)this.m_incrementalClassifierListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((IncrementalClassifierListener)l.elementAt(i)).acceptClassifier(ce);
                ++i;
            }
        }
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return !this.m_listenees.containsKey(eventName);
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (eventName.compareTo("instance") == 0 && !(this.m_ClassifierTemplate instanceof UpdateableClassifier) && this.m_log != null) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Classifier_ConnectionNotification_Msg_Text_First")).append(this.m_ClassifierTemplate.getClass().getName());
            Messages.getInstance();
            String msg = stringBuilder2.append(Messages.getString("Classifier_ConnectionNotification_Msg_Text_Second")).toString();
            Messages.getInstance();
            this.m_log.logMessage(String.valueOf(Messages.getString("Classifier_ConnectionNotification_LogMessage_Text_First")) + msg);
            this.m_log.statusMessage(msg);
        }
        if (this.connectionAllowed(eventName)) {
            this.m_listenees.put(eventName, source);
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        this.m_listenees.remove(eventName);
        if (eventName.compareTo("instance") == 0) {
            this.stop();
        }
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public void stop() {
        Enumeration en = this.m_listenees.keys();
        while (en.hasMoreElements()) {
            Object tempO = this.m_listenees.get(en.nextElement());
            if (!(tempO instanceof BeanCommon)) continue;
            ((BeanCommon)tempO).stop();
        }
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
            this.m_executorPool.purge();
            this.m_executorPool = null;
        }
        this.m_block = false;
        this.m_batchStarted = false;
        this.m_visual.setStatic();
        this.m_oldText.length();
    }

    public void loadModel() {
        block19: {
            try {
                int returnVal;
                if (this.m_fileChooser == null) {
                    this.setupFileChooser();
                }
                if ((returnVal = this.m_fileChooser.showOpenDialog(this)) != 0) break block19;
                File loadFrom = this.m_fileChooser.getSelectedFile();
                if (this.m_fileChooser.getFileFilter() == this.m_binaryFilter) {
                    if (!loadFrom.getName().toLowerCase().endsWith(".model")) {
                        loadFrom = new File(loadFrom.getParent(), String.valueOf(loadFrom.getName()) + "." + FILE_EXTENSION);
                    }
                } else if (this.m_fileChooser.getFileFilter() == this.m_KOMLFilter) {
                    if (!loadFrom.getName().toLowerCase().endsWith(".komlmodel")) {
                        loadFrom = new File(loadFrom.getParent(), String.valueOf(loadFrom.getName()) + ".koml" + FILE_EXTENSION);
                    }
                } else if (this.m_fileChooser.getFileFilter() == this.m_XStreamFilter && !loadFrom.getName().toLowerCase().endsWith(".xstreammodel")) {
                    loadFrom = new File(loadFrom.getParent(), String.valueOf(loadFrom.getName()) + ".xstream" + FILE_EXTENSION);
                }
                weka.classifiers.Classifier temp = null;
                Instances tempHeader = null;
                if (KOML.isPresent() && loadFrom.getAbsolutePath().toLowerCase().endsWith(".komlmodel")) {
                    Vector v = (Vector)KOML.read(loadFrom.getAbsolutePath());
                    temp = (weka.classifiers.Classifier)v.elementAt(0);
                    if (v.size() == 2) {
                        tempHeader = (Instances)v.elementAt(1);
                    }
                } else if (XStream.isPresent() && loadFrom.getAbsolutePath().toLowerCase().endsWith(".xstreammodel")) {
                    Vector v = (Vector)XStream.read(loadFrom.getAbsolutePath());
                    temp = (weka.classifiers.Classifier)v.elementAt(0);
                    if (v.size() == 2) {
                        tempHeader = (Instances)v.elementAt(1);
                    }
                } else {
                    ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(loadFrom)));
                    temp = (weka.classifiers.Classifier)is.readObject();
                    try {
                        tempHeader = (Instances)is.readObject();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    is.close();
                }
                this.setTrainedClassifier(temp);
                this.m_trainingSet = tempHeader;
                if (this.m_log != null) {
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                    Messages.getInstance();
                    this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_ConnectionNotification_StatusMessage_Text_First")).toString());
                    Messages.getInstance();
                    StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("Classifier_ConnectionNotification_LogMessage_Text_Second"))).append(this.statusMessagePrefix());
                    Messages.getInstance();
                    this.m_log.logMessage(stringBuilder2.append(Messages.getString("Classifier_ConnectionNotification_LogMessage_Text_Third")).append(this.m_Classifier.getClass().toString()).toString());
                }
            }
            catch (Exception ex) {
                Messages.getInstance();
                String string = Messages.getString("Classifier_ConnectionNotification_JOptionPane_ShowMessageDialog_Text_First");
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("Classifier_ConnectionNotification_JOptionPane_ShowMessageDialog_Text_Second"), 0);
                if (this.m_log == null) break block19;
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_ConnectionNotification_StatusMessage_Text_Second")).toString());
                Messages.getInstance();
                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("Classifier_ConnectionNotification_LogMessage_Text_Fourth"))).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder3.append(Messages.getString("Classifier_ConnectionNotification_LogMessage_Text_Fifth")).append(ex.getMessage()).toString());
            }
        }
    }

    public void saveModel() {
        block17: {
            try {
                int returnVal;
                if (this.m_fileChooser == null) {
                    this.setupFileChooser();
                }
                if ((returnVal = this.m_fileChooser.showSaveDialog(this)) == 0) {
                    File saveTo = this.m_fileChooser.getSelectedFile();
                    String fn = saveTo.getAbsolutePath();
                    if (this.m_fileChooser.getFileFilter() == this.m_binaryFilter) {
                        if (!fn.toLowerCase().endsWith(".model")) {
                            fn = String.valueOf(fn) + ".model";
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_KOMLFilter) {
                        if (!fn.toLowerCase().endsWith(".komlmodel")) {
                            fn = String.valueOf(fn) + ".komlmodel";
                        }
                    } else if (this.m_fileChooser.getFileFilter() == this.m_XStreamFilter && !fn.toLowerCase().endsWith(".xstreammodel")) {
                        fn = String.valueOf(fn) + ".xstreammodel";
                    }
                    saveTo = new File(fn);
                    if (KOML.isPresent() && saveTo.getAbsolutePath().toLowerCase().endsWith(".komlmodel")) {
                        SerializedModelSaver.saveKOML(saveTo, this.m_Classifier, this.m_trainingSet != null ? new Instances(this.m_trainingSet, 0) : null);
                    } else if (XStream.isPresent() && saveTo.getAbsolutePath().toLowerCase().endsWith(".xstreammodel")) {
                        SerializedModelSaver.saveXStream(saveTo, this.m_Classifier, this.m_trainingSet != null ? new Instances(this.m_trainingSet, 0) : null);
                    } else {
                        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(saveTo)));
                        os.writeObject(this.m_Classifier);
                        if (this.m_trainingSet != null) {
                            Instances header = new Instances(this.m_trainingSet, 0);
                            os.writeObject(header);
                        }
                        os.close();
                    }
                    if (this.m_log != null) {
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                        Messages.getInstance();
                        this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_SaveModel_StatusMessage_Text_First")).toString());
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("Classifier_SaveModel_LogMessage_Text_First"))).append(this.statusMessagePrefix());
                        Messages.getInstance();
                        this.m_log.logMessage(stringBuilder2.append(Messages.getString("Classifier_SaveModel_LogMessage_Text_Second")).append(this.getCustomName()).toString());
                    }
                }
            }
            catch (Exception ex) {
                Messages.getInstance();
                String string = Messages.getString("Classifier_SaveModel_JOptionPane_ShowMessageDialog_Text_First");
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("Classifier_SaveModel_JOptionPane_ShowMessageDialog_Text_Second"), 0);
                if (this.m_log == null) break block17;
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.statusMessagePrefix()));
                Messages.getInstance();
                this.m_log.statusMessage(stringBuilder.append(Messages.getString("Classifier_SaveModel_StatusMessage_Text_Second")).toString());
                Messages.getInstance();
                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("Classifier_SaveModel_LogMessage_Text_Third"))).append(this.statusMessagePrefix());
                Messages.getInstance();
                this.m_log.logMessage(stringBuilder3.append(Messages.getString("Classifier_SaveModel_LogMessage_Text_Fourth")).append(this.getCustomName()).append(ex.getMessage()).toString());
            }
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_executorPool != null && (this.m_executorPool.getQueue().size() > 0 || this.m_executorPool.getActiveCount() > 0)) {
            newVector.addElement("Stop");
        }
        if ((this.m_executorPool == null || this.m_executorPool.getQueue().size() == 0 && this.m_executorPool.getActiveCount() == 0) && this.m_Classifier != null) {
            newVector.addElement("Save model");
        }
        if (this.m_executorPool == null || this.m_executorPool.getQueue().size() == 0 && this.m_executorPool.getActiveCount() == 0) {
            newVector.addElement("Load model");
        }
        return newVector.elements();
    }

    @Override
    public void performRequest(String request) {
        if (request.compareTo("Stop") == 0) {
            this.stop();
        } else if (request.compareTo("Save model") == 0) {
            this.saveModel();
        } else if (request.compareTo("Load model") == 0) {
            this.loadModel();
        } else {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(request));
            Messages.getInstance();
            throw new IllegalArgumentException(stringBuilder.append(Messages.getString("Classifier_PerformRequest_IllegalArgumentException_Text")).toString());
        }
    }

    public boolean eventGeneratable(EventSetDescriptor esd) {
        String eventName = esd.getName();
        return this.eventGeneratable(eventName);
    }

    private boolean generatableEvent(String eventName) {
        return eventName.compareTo("graph") == 0 || eventName.compareTo("text") == 0 || eventName.compareTo("batchClassifier") == 0 || eventName.compareTo("incrementalClassifier") == 0;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        Object source;
        if (!this.generatableEvent(eventName)) {
            return false;
        }
        if (eventName.compareTo("graph") == 0) {
            if (!(this.m_ClassifierTemplate instanceof Drawable)) {
                return false;
            }
            if (!this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (eventName.compareTo("batchClassifier") == 0) {
            if (!this.m_listenees.containsKey("testSet") && !this.m_listenees.containsKey("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("testSet");
            if (source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("testSet")) {
                return false;
            }
        }
        if (eventName.compareTo("text") == 0) {
            if (!this.m_listenees.containsKey("trainingSet") && !this.m_listenees.containsKey("instance")) {
                return false;
            }
            source = this.m_listenees.get("trainingSet");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("trainingSet")) {
                return false;
            }
            source = this.m_listenees.get("instance");
            if (source != null && source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("instance")) {
                return false;
            }
        }
        if (eventName.compareTo("incrementalClassifier") == 0) {
            if (!this.m_listenees.containsKey("instance")) {
                return false;
            }
            source = this.m_listenees.get("instance");
            if (source instanceof EventConstraints && !((EventConstraints)source).eventGeneratable("instance")) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isBusy() {
        return this.m_executorPool != null && (this.m_executorPool.getQueue().size() != 0 || this.m_executorPool.getActiveCount() != 0 || this.m_state != IDLE);
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|" + (this.m_Classifier instanceof OptionHandler && Utils.joinOptions(this.m_ClassifierTemplate.getOptions()).length() > 0 ? String.valueOf(Utils.joinOptions(this.m_ClassifierTemplate.getOptions())) + "|" : "");
    }

    protected class TrainingTask
    implements Runnable,
    Task {
        private final int m_runNum;
        private final int m_maxRunNum;
        private final int m_setNum;
        private final int m_maxSetNum;
        private Instances m_train = null;
        private final TaskStatusInfo m_taskInfo = new TaskStatusInfo();

        public TrainingTask(int runNum, int maxRunNum, int setNum, int maxSetNum, Instances train) {
            this.m_runNum = runNum;
            this.m_maxRunNum = maxRunNum;
            this.m_setNum = setNum;
            this.m_maxSetNum = maxSetNum;
            this.m_train = train;
            this.m_taskInfo.setExecutionStatus(0);
        }

        @Override
        public void run() {
            this.execute();
        }

        @Override
        public void execute() {
            block21: {
                try {
                    if (this.m_train == null) break block21;
                    if (this.m_train.classIndex() < 0) {
                        Classifier.this.stop();
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Classifier.this.statusMessagePrefix()));
                        Messages.getInstance();
                        String errorMessage = stringBuilder.append(Messages.getString("Classifier_TrainingTask_Execute_ErrorMessage_Text_First")).toString();
                        if (Classifier.this.m_log != null) {
                            Classifier.this.m_log.statusMessage(errorMessage);
                            Logger logger = Classifier.this.m_log;
                            Messages.getInstance();
                            logger.logMessage(String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_LogMessage_Text_First")) + errorMessage);
                        } else {
                            Messages.getInstance();
                            System.err.println(String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_Error_Text_First")) + errorMessage);
                        }
                        return;
                    }
                    try {
                        if (this.m_runNum == 1 && this.m_setNum == 1) {
                            Classifier.this.m_state = BUILDING_MODEL;
                            this.m_taskInfo.setExecutionStatus(1);
                        }
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Classifier.this.statusMessagePrefix()));
                        Messages.getInstance();
                        StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("Classifier_TrainingTask_Execute_Msg_Text_First")).append(this.m_runNum);
                        Messages.getInstance();
                        String msg = stringBuilder2.append(Messages.getString("Classifier_TrainingTask_Execute_Msg_Text_Second")).append(this.m_setNum).toString();
                        if (Classifier.this.m_log != null) {
                            Classifier.this.m_log.statusMessage(msg);
                        } else {
                            System.err.println(msg);
                        }
                        weka.classifiers.Classifier classifierCopy = weka.classifiers.Classifier.makeCopy(Classifier.this.m_ClassifierTemplate);
                        classifierCopy.buildClassifier(this.m_train);
                        if (this.m_runNum == this.m_maxRunNum && this.m_setNum == this.m_maxSetNum) {
                            Classifier.this.m_Classifier = classifierCopy;
                            Classifier.this.m_trainingSet = new Instances(this.m_train, 0);
                        }
                        BatchClassifierEvent ce = new BatchClassifierEvent(Classifier.this, classifierCopy, new DataSetEvent(this, this.m_train), null, this.m_setNum, this.m_maxSetNum);
                        ce.setGroupIdentifier(Classifier.this.m_currentBatchIdentifier.getTime());
                        Classifier.this.notifyBatchClassifierListeners(ce);
                        Classifier.this.classifierTrainingComplete(ce);
                        if (classifierCopy instanceof Drawable && Classifier.this.m_graphListeners.size() > 0) {
                            String grphString = ((Drawable)((Object)classifierCopy)).graph();
                            int grphType = ((Drawable)((Object)classifierCopy)).graphType();
                            String grphTitle = classifierCopy.getClass().getName();
                            grphTitle = grphTitle.substring(grphTitle.lastIndexOf(46) + 1, grphTitle.length());
                            Messages.getInstance();
                            grphTitle = String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_GrphTitle_Text_First")) + this.m_setNum + " (" + this.m_train.relationName() + ") " + grphTitle;
                            GraphEvent ge = new GraphEvent(Classifier.this, grphString, grphTitle, grphType);
                            Classifier.this.notifyGraphListeners(ge);
                        }
                        if (Classifier.this.m_textListeners.size() > 0) {
                            String string;
                            String modelString = classifierCopy.toString();
                            String titleString = classifierCopy.getClass().getName();
                            titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_ModelString_Text_First"))).append(titleString).append("\n");
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("Classifier_TrainingTask_Execute_ModelString_Text_Second")).append(this.m_train.relationName());
                            if (this.m_maxSetNum > 1) {
                                Messages.getInstance();
                                string = String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_ModelString_Text_Third")) + this.m_setNum;
                            } else {
                                string = "";
                            }
                            modelString = stringBuilder4.append(string).append("\n\n").append(modelString).toString();
                            Messages.getInstance();
                            titleString = String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_TitleString_Text_First")) + titleString;
                            TextEvent nt = new TextEvent(Classifier.this, modelString, titleString);
                            Classifier.this.notifyTextListeners(nt);
                        }
                    }
                    catch (Exception ex) {
                        Classifier.this.stop();
                        ex.printStackTrace();
                        if (Classifier.this.m_log != null) {
                            Messages.getInstance();
                            String titleString = String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_TitleString_Text_Second")) + Classifier.this.statusMessagePrefix();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(titleString));
                            Messages.getInstance();
                            StringBuilder stringBuilder5 = stringBuilder.append(Messages.getString("Classifier_TrainingTask_Execute_TitleString_Text_Third")).append(this.m_runNum);
                            Messages.getInstance();
                            StringBuilder stringBuilder6 = stringBuilder5.append(Messages.getString("Classifier_TrainingTask_Execute_TitleString_Text_Fourth")).append(this.m_setNum);
                            Messages.getInstance();
                            titleString = stringBuilder6.append(Messages.getString("Classifier_TrainingTask_Execute_TitleString_Text_Fifth")).toString();
                            Logger logger = Classifier.this.m_log;
                            StringBuilder stringBuilder7 = new StringBuilder(String.valueOf(titleString));
                            Messages.getInstance();
                            logger.logMessage(stringBuilder7.append(Messages.getString("Classifier_TrainingTask_Execute_LogMessage_Text_Fourth")).append(ex.getMessage()).toString());
                            Logger logger2 = Classifier.this.m_log;
                            StringBuilder stringBuilder8 = new StringBuilder(String.valueOf(Classifier.this.statusMessagePrefix()));
                            Messages.getInstance();
                            logger2.statusMessage(stringBuilder8.append(Messages.getString("Classifier_TrainingTask_Execute_StatusMessage_Text_First")).toString());
                            ex.printStackTrace();
                        }
                        this.m_taskInfo.setExecutionStatus(2);
                    }
                }
                finally {
                    Classifier.this.m_visual.setStatic();
                    if (Classifier.this.m_log != null) {
                        Logger logger = Classifier.this.m_log;
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Classifier.this.statusMessagePrefix()));
                        Messages.getInstance();
                        logger.statusMessage(stringBuilder.append(Messages.getString("Classifier_TrainingTask_Execute_StatusMessage_Text_Second")).toString());
                    }
                    Classifier.this.m_state = IDLE;
                    if (Thread.currentThread().isInterrupted()) {
                        Classifier.this.m_trainingSet = null;
                        if (Classifier.this.m_log != null) {
                            Messages.getInstance();
                            String titleString = String.valueOf(Messages.getString("Classifier_TrainingTask_Execute_TitleString_Text_Sixth")) + Classifier.this.statusMessagePrefix();
                            Logger logger = Classifier.this.m_log;
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(titleString));
                            Messages.getInstance();
                            StringBuilder stringBuilder9 = stringBuilder.append(Messages.getString("Classifier_TrainingTask_Execute_LogMessage_Text_Fifth")).append(this.m_runNum);
                            Messages.getInstance();
                            StringBuilder stringBuilder10 = stringBuilder9.append(Messages.getString("Classifier_TrainingTask_Execute_LogMessage_Text_Sixth")).append(this.m_setNum);
                            Messages.getInstance();
                            logger.logMessage(stringBuilder10.append(Messages.getString("Classifier_TrainingTask_Execute_LogMessage_Text_Seventh")).toString());
                            Logger logger3 = Classifier.this.m_log;
                            StringBuilder stringBuilder11 = new StringBuilder(String.valueOf(Classifier.this.statusMessagePrefix()));
                            Messages.getInstance();
                            logger3.statusMessage(stringBuilder11.append(Messages.getString("Classifier_TrainingTask_Execute_LogMessage_Text_Seventh")).toString());
                        }
                    }
                }
            }
        }

        @Override
        public TaskStatusInfo getTaskStatus() {
            return null;
        }
    }
}

