/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import weka.core.Instances;
import weka.gui.AttributeVisualizationPanel;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataVisualizer;
import weka.gui.beans.Messages;

public class AttributeSummarizer
extends DataVisualizer {
    private static final long serialVersionUID = -294354961169372758L;
    protected int m_gridWidth = 4;
    protected int m_maxPlots = 100;
    protected int m_coloringIndex = -1;

    public AttributeSummarizer() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (!GraphicsEnvironment.isHeadless()) {
            this.appearanceFinal();
        }
    }

    @Override
    public String globalInfo() {
        Messages.getInstance();
        return Messages.getString("AttributeSummarizer_GlobalInfo_Text");
    }

    public void setColoringIndex(int ci) {
        this.m_coloringIndex = ci;
    }

    public int getColoringIndex() {
        return this.m_coloringIndex;
    }

    public void setGridWidth(int gw) {
        if (gw > 0) {
            this.m_bcSupport.firePropertyChange("gridWidth", new Integer(this.m_gridWidth), new Integer(gw));
            this.m_gridWidth = gw;
        }
    }

    public int getGridWidth() {
        return this.m_gridWidth;
    }

    public void setMaxPlots(int mp) {
        if (mp > 0) {
            this.m_bcSupport.firePropertyChange("maxPlots", new Integer(this.m_maxPlots), new Integer(mp));
            this.m_maxPlots = mp;
        }
    }

    public int getMaxPlots() {
        return this.m_maxPlots;
    }

    public void setDesign(boolean design) {
        this.m_design = true;
        this.appearanceDesign();
    }

    @Override
    protected void appearanceDesign() {
        this.removeAll();
        this.m_visual = new BeanVisual("AttributeSummarizer", "weka/gui/beans/icons/AttributeSummarizer.gif", "weka/gui/beans/icons/AttributeSummarizer_animated.gif");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
    }

    @Override
    protected void setUpFinal() {
        this.removeAll();
        JScrollPane hp = this.makePanel();
        this.add((Component)hp, "Center");
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultDataVisualizer.gif", "weka/gui/beans/icons/DefaultDataVisualizer_animated.gif");
    }

    @Override
    public Enumeration enumerateRequests() {
        Vector<String> newVector = new Vector<String>(0);
        if (this.m_visualizeDataSet != null) {
            newVector.addElement("Show summaries");
        }
        return newVector.elements();
    }

    private JScrollPane makePanel() {
        String fontFamily = this.getFont().getFamily();
        Font newFont = new Font(fontFamily, 0, 10);
        JPanel hp = new JPanel();
        hp.setFont(newFont);
        int numPlots = Math.min(this.m_visualizeDataSet.numAttributes(), this.m_maxPlots);
        int gridHeight = numPlots / this.m_gridWidth;
        if (numPlots % this.m_gridWidth != 0) {
            ++gridHeight;
        }
        hp.setLayout(new GridLayout(gridHeight, 4));
        int i = 0;
        while (i < numPlots) {
            JPanel temp = new JPanel();
            temp.setLayout(new BorderLayout());
            temp.setBorder(BorderFactory.createTitledBorder(this.m_visualizeDataSet.attribute(i).name()));
            AttributeVisualizationPanel ap = new AttributeVisualizationPanel();
            ap.setInstances(this.m_visualizeDataSet);
            if (this.m_coloringIndex < 0 && this.m_visualizeDataSet.classIndex() >= 0) {
                ap.setColoringIndex(this.m_visualizeDataSet.classIndex());
            } else {
                ap.setColoringIndex(this.m_coloringIndex);
            }
            temp.add((Component)ap, "Center");
            ap.setAttribute(i);
            hp.add(temp);
            ++i;
        }
        Dimension d = new Dimension(830, gridHeight * 100);
        hp.setMinimumSize(d);
        hp.setMaximumSize(d);
        hp.setPreferredSize(d);
        JScrollPane scroller = new JScrollPane(hp);
        return scroller;
    }

    @Override
    public void setInstances(Instances inst) throws Exception {
        if (this.m_design) {
            Messages.getInstance();
            throw new Exception(Messages.getString("AttributeSummarizer_SetInstances_Exception_Text"));
        }
        this.m_visualizeDataSet = inst;
        this.setUpFinal();
    }

    @Override
    public void performRequest(String request) {
        block6: {
            if (!this.m_design) {
                this.setUpFinal();
                return;
            }
            if (request.compareTo("Show summaries") == 0) {
                try {
                    if (!this.m_framePoppedUp) {
                        this.m_framePoppedUp = true;
                        JScrollPane holderP = this.makePanel();
                        Messages.getInstance();
                        final JFrame jf = new JFrame(Messages.getString("AttributeSummarizer_PerformRequest_Jf_JFrame_Text"));
                        jf.setSize(800, 600);
                        jf.getContentPane().setLayout(new BorderLayout());
                        jf.getContentPane().add((Component)holderP, "Center");
                        jf.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e) {
                                jf.dispose();
                                AttributeSummarizer.this.m_framePoppedUp = false;
                            }
                        });
                        jf.setVisible(true);
                        this.m_popupFrame = jf;
                        break block6;
                    }
                    this.m_popupFrame.toFront();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.m_framePoppedUp = false;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(request));
                Messages.getInstance();
                throw new IllegalArgumentException(stringBuilder.append(Messages.getString("AttributeSummarizer_PerformRequest_IllegalArgumentException_Text")).toString());
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                Messages.getInstance();
                System.err.println(Messages.getString("AttributeSummarizer_Main_Error_Text_First"));
                System.exit(1);
            }
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            Instances inst = new Instances(r);
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            AttributeSummarizer as = new AttributeSummarizer();
            as.setInstances(inst);
            jf.getContentPane().add((Component)as, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(830, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

