/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.arffviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import weka.core.Instances;
import weka.core.Undoable;
import weka.core.Utils;
import weka.gui.ComponentHelper;
import weka.gui.JTableHelper;
import weka.gui.ListSelectorDialog;
import weka.gui.arffviewer.ArffSortedTableModel;
import weka.gui.arffviewer.ArffTable;
import weka.gui.arffviewer.ArffTableCellRenderer;
import weka.gui.arffviewer.Messages;

public class ArffPanel
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
Undoable {
    static final long serialVersionUID = -4697041150989513939L;
    public static final String TAB_INSTANCES;
    private ArffTable m_TableArff;
    private JPopupMenu m_PopupHeader;
    private JPopupMenu m_PopupRows;
    private JLabel m_LabelName;
    private JMenuItem menuItemMean;
    private JMenuItem menuItemSetAllValues;
    private JMenuItem menuItemSetMissingValues;
    private JMenuItem menuItemReplaceValues;
    private JMenuItem menuItemRenameAttribute;
    private JMenuItem menuItemAttributeAsClass;
    private JMenuItem menuItemDeleteAttribute;
    private JMenuItem menuItemDeleteAttributes;
    private JMenuItem menuItemSortInstances;
    private JMenuItem menuItemDeleteSelectedInstance;
    private JMenuItem menuItemDeleteAllSelectedInstances;
    private JMenuItem menuItemSearch;
    private JMenuItem menuItemClearSearch;
    private JMenuItem menuItemUndo;
    private JMenuItem menuItemCopy;
    private JMenuItem menuItemOptimalColWidth;
    private JMenuItem menuItemOptimalColWidths;
    private String m_Filename;
    private String m_Title;
    private int m_CurrentCol;
    private boolean m_Changed;
    private HashSet m_ChangeListeners;
    private String m_LastSearch;
    private String m_LastReplace;

    static {
        Messages.getInstance();
        TAB_INSTANCES = Messages.getString("ArffPanel_TabInstanses_Text");
    }

    public ArffPanel() {
        this.initialize();
        this.createPanel();
    }

    public ArffPanel(String filename) {
        this();
        this.loadFile(filename);
    }

    public ArffPanel(Instances data) {
        this();
        this.m_Filename = "";
        this.setInstances(data);
    }

    protected void initialize() {
        this.m_Filename = "";
        this.m_Title = "";
        this.m_CurrentCol = -1;
        this.m_LastSearch = "";
        this.m_LastReplace = "";
        this.m_Changed = false;
        this.m_ChangeListeners = new HashSet();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        Messages.getInstance();
        this.menuItemMean = new JMenuItem(Messages.getString("ArffPanel_GetMean_JMenuItem_Text"));
        this.menuItemMean.addActionListener(this);
        Messages.getInstance();
        this.menuItemSetAllValues = new JMenuItem(Messages.getString("ArffPanel_SetAllValuesTo_JMenuItem_Text"));
        this.menuItemSetAllValues.addActionListener(this);
        Messages.getInstance();
        this.menuItemSetMissingValues = new JMenuItem(Messages.getString("ArffPanel_SetMissingValues_JMenuItem_Text"));
        this.menuItemSetMissingValues.addActionListener(this);
        Messages.getInstance();
        this.menuItemReplaceValues = new JMenuItem(Messages.getString("ArffPanel_ReplaceValues_JMenuItem_Text"));
        this.menuItemReplaceValues.addActionListener(this);
        Messages.getInstance();
        this.menuItemRenameAttribute = new JMenuItem(Messages.getString("ArffPanel_RenameAttribute_JMenuItem_Text"));
        this.menuItemRenameAttribute.addActionListener(this);
        Messages.getInstance();
        this.menuItemAttributeAsClass = new JMenuItem(Messages.getString("ArffPanel_AttributeAsClass_JMenuItem_Text"));
        this.menuItemAttributeAsClass.addActionListener(this);
        Messages.getInstance();
        this.menuItemDeleteAttribute = new JMenuItem(Messages.getString("ArffPanel_DeleteAttribute_JMenuItem_Text"));
        this.menuItemDeleteAttribute.addActionListener(this);
        Messages.getInstance();
        this.menuItemDeleteAttributes = new JMenuItem(Messages.getString("ArffPanel_DeleteAttributes_JMenuItem_Text"));
        this.menuItemDeleteAttributes.addActionListener(this);
        Messages.getInstance();
        this.menuItemSortInstances = new JMenuItem(Messages.getString("ArffPanel_SortInstances_JMenuItem_Text"));
        this.menuItemSortInstances.addActionListener(this);
        Messages.getInstance();
        this.menuItemOptimalColWidth = new JMenuItem(Messages.getString("ArffPanel_OptimalColWidth_JMenuItem_Text"));
        this.menuItemOptimalColWidth.addActionListener(this);
        Messages.getInstance();
        this.menuItemOptimalColWidths = new JMenuItem(Messages.getString("ArffPanel_OptimalColWidths_JMenuItem_Text"));
        this.menuItemOptimalColWidths.addActionListener(this);
        Messages.getInstance();
        this.menuItemUndo = new JMenuItem(Messages.getString("ArffPanel_Undo_JMenuItem_Text"));
        this.menuItemUndo.addActionListener(this);
        Messages.getInstance();
        this.menuItemCopy = new JMenuItem(Messages.getString("ArffPanel_Copy_JMenuItem_Text"));
        this.menuItemCopy.addActionListener(this);
        Messages.getInstance();
        this.menuItemSearch = new JMenuItem(Messages.getString("ArffPanel_Search_JMenuItem_Text"));
        this.menuItemSearch.addActionListener(this);
        Messages.getInstance();
        this.menuItemClearSearch = new JMenuItem(Messages.getString("ArffPanel_ClearSearch_JMenuItem_Text"));
        this.menuItemClearSearch.addActionListener(this);
        Messages.getInstance();
        this.menuItemDeleteSelectedInstance = new JMenuItem(Messages.getString("ArffPanel_DeleteSelectedInstance_JMenuItem_Text"));
        this.menuItemDeleteSelectedInstance.addActionListener(this);
        Messages.getInstance();
        this.menuItemDeleteAllSelectedInstances = new JMenuItem(Messages.getString("ArffPanel_DeleteAllSelectedInstances_JMenuItem_Text"));
        this.menuItemDeleteAllSelectedInstances.addActionListener(this);
        this.m_TableArff = new ArffTable();
        Messages.getInstance();
        this.m_TableArff.setToolTipText(Messages.getString("ArffPanel_ToolTipText_Text"));
        this.m_TableArff.getTableHeader().addMouseListener(this);
        JTableHeader jTableHeader = this.m_TableArff.getTableHeader();
        Messages.getInstance();
        jTableHeader.setToolTipText(String.valueOf(Messages.getString("ArffPanel_TableHeader_ToolTipText_Text")) + "<html><b>Sort view:</b> left click = ascending / Shift + left click = descending<br><b>Menu:</b> right click (or left+alt)</html>");
        this.m_TableArff.getTableHeader().setDefaultRenderer(new ArffTableCellRenderer());
        this.m_TableArff.addChangeListener(this);
        this.m_TableArff.addMouseListener(this);
        JScrollPane pane = new JScrollPane(this.m_TableArff);
        this.add((Component)pane, "Center");
        this.m_LabelName = new JLabel();
        this.add((Component)this.m_LabelName, "North");
    }

    private void initPopupMenus() {
        this.m_PopupHeader = new JPopupMenu();
        this.m_PopupHeader.addMouseListener(this);
        this.m_PopupHeader.add(this.menuItemMean);
        if (!this.isReadOnly()) {
            this.m_PopupHeader.addSeparator();
            this.m_PopupHeader.add(this.menuItemSetAllValues);
            this.m_PopupHeader.add(this.menuItemSetMissingValues);
            this.m_PopupHeader.add(this.menuItemReplaceValues);
            this.m_PopupHeader.addSeparator();
            this.m_PopupHeader.add(this.menuItemRenameAttribute);
            this.m_PopupHeader.add(this.menuItemAttributeAsClass);
            this.m_PopupHeader.add(this.menuItemDeleteAttribute);
            this.m_PopupHeader.add(this.menuItemDeleteAttributes);
            this.m_PopupHeader.add(this.menuItemSortInstances);
        }
        this.m_PopupHeader.addSeparator();
        this.m_PopupHeader.add(this.menuItemOptimalColWidth);
        this.m_PopupHeader.add(this.menuItemOptimalColWidths);
        this.m_PopupRows = new JPopupMenu();
        this.m_PopupRows.addMouseListener(this);
        if (!this.isReadOnly()) {
            this.m_PopupRows.add(this.menuItemUndo);
            this.m_PopupRows.addSeparator();
        }
        this.m_PopupRows.add(this.menuItemCopy);
        this.m_PopupRows.addSeparator();
        this.m_PopupRows.add(this.menuItemSearch);
        this.m_PopupRows.add(this.menuItemClearSearch);
        if (!this.isReadOnly()) {
            this.m_PopupRows.addSeparator();
            this.m_PopupRows.add(this.menuItemDeleteSelectedInstance);
            this.m_PopupRows.add(this.menuItemDeleteAllSelectedInstances);
        }
    }

    private void setMenu() {
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        boolean isNull = model.getInstances() == null;
        boolean hasColumns = !isNull && model.getInstances().numAttributes() > 0;
        boolean hasRows = !isNull && model.getInstances().numInstances() > 0;
        boolean attSelected = hasColumns && this.m_CurrentCol > 0;
        boolean isNumeric = attSelected && model.getAttributeAt(this.m_CurrentCol).isNumeric();
        this.menuItemUndo.setEnabled(this.canUndo());
        this.menuItemCopy.setEnabled(true);
        this.menuItemSearch.setEnabled(true);
        this.menuItemClearSearch.setEnabled(true);
        this.menuItemMean.setEnabled(isNumeric);
        this.menuItemSetAllValues.setEnabled(attSelected);
        this.menuItemSetMissingValues.setEnabled(attSelected);
        this.menuItemReplaceValues.setEnabled(attSelected);
        this.menuItemRenameAttribute.setEnabled(attSelected);
        this.menuItemDeleteAttribute.setEnabled(attSelected);
        this.menuItemDeleteAttributes.setEnabled(attSelected);
        this.menuItemSortInstances.setEnabled(hasRows && attSelected);
        this.menuItemDeleteSelectedInstance.setEnabled(hasRows && this.m_TableArff.getSelectedRow() > -1);
        this.menuItemDeleteAllSelectedInstances.setEnabled(hasRows && this.m_TableArff.getSelectedRows().length > 0);
    }

    public ArffTable getTable() {
        return this.m_TableArff;
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String getFilename() {
        return this.m_Filename;
    }

    public void setFilename(String filename) {
        this.m_Filename = filename;
        this.createTitle();
    }

    public Instances getInstances() {
        Instances result = null;
        if (this.m_TableArff.getModel() != null) {
            result = ((ArffSortedTableModel)this.m_TableArff.getModel()).getInstances();
        }
        return result;
    }

    public void setInstances(Instances data) {
        this.m_Filename = TAB_INSTANCES;
        this.createTitle();
        ArffSortedTableModel model = new ArffSortedTableModel(data);
        this.m_TableArff.setModel(model);
        this.clearUndo();
        this.setChanged(false);
        this.createName();
    }

    public Vector getAttributes() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.getInstances().numAttributes()) {
            result.add(this.getInstances().attribute(i).name());
            ++i;
        }
        Collections.sort(result);
        return result;
    }

    public void setChanged(boolean changed) {
        if (!changed) {
            this.m_Changed = changed;
            this.createTitle();
        }
    }

    public boolean isChanged() {
        return this.m_Changed;
    }

    public boolean isReadOnly() {
        if (this.m_TableArff == null) {
            return true;
        }
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).isReadOnly();
    }

    public void setReadOnly(boolean value) {
        if (this.m_TableArff != null) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).setReadOnly(value);
        }
    }

    @Override
    public boolean isUndoEnabled() {
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).isUndoEnabled();
    }

    @Override
    public void setUndoEnabled(boolean enabled) {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).setUndoEnabled(enabled);
    }

    @Override
    public void clearUndo() {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).clearUndo();
    }

    @Override
    public boolean canUndo() {
        return ((ArffSortedTableModel)this.m_TableArff.getModel()).canUndo();
    }

    @Override
    public void undo() {
        if (this.canUndo()) {
            ((ArffSortedTableModel)this.m_TableArff.getModel()).undo();
            this.notifyListener();
        }
    }

    @Override
    public void addUndoPoint() {
        ((ArffSortedTableModel)this.m_TableArff.getModel()).addUndoPoint();
        this.setMenu();
    }

    private void createTitle() {
        if (this.m_Filename.equals("")) {
            Messages.getInstance();
            this.m_Title = Messages.getString("ArffPanel_CreateTitle_Title_Text");
        } else if (this.m_Filename.equals(TAB_INSTANCES)) {
            this.m_Title = TAB_INSTANCES;
        } else {
            try {
                File file = new File(this.m_Filename);
                this.m_Title = file.getName();
            }
            catch (Exception e) {
                Messages.getInstance();
                this.m_Title = Messages.getString("ArffPanel_CreateTitle_Title_Text");
            }
        }
        if (this.isChanged()) {
            this.m_Title = String.valueOf(this.m_Title) + " *";
        }
    }

    private void createName() {
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model != null && model.getInstances() != null) {
            Messages.getInstance();
            this.m_LabelName.setText(String.valueOf(Messages.getString("ArffPanel_CreateName_Text")) + model.getInstances().relationName());
        } else {
            this.m_LabelName.setText("");
        }
    }

    private void loadFile(String filename) {
        this.m_Filename = filename;
        this.createTitle();
        ArffSortedTableModel model = filename.equals("") ? null : new ArffSortedTableModel(filename);
        this.m_TableArff.setModel(model);
        this.setChanged(false);
        this.createName();
    }

    private void calcMean() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (!model.getAttributeAt(this.m_CurrentCol).isNumeric()) {
            return;
        }
        double mean = 0.0;
        int i = 0;
        while (i < model.getRowCount()) {
            mean += model.getInstances().instance(i).value(this.m_CurrentCol - 1);
            ++i;
        }
        mean /= (double)model.getRowCount();
        Container container = this.getParent();
        Messages.getInstance();
        String string = Messages.getString("ArffPanel_CalcMean_Text_First");
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ArffPanel_CalcMean_Text_Second"))).append(this.m_TableArff.getPlainColumnName(this.m_CurrentCol));
        Messages.getInstance();
        ComponentHelper.showMessageBox(container, string, stringBuilder.append(Messages.getString("ArffPanel_CalcMean_Text_Third")).append(Utils.doubleToString(mean, 3)).toString(), 2, -1);
    }

    private void setValues(Object o) {
        String msg;
        String title;
        String value = "";
        String valueNew = "";
        if (o == this.menuItemSetMissingValues) {
            Messages.getInstance();
            title = Messages.getString("ArffPanel_SetValues_Title_Text_First");
            Messages.getInstance();
            msg = Messages.getString("ArffPanel_SetValues_Message_Text_First");
        } else if (o == this.menuItemSetAllValues) {
            Messages.getInstance();
            title = Messages.getString("ArffPanel_SetValues_Title_Text_Second");
            Messages.getInstance();
            msg = Messages.getString("ArffPanel_SetValues_Message_Text_Second");
        } else if (o == this.menuItemReplaceValues) {
            Messages.getInstance();
            title = Messages.getString("ArffPanel_SetValues_Title_Text_Third");
            Messages.getInstance();
            msg = Messages.getString("ArffPanel_SetValues_Message_Text_Third");
        } else {
            return;
        }
        value = ComponentHelper.showInputBox(this.m_TableArff.getParent(), title, msg, this.m_LastSearch);
        if (value == null) {
            return;
        }
        this.m_LastSearch = value;
        if (o == this.menuItemReplaceValues) {
            Container container = this.m_TableArff.getParent();
            Messages.getInstance();
            valueNew = ComponentHelper.showInputBox(container, title, Messages.getString("ArffPanel_SetValues_ComponentHelperShowInputBox_Text"), this.m_LastReplace);
            if (valueNew == null) {
                return;
            }
            this.m_LastReplace = valueNew;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        model.setNotificationEnabled(false);
        this.addUndoPoint();
        model.setUndoEnabled(false);
        String valueCopy = value;
        String valueNewCopy = valueNew;
        int i = 0;
        while (i < this.m_TableArff.getRowCount()) {
            if (o == this.menuItemSetAllValues) {
                if (valueCopy.equals("NaN") || valueCopy.equals("?")) {
                    value = null;
                }
                model.setValueAt(value, i, this.m_CurrentCol);
            } else if (o == this.menuItemSetMissingValues && model.isMissingAt(i, this.m_CurrentCol)) {
                model.setValueAt(value, i, this.m_CurrentCol);
            } else if (o == this.menuItemReplaceValues && model.getValueAt(i, this.m_CurrentCol).toString().equals(value)) {
                if (valueNewCopy.equals("NaN") || valueNewCopy.equals("?")) {
                    valueNew = null;
                }
                model.setValueAt(valueNew, i, this.m_CurrentCol);
            }
            ++i;
        }
        model.setUndoEnabled(true);
        model.setNotificationEnabled(true);
        model.notifyListener(new TableModelEvent(model, 0, model.getRowCount(), this.m_CurrentCol, 0));
        this.m_TableArff.repaint();
    }

    public void deleteAttribute() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        Container container = this.getParent();
        Messages.getInstance();
        String string = Messages.getString("ArffPanel_DeleteAttribute_ComponentHelperShowMessageBox_Text_First");
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ArffPanel_DeleteAttribute_ComponentHelperShowMessageBox_Text_Second"))).append(model.getAttributeAt(this.m_CurrentCol).name());
        Messages.getInstance();
        if (ComponentHelper.showMessageBox(container, string, stringBuilder.append(Messages.getString("ArffPanel_DeleteAttribute_ComponentHelperShowMessageBox_Text_Third")).toString(), 0, 3) != 0) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.deleteAttributeAt(this.m_CurrentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteAttributes() {
        JList list = new JList(this.getAttributes());
        ListSelectorDialog dialog = new ListSelectorDialog(null, list);
        int result = dialog.showDialog();
        if (result != 0) {
            return;
        }
        Object[] atts = list.getSelectedValues();
        Container container = this.getParent();
        Messages.getInstance();
        String string = Messages.getString("ArffPanel_DeleteAttributes_ComponentHelperShowMessageBox_Text_First");
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ArffPanel_DeleteAttributes_ComponentHelperShowMessageBox_Text_Second"))).append(atts.length);
        Messages.getInstance();
        if (ComponentHelper.showMessageBox(container, string, stringBuilder.append(Messages.getString("ArffPanel_DeleteAttributes_ComponentHelperShowMessageBox_Text_Third")).toString(), 0, 3) != 0) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        int[] indices = new int[atts.length];
        int i = 0;
        while (i < atts.length) {
            indices[i] = model.getAttributeColumn(atts[i].toString());
            ++i;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.deleteAttributes(indices);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void attributeAsClass() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.attributeAsClassAt(this.m_CurrentCol);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void renameAttribute() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ArffSortedTableModel model = (ArffSortedTableModel)this.m_TableArff.getModel();
        if (model.getAttributeAt(this.m_CurrentCol) == null) {
            return;
        }
        Container container = this.getParent();
        Messages.getInstance();
        String string = Messages.getString("ArffPanel_RenameAttribute_ComponentHelperShowInputBox_Text_First");
        Messages.getInstance();
        String newName = ComponentHelper.showInputBox(container, string, Messages.getString("ArffPanel_RenameAttribute_ComponentHelperShowInputBox_Text_Second"), model.getAttributeAt(this.m_CurrentCol).name());
        if (newName == null) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        model.renameAttributeAt(this.m_CurrentCol, newName);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void deleteInstance() {
        int index = this.m_TableArff.getSelectedRow();
        if (index == -1) {
            return;
        }
        ((ArffSortedTableModel)this.m_TableArff.getModel()).deleteInstanceAt(index);
    }

    public void deleteInstances() {
        if (this.m_TableArff.getSelectedRow() == -1) {
            return;
        }
        int[] indices = this.m_TableArff.getSelectedRows();
        ((ArffSortedTableModel)this.m_TableArff.getModel()).deleteInstances(indices);
    }

    public void sortInstances() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        ((ArffSortedTableModel)this.m_TableArff.getModel()).sortInstances(this.m_CurrentCol);
    }

    public void copyContent() {
        StringSelection selection = this.getTable().getStringSelection();
        if (selection == null) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
    }

    public void search() {
        Container container = this.getParent();
        Messages.getInstance();
        String string = Messages.getString("ArffPanel_Search_ComponentHelperShowInputBox_Text_First");
        Messages.getInstance();
        String searchString = ComponentHelper.showInputBox(container, string, Messages.getString("ArffPanel_Search_ComponentHelperShowInputBox_Text_Second"), this.m_LastSearch);
        if (searchString != null) {
            this.m_LastSearch = searchString;
        }
        this.getTable().setSearchString(searchString);
    }

    public void clearSearch() {
        this.getTable().setSearchString("");
    }

    public void setOptimalColWidth() {
        if (this.m_CurrentCol == -1) {
            return;
        }
        JTableHelper.setOptimalColumnWidth(this.getTable(), this.m_CurrentCol);
    }

    public void setOptimalColWidths() {
        JTableHelper.setOptimalColumnWidth(this.getTable());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.menuItemMean) {
            this.calcMean();
        } else if (o == this.menuItemSetAllValues) {
            this.setValues(this.menuItemSetAllValues);
        } else if (o == this.menuItemSetMissingValues) {
            this.setValues(this.menuItemSetMissingValues);
        } else if (o == this.menuItemReplaceValues) {
            this.setValues(this.menuItemReplaceValues);
        } else if (o == this.menuItemRenameAttribute) {
            this.renameAttribute();
        } else if (o == this.menuItemAttributeAsClass) {
            this.attributeAsClass();
        } else if (o == this.menuItemDeleteAttribute) {
            this.deleteAttribute();
        } else if (o == this.menuItemDeleteAttributes) {
            this.deleteAttributes();
        } else if (o == this.menuItemDeleteSelectedInstance) {
            this.deleteInstance();
        } else if (o == this.menuItemDeleteAllSelectedInstances) {
            this.deleteInstances();
        } else if (o == this.menuItemSortInstances) {
            this.sortInstances();
        } else if (o == this.menuItemSearch) {
            this.search();
        } else if (o == this.menuItemClearSearch) {
            this.clearSearch();
        } else if (o == this.menuItemUndo) {
            this.undo();
        } else if (o == this.menuItemCopy) {
            this.copyContent();
        } else if (o == this.menuItemOptimalColWidth) {
            this.setOptimalColWidth();
        } else if (o == this.menuItemOptimalColWidths) {
            this.setOptimalColWidths();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int col = this.m_TableArff.columnAtPoint(e.getPoint());
        boolean popup = e.getButton() == 3 && e.getClickCount() == 1 || e.getButton() == 1 && e.getClickCount() == 1 && e.isAltDown() && !e.isControlDown() && !e.isShiftDown();
        boolean bl = popup = popup && this.getInstances() != null;
        if (e.getSource() == this.m_TableArff.getTableHeader()) {
            this.m_CurrentCol = col;
            if (popup) {
                e.consume();
                this.setMenu();
                this.initPopupMenus();
                this.m_PopupHeader.show(e.getComponent(), e.getX(), e.getY());
            }
        } else if (e.getSource() == this.m_TableArff && popup) {
            e.consume();
            this.setMenu();
            this.initPopupMenus();
            this.m_PopupRows.show(e.getComponent(), e.getX(), e.getY());
        }
        if (e.getButton() == 1 && e.getClickCount() == 1 && !e.isAltDown() && col > -1) {
            this.m_TableArff.setSelectedColumn(col);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.m_Changed = true;
        this.createTitle();
        this.notifyListener();
    }

    public void notifyListener() {
        Iterator iter = this.m_ChangeListeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }
}

