/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import weka.core.ClassDiscovery;
import weka.core.Trie;
import weka.core.Utils;
import weka.gui.Messages;

public class SimpleCLIPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -7377739469759943231L;
    protected static String FILENAME = "SimpleCLI.props";
    protected static String PROPERTY_FILE = "weka/gui/" + FILENAME;
    protected static Properties PROPERTIES;
    protected JTextArea m_OutputArea = new JTextArea();
    protected JTextField m_Input = new JTextField();
    protected Vector m_CommandHistory = new Vector();
    protected int m_HistoryPos = 0;
    protected PipedOutputStream m_POO = new PipedOutputStream();
    protected PipedOutputStream m_POE = new PipedOutputStream();
    protected Thread m_OutRedirector;
    protected Thread m_ErrRedirector;
    protected Thread m_RunThread;
    protected CommandlineCompletion m_Completion;

    static {
        try {
            PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            Enumeration<?> keys = PROPERTIES.propertyNames();
            if (!keys.hasMoreElements()) {
                Messages.getInstance();
                throw new Exception(Messages.getString("SimpleCLIPanel_Exception_Text_First"));
            }
        }
        catch (Exception ex) {
            Messages.getInstance();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_Exception_JOptionPaneShowMessageDialog_Text_First"))).append(PROPERTY_FILE);
            Messages.getInstance();
            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("SimpleCLIPanel_Exception_JOptionPaneShowMessageDialog_Text_Second")).append(System.getProperties().getProperty("user.home"));
            Messages.getInstance();
            String string = stringBuilder2.append(Messages.getString("SimpleCLIPanel_Exception_JOptionPaneShowMessageDialog_Text_Third")).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(null, string, Messages.getString("SimpleCLIPanel_Exception_JOptionPaneShowMessageDialog_Text_Fourth"), 0);
        }
    }

    public SimpleCLIPanel() throws Exception {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.m_OutputArea);
        Messages.getInstance();
        this.add((Component)jScrollPane, Messages.getString("SimpleCLIPanel_JScrollPane_Text_First"));
        Messages.getInstance();
        this.add((Component)this.m_Input, Messages.getString("SimpleCLIPanel_JScrollPane_Text_Second"));
        this.m_Input.setFont(new Font("Monospaced", 0, 12));
        this.m_Input.addActionListener(this);
        this.m_Input.setFocusTraversalKeysEnabled(false);
        this.m_Input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                SimpleCLIPanel.this.doHistory(e);
                SimpleCLIPanel.this.doCommandlineCompletion(e);
            }
        });
        this.m_OutputArea.setEditable(false);
        this.m_OutputArea.setFont(new Font("Monospaced", 0, 12));
        PipedInputStream pio = new PipedInputStream(this.m_POO);
        System.setOut(new PrintStream(this.m_POO));
        InputStreamReader r = new InputStreamReader(pio);
        this.m_OutRedirector = new ReaderToTextArea(r, this.m_OutputArea);
        this.m_OutRedirector.start();
        PipedInputStream pie = new PipedInputStream(this.m_POE);
        System.setErr(new PrintStream(this.m_POE));
        r = new InputStreamReader(pie);
        this.m_ErrRedirector = new ReaderToTextArea(r, this.m_OutputArea);
        this.m_ErrRedirector.start();
        this.m_Completion = new CommandlineCompletion();
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_JScrollPane_Text_Third"))).append(File.separator);
        Messages.getInstance();
        System.out.println(stringBuilder.append(Messages.getString("SimpleCLIPanel_JScrollPane_Text_Fouth")).toString());
        Messages.getInstance();
        this.runCommand(Messages.getString("SimpleCLIPanel_RunCommand_Text"));
        this.loadHistory();
    }

    public void runCommand(String commands) throws Exception {
        System.out.println("> " + commands + '\n');
        System.out.flush();
        String[] commandArgs = Utils.splitOptions(commands);
        if (commandArgs.length == 0) {
            return;
        }
        if (commandArgs[0].equals("java")) {
            commandArgs[0] = "";
            try {
                if (commandArgs.length == 1) {
                    Messages.getInstance();
                    throw new Exception(Messages.getString("SimpleCLIPanel_RunCommand_Exception_Text_First"));
                }
                String className = commandArgs[1];
                commandArgs[1] = "";
                if (this.m_RunThread != null) {
                    Messages.getInstance();
                    throw new Exception(Messages.getString("SimpleCLIPanel_RunCommand_Exception_Text_Second"));
                }
                Class<?> theClass = Class.forName(className);
                Vector<String> argv = new Vector<String>();
                int i = 2;
                while (i < commandArgs.length) {
                    argv.add(commandArgs[i]);
                    ++i;
                }
                this.m_RunThread = new ClassRunner(theClass, argv.toArray(new String[argv.size()]));
                this.m_RunThread.setPriority(1);
                this.m_RunThread.start();
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        } else if (commandArgs[0].equals("cls")) {
            this.m_OutputArea.setText("");
        } else if (commandArgs[0].equals("history")) {
            Messages.getInstance();
            System.out.println(Messages.getString("SimpleCLIPanel_RunCommand_Text_First"));
            int i = 0;
            while (i < this.m_CommandHistory.size()) {
                System.out.println(this.m_CommandHistory.get(i));
                ++i;
            }
            System.out.println();
        } else if (commandArgs[0].equals("break")) {
            if (this.m_RunThread == null) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_First"));
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("SimpleCLIPanel_RunCommand_Text_Second"));
                this.m_RunThread.interrupt();
            }
        } else if (commandArgs[0].equals("kill")) {
            if (this.m_RunThread == null) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Second"));
            } else {
                Messages.getInstance();
                System.out.println(Messages.getString("SimpleCLIPanel_RunCommand_Text_Third"));
                this.m_RunThread.stop();
                this.m_RunThread = null;
            }
        } else if (commandArgs[0].equals("exit")) {
            Container parent = this.getParent();
            Container frame = null;
            boolean finished = false;
            while (!finished) {
                if (parent instanceof JFrame || parent instanceof Frame || parent instanceof JInternalFrame) {
                    frame = parent;
                    finished = true;
                }
                if (finished) continue;
                boolean bl = finished = (parent = parent.getParent()) == null;
            }
            if (frame != null) {
                if (frame instanceof JInternalFrame) {
                    ((JInternalFrame)frame).doDefaultCloseAction();
                } else {
                    ((Window)frame).dispatchEvent(new WindowEvent((Window)frame, 201));
                }
            }
        } else {
            boolean help;
            boolean bl = help = commandArgs.length > 1 && commandArgs[0].equals("help");
            if (help && commandArgs[1].equals("java")) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Third"))).append(File.separator);
                Messages.getInstance();
                System.err.println(stringBuilder.append(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Fourth")).toString());
            } else if (help && commandArgs[1].equals("break")) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Fifth"));
            } else if (help && commandArgs[1].equals("kill")) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Sixth"));
            } else if (help && commandArgs[1].equals("cls")) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Seventh"));
            } else if (help && commandArgs[1].equals("history")) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Eighth"));
            } else if (help && commandArgs[1].equals("exit")) {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Nineth"));
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("SimpleCLIPanel_RunCommand_Error_Text_Tenth"));
            }
        }
    }

    public void doHistory(KeyEvent e) {
        if (e.getSource() == this.m_Input) {
            switch (e.getKeyCode()) {
                case 38: {
                    if (this.m_HistoryPos <= 0) break;
                    --this.m_HistoryPos;
                    String command = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    this.m_Input.setText(command);
                    break;
                }
                case 40: {
                    if (this.m_HistoryPos >= this.m_CommandHistory.size()) break;
                    ++this.m_HistoryPos;
                    String command = "";
                    if (this.m_HistoryPos < this.m_CommandHistory.size()) {
                        command = (String)this.m_CommandHistory.elementAt(this.m_HistoryPos);
                    }
                    this.m_Input.setText(command);
                    break;
                }
            }
        }
    }

    public void doCommandlineCompletion(KeyEvent e) {
        if (e.getSource() == this.m_Input) {
            switch (e.getKeyCode()) {
                case 9: {
                    if (e.getModifiers() != 0) break;
                    this.m_Input.setCursor(Cursor.getPredefinedCursor(3));
                    this.m_OutputArea.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        String txt = this.m_Input.getText();
                        if (!txt.trim().startsWith("java ")) break;
                        int pos = this.m_Input.getCaretPosition();
                        int nonNameCharPos = -1;
                        int i = pos - 1;
                        while (i >= 0) {
                            if (txt.charAt(i) == '\"' || txt.charAt(i) == ' ') {
                                nonNameCharPos = i;
                                break;
                            }
                            --i;
                        }
                        if (nonNameCharPos <= -1) break;
                        String search = txt.substring(nonNameCharPos + 1, pos);
                        Vector<String> list = this.m_Completion.getMatches(search);
                        String common = this.m_Completion.getCommonPrefix(list);
                        if ((String.valueOf(search.toLowerCase()) + File.separator).equals(common.toLowerCase())) {
                            common = search;
                        }
                        if (common.length() > search.length()) {
                            try {
                                this.m_Input.getDocument().remove(nonNameCharPos + 1, search.length());
                                this.m_Input.getDocument().insertString(nonNameCharPos + 1, common, null);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break;
                        }
                        if (list.size() <= 1) break;
                        Messages.getInstance();
                        System.out.println(Messages.getString("SimpleCLIPanel_DoCommandlineCompletion_Text"));
                        int i2 = 0;
                        while (i2 < list.size()) {
                            System.out.println("  " + list.get(i2));
                            ++i2;
                        }
                        break;
                    }
                    finally {
                        this.m_Input.setCursor(null);
                        this.m_OutputArea.setCursor(null);
                    }
                }
                case 8: {
                    int pos;
                    if (e.getModifiers() != 8) break;
                    String txt = this.m_Input.getText();
                    int start = pos = this.m_Input.getCaretPosition();
                    --start;
                    while (start >= 0) {
                        if (txt.charAt(start) != '.' && txt.charAt(start) != ' ' && txt.charAt(start) != '\\' && txt.charAt(start) != '/') break;
                        --start;
                    }
                    int newPos = -1;
                    int i = start;
                    while (i >= 0) {
                        if (txt.charAt(i) == '.' || txt.charAt(i) == ' ' || txt.charAt(i) == '\\' || txt.charAt(i) == '/') {
                            newPos = i;
                            break;
                        }
                        --i;
                    }
                    try {
                        this.m_Input.getDocument().remove(newPos + 1, pos - newPos - 1);
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_Input) {
                String command = this.m_Input.getText();
                int last = this.m_CommandHistory.size() - 1;
                if (last < 0 || !command.equals((String)this.m_CommandHistory.elementAt(last))) {
                    this.m_CommandHistory.addElement(command);
                    this.saveHistory();
                }
                this.m_HistoryPos = this.m_CommandHistory.size();
                this.runCommand(command);
                this.m_Input.setText("");
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    protected void loadHistory() {
        int size = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        this.m_CommandHistory.clear();
        int i = 0;
        while (i < size) {
            String cmd = PROPERTIES.getProperty("Command" + i, "");
            if (cmd.length() == 0) break;
            this.m_CommandHistory.add(cmd);
            ++i;
        }
        this.m_HistoryPos = this.m_CommandHistory.size();
    }

    protected void saveHistory() {
        int size = Integer.parseInt(PROPERTIES.getProperty("HistorySize", "50"));
        int from = this.m_CommandHistory.size() - size;
        if (from < 0) {
            from = 0;
        }
        PROPERTIES.setProperty("HistorySize", "" + size);
        int i = from;
        while (i < this.m_CommandHistory.size()) {
            PROPERTIES.setProperty("Command" + (i - from), (String)this.m_CommandHistory.get(i));
            ++i;
        }
        try {
            String filename = String.valueOf(System.getProperties().getProperty("user.home")) + File.separatorChar + FILENAME;
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filename));
            PROPERTIES.store(stream, "SimpleCLI");
            stream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleCLIPanel panel = new SimpleCLIPanel();
        JFrame f = new JFrame();
        Messages.getInstance();
        f.setTitle(Messages.getString("SimpleCLIPanel_Main_JFrame_SetText_Text"));
        f.getContentPane().add(panel);
        f.setDefaultCloseOperation(2);
        f.pack();
        f.setSize(600, 500);
        f.setVisible(true);
    }

    class ClassRunner
    extends Thread {
        protected Method m_MainMethod;
        String[] m_CommandArgs;

        public ClassRunner(Class theClass, String[] commandArgs) throws Exception {
            this.setDaemon(true);
            Class[] argTemplate = new Class[]{String[].class};
            this.m_CommandArgs = commandArgs;
            this.m_MainMethod = theClass.getMethod("main", argTemplate);
            if ((this.m_MainMethod.getModifiers() & 8) == 0 || (this.m_MainMethod.getModifiers() & 1) == 0) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_ClassRunner_Exception_NoSuchMethodException_Text_First"))).append(theClass.getName());
                Messages.getInstance();
                throw new NoSuchMethodException(stringBuilder.append(Messages.getString("SimpleCLIPanel_ClassRunner_Exception_NoSuchMethodException_Text_Second")).toString());
            }
        }

        @Override
        public void run() {
            String outFilename;
            PrintStream outNew;
            PrintStream outOld;
            block13: {
                String action;
                outOld = null;
                outNew = null;
                outFilename = null;
                if (this.m_CommandArgs.length > 2 && (action = this.m_CommandArgs[this.m_CommandArgs.length - 2]).equals(">")) {
                    outOld = System.out;
                    try {
                        outFilename = this.m_CommandArgs[this.m_CommandArgs.length - 1];
                        if (outFilename.startsWith("~")) {
                            outFilename = outFilename.replaceFirst("~", System.getProperty("user.home"));
                        }
                        outNew = new PrintStream(new File(outFilename));
                        System.setOut(outNew);
                        this.m_CommandArgs[this.m_CommandArgs.length - 2] = "";
                        this.m_CommandArgs[this.m_CommandArgs.length - 1] = "";
                        String[] newArgs = new String[this.m_CommandArgs.length - 2];
                        System.arraycopy(this.m_CommandArgs, 0, newArgs, 0, this.m_CommandArgs.length - 2);
                        this.m_CommandArgs = newArgs;
                    }
                    catch (Exception e) {
                        System.setOut(outOld);
                        outOld = null;
                    }
                }
                try {
                    try {
                        Object[] args = new Object[]{this.m_CommandArgs};
                        this.m_MainMethod.invoke(null, args);
                        if (this.isInterrupted()) {
                            Messages.getInstance();
                            System.err.println(Messages.getString("SimpleCLIPanel_ClassRunner_Run_Error_Text_First"));
                        }
                    }
                    catch (Exception ex) {
                        if (ex.getMessage() == null) {
                            Messages.getInstance();
                            System.err.println(Messages.getString("SimpleCLIPanel_ClassRunner_Run_Error_Text_Second"));
                        } else {
                            Messages.getInstance();
                            System.err.println(String.valueOf(Messages.getString("SimpleCLIPanel_ClassRunner_Run_Error_Text_Third")) + ex.getMessage());
                        }
                        SimpleCLIPanel.this.m_RunThread = null;
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    SimpleCLIPanel.this.m_RunThread = null;
                    throw throwable;
                }
                SimpleCLIPanel.this.m_RunThread = null;
            }
            if (outOld != null) {
                outNew.flush();
                outNew.close();
                System.setOut(outOld);
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_ClassRunner_Run_Text_First"))).append(outFilename);
                Messages.getInstance();
                System.out.println(stringBuilder.append(Messages.getString("SimpleCLIPanel_ClassRunner_Run_Text_Second")).toString());
            }
        }
    }

    public static class CommandlineCompletion {
        protected static Vector<String> m_Packages;
        protected static Trie m_Trie;
        protected boolean m_Debug = false;

        public CommandlineCompletion() {
            if (m_Packages == null) {
                Vector list = ClassDiscovery.findPackages();
                HashSet<String> set = new HashSet<String>();
                int i = 0;
                while (i < list.size()) {
                    String[] parts = ((String)list.get(i)).split("\\.");
                    int n = 1;
                    while (n < parts.length) {
                        String pkg = "";
                        int m = 0;
                        while (m <= n) {
                            if (m > 0) {
                                pkg = String.valueOf(pkg) + ".";
                            }
                            pkg = String.valueOf(pkg) + parts[m];
                            ++m;
                        }
                        set.add(pkg);
                        ++n;
                    }
                    ++i;
                }
                m_Packages = new Vector();
                m_Packages.addAll(set);
                Collections.sort(m_Packages);
                m_Trie = new Trie();
                m_Trie.addAll((Collection<? extends String>)m_Packages);
            }
        }

        public boolean getDebug() {
            return this.m_Debug;
        }

        public void setDebug(boolean value) {
            this.m_Debug = value;
        }

        public boolean isClassname(String partial) {
            return partial.replaceAll("[a-zA-Z0-9\\-\\.]*", "").length() == 0;
        }

        public String getPackage(String partial) {
            String result = "";
            boolean wasDot = false;
            int i = 0;
            while (i < partial.length()) {
                char c = partial.charAt(i);
                if (wasDot && c >= 'A' && c <= 'Z') break;
                if (c == '.') {
                    wasDot = true;
                    result = String.valueOf(result) + c;
                } else {
                    wasDot = false;
                    result = String.valueOf(result) + c;
                }
                ++i;
            }
            if (result.endsWith(".")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }

        public String getClassname(String partial) {
            String pkg = this.getPackage(partial);
            String result = pkg.length() + 1 < partial.length() ? partial.substring(pkg.length() + 1) : "";
            return result;
        }

        public Vector<String> getFileMatches(String partial) {
            int i;
            boolean caseSensitive;
            Vector<String> result = new Vector<String>();
            boolean bl = caseSensitive = File.separatorChar != '\\';
            if (this.m_Debug) {
                Messages.getInstance();
                System.out.println(String.valueOf(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetFileMatches_Text_First")) + caseSensitive);
            }
            if (partial.startsWith("~")) {
                partial = String.valueOf(System.getProperty("user.home")) + partial.substring(1);
            }
            File file = new File(partial);
            File dir = null;
            String prefix = null;
            if (file.exists()) {
                if (file.isDirectory()) {
                    dir = file;
                    prefix = null;
                } else {
                    dir = file.getParentFile();
                    prefix = file.getName();
                }
            } else {
                dir = file.getParentFile();
                prefix = file.getName();
            }
            if (this.m_Debug) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetFileMatches_Text_Second"))).append(dir);
                Messages.getInstance();
                System.out.println(stringBuilder.append(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetFileMatches_Text_Third")).append(prefix).toString());
            }
            if (dir != null) {
                File[] files = dir.listFiles();
                if (files != null) {
                    i = 0;
                    while (i < files.length) {
                        String name = files[i].getName();
                        boolean match = prefix != null && caseSensitive ? name.startsWith(prefix) : (prefix != null && !caseSensitive ? name.toLowerCase().startsWith(prefix.toLowerCase()) : true);
                        if (match) {
                            if (prefix != null) {
                                result.add(String.valueOf(partial.substring(0, partial.length() - prefix.length())) + name);
                            } else if (partial.endsWith("\\") || partial.endsWith("/")) {
                                result.add(String.valueOf(partial) + name);
                            } else {
                                result.add(String.valueOf(partial) + File.separator + name);
                            }
                        }
                        ++i;
                    }
                } else {
                    Messages.getInstance();
                    System.err.println(String.valueOf(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetFileMatches_Error_Text")) + partial);
                }
            }
            if (result.size() > 1) {
                Collections.sort(result);
            }
            if (this.m_Debug) {
                Messages.getInstance();
                System.out.println(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetFileMatches_Text_Third"));
                i = 0;
                while (i < result.size()) {
                    System.out.println(result.get(i));
                    ++i;
                }
            }
            return result;
        }

        public Vector<String> getClassMatches(String partial) {
            int i;
            Vector<String> list;
            String pkg = this.getPackage(partial);
            String cls = this.getClassname(partial);
            if (this.getDebug()) {
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetClassMatches_Text_First"))).append(partial);
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetClassMatches_Text_Second")).append(pkg);
                Messages.getInstance();
                System.out.println(stringBuilder2.append(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetClassMatches_Text_Third")).append(cls).toString());
            }
            Vector<String> result = new Vector<String>();
            if (cls.length() == 0) {
                list = m_Trie.getWithPrefix(pkg);
                HashSet<String> set = new HashSet<String>();
                i = 0;
                while (i < list.size()) {
                    String tmpStr = list.get(i);
                    if (tmpStr.length() >= partial.length() && !tmpStr.equals(partial)) {
                        int index = tmpStr.indexOf(46, partial.length() + 1);
                        if (index > -1) {
                            set.add(tmpStr.substring(0, index));
                        } else {
                            set.add(tmpStr);
                        }
                    }
                    ++i;
                }
                result.addAll(set);
                if (result.size() > 1) {
                    Collections.sort(result);
                }
            }
            list = ClassDiscovery.find(Object.class, pkg);
            Trie tmpTrie = new Trie();
            tmpTrie.addAll((Collection<? extends String>)list);
            list = tmpTrie.getWithPrefix(partial);
            result.addAll(list);
            if (result.size() > 1) {
                Collections.sort(result);
            }
            if (this.m_Debug) {
                Messages.getInstance();
                System.out.println(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetClassMatches_Text_Fifth"));
                i = 0;
                while (i < result.size()) {
                    System.out.println(result.get(i));
                    ++i;
                }
            }
            return result;
        }

        public Vector<String> getMatches(String partial) {
            if (this.isClassname(partial)) {
                return this.getClassMatches(partial);
            }
            return this.getFileMatches(partial);
        }

        public String getCommonPrefix(Vector<String> list) {
            Trie trie = new Trie();
            trie.addAll((Collection<? extends String>)list);
            String result = trie.getCommonPrefix();
            if (this.m_Debug) {
                StringBuilder stringBuilder = new StringBuilder().append(list);
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetCommonPrefix_Text_First")).append(result);
                Messages.getInstance();
                System.out.println(stringBuilder2.append(Messages.getString("SimpleCLIPanel_CommandlineCompletion_GetCommonPrefix_Text_Second")).toString());
            }
            return result;
        }
    }

    class ReaderToTextArea
    extends Thread {
        protected LineNumberReader m_Input;
        protected JTextArea m_Output;

        public ReaderToTextArea(Reader input, JTextArea output) {
            this.setDaemon(true);
            this.m_Input = new LineNumberReader(input);
            this.m_Output = output;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.m_Output.append(String.valueOf(this.m_Input.readLine()) + '\n');
                        this.m_Output.setCaretPosition(this.m_Output.getDocument().getLength());
                    }
                }
                catch (Exception ex) {
                    try {
                        ReaderToTextArea.sleep(100L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

