/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.gui.GenericObjectEditor;
import weka.gui.Messages;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;

public class PropertySheetPanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -8939835593429918345L;
    private Object m_Target;
    private PropertyDescriptor[] m_Properties;
    private MethodDescriptor[] m_Methods;
    private PropertyEditor[] m_Editors;
    private Object[] m_Values;
    private JComponent[] m_Views;
    private JLabel[] m_Labels;
    private String[] m_TipTexts;
    private StringBuffer m_HelpText;
    private JDialog m_HelpDialog;
    private CapabilitiesHelpDialog m_CapabilitiesDialog;
    private JButton m_HelpBut;
    private JButton m_CapabilitiesBut;
    private JTextArea m_CapabilitiesText;
    private int m_NumEditable = 0;
    private JPanel m_aboutPanel;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);

    public static String listCapabilities(Capabilities c) {
        String result = "";
        Iterator iter = c.capabilities();
        while (iter.hasNext()) {
            if (result.length() != 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + iter.next().toString();
        }
        return result;
    }

    public static String addCapabilities(String title, Capabilities c) {
        String result = String.valueOf(title) + "\n";
        String caps = PropertySheetPanel.listCapabilities(c.getClassCapabilities());
        if (caps.length() != 0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(result));
            Messages.getInstance();
            result = stringBuilder.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_First")).toString();
            result = String.valueOf(result) + caps;
            StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(result));
            Messages.getInstance();
            result = stringBuilder2.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Second")).toString();
        }
        if ((caps = PropertySheetPanel.listCapabilities(c.getAttributeCapabilities())).length() != 0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(result));
            Messages.getInstance();
            result = stringBuilder.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Third")).toString();
            result = String.valueOf(result) + caps;
            StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(result));
            Messages.getInstance();
            result = stringBuilder3.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Fourth")).toString();
        }
        if ((caps = PropertySheetPanel.listCapabilities(c.getOtherCapabilities())).length() != 0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(result));
            Messages.getInstance();
            result = stringBuilder.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Fifth")).toString();
            result = String.valueOf(result) + caps;
            StringBuilder stringBuilder4 = new StringBuilder(String.valueOf(result));
            Messages.getInstance();
            result = stringBuilder4.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Sixth")).toString();
        }
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(result));
        Messages.getInstance();
        result = stringBuilder.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Seventh")).toString();
        StringBuilder stringBuilder5 = new StringBuilder(String.valueOf(result));
        Messages.getInstance();
        result = stringBuilder5.append(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_AddCapabilities_SetTitle_Text_Eighth")).append(c.getMinimumNumberInstances()).append("\n").toString();
        result = String.valueOf(result) + "\n";
        return result;
    }

    public PropertySheetPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
    }

    public JPanel getAboutPanel() {
        return this.m_aboutPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.wasModified(evt);
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public synchronized void setTarget(Object targ) {
        int componentOffset = 0;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel scrollablePanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(scrollablePanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        GridBagLayout gbLayout = new GridBagLayout();
        scrollablePanel.setLayout(gbLayout);
        this.setVisible(false);
        this.m_NumEditable = 0;
        this.m_Target = targ;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.m_Target.getClass());
            this.m_Properties = bi.getPropertyDescriptors();
            this.m_Methods = bi.getMethodDescriptors();
        }
        catch (IntrospectionException ex) {
            Messages.getInstance();
            System.err.println(Messages.getString("PropertySheetPanel_SetTarget_IntrospectionException_Error_Text"));
            return;
        }
        JTextArea jt = new JTextArea();
        this.m_HelpText = null;
        MethodDescriptor[] methodDescriptorArray = this.m_Methods;
        int n = this.m_Methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDescriptor m_Method = methodDescriptorArray[n2];
            String name = m_Method.getDisplayName();
            Method meth = m_Method.getMethod();
            if (name.equals("globalInfo") && meth.getReturnType().equals(String.class)) {
                try {
                    String globalInfo;
                    Object[] args = new Object[]{};
                    String summary = globalInfo = (String)meth.invoke(this.m_Target, args);
                    int ci = globalInfo.indexOf(46);
                    if (ci != -1) {
                        summary = globalInfo.substring(0, ci + 1);
                    }
                    String className = targ.getClass().getName();
                    Messages.getInstance();
                    this.m_HelpText = new StringBuffer(Messages.getString("PropertySheetPanel_SetTarget_HelpText_Text_First"));
                    StringBuffer stringBuffer = this.m_HelpText.append(className);
                    Messages.getInstance();
                    stringBuffer.append(Messages.getString("PropertySheetPanel_SetTarget_HelpText_Text_Second"));
                    Messages.getInstance();
                    StringBuffer stringBuffer2 = this.m_HelpText.append(Messages.getString("PropertySheetPanel_SetTarget_HelpText_Text_Third")).append(globalInfo);
                    Messages.getInstance();
                    stringBuffer2.append(Messages.getString("PropertySheetPanel_SetTarget_HelpText_Text_Fourth"));
                    Messages.getInstance();
                    this.m_HelpBut = new JButton(Messages.getString("PropertySheetPanel_SetTarget_HelpBut_JButton_Text"));
                    Messages.getInstance();
                    this.m_HelpBut.setToolTipText(String.valueOf(Messages.getString("PropertySheetPanel_SetTarget_HelpBut_SetToolTipText_Text")) + className);
                    this.m_HelpBut.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent a) {
                            PropertySheetPanel.this.openHelpFrame();
                            PropertySheetPanel.this.m_HelpBut.setEnabled(false);
                        }
                    });
                    if (this.m_Target instanceof CapabilitiesHandler) {
                        Messages.getInstance();
                        this.m_CapabilitiesBut = new JButton(Messages.getString("PropertySheetPanel_SetTarget_CapabilitiesBut_JButton_Text"));
                        Messages.getInstance();
                        this.m_CapabilitiesBut.setToolTipText(String.valueOf(Messages.getString("PropertySheetPanel_SetTarget_CapabilitiesBut_SetToolTipText_Text")) + className);
                        this.m_CapabilitiesBut.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                PropertySheetPanel.this.openCapabilitiesHelpDialog();
                                PropertySheetPanel.this.m_CapabilitiesBut.setEnabled(false);
                            }
                        });
                    } else {
                        this.m_CapabilitiesBut = null;
                    }
                    jt.setColumns(30);
                    jt.setFont(new Font("SansSerif", 0, 12));
                    jt.setEditable(false);
                    jt.setLineWrap(true);
                    jt.setWrapStyleWord(true);
                    jt.setText(summary);
                    jt.setBackground(this.getBackground());
                    JPanel jp = new JPanel();
                    Messages.getInstance();
                    jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("PropertySheetPanel_SetTarget_Jp_JPanel_BorderFactoryCreateTitledBorder_Text")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                    jp.setLayout(new BorderLayout());
                    jp.add((Component)jt, "Center");
                    JPanel p2 = new JPanel();
                    p2.setLayout(new BorderLayout());
                    p2.add((Component)this.m_HelpBut, "North");
                    if (this.m_CapabilitiesBut != null) {
                        JPanel p3 = new JPanel();
                        p3.setLayout(new BorderLayout());
                        p3.add((Component)this.m_CapabilitiesBut, "North");
                        p2.add((Component)p3, "Center");
                    }
                    jp.add((Component)p2, "East");
                    GridBagConstraints gbConstraints = new GridBagConstraints();
                    gbConstraints.fill = 1;
                    gbConstraints.gridwidth = 2;
                    gbConstraints.insets = new Insets(0, 5, 0, 5);
                    gbLayout.setConstraints(jp, gbConstraints);
                    this.m_aboutPanel = jp;
                    scrollablePanel.add(this.m_aboutPanel);
                    componentOffset = 1;
                    break;
                }
                catch (Exception args) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.m_Editors = new PropertyEditor[this.m_Properties.length];
        this.m_Values = new Object[this.m_Properties.length];
        this.m_Views = new JComponent[this.m_Properties.length];
        this.m_Labels = new JLabel[this.m_Properties.length];
        this.m_TipTexts = new String[this.m_Properties.length];
        boolean firstTip = true;
        int i = 0;
        while (i < this.m_Properties.length) {
            block35: {
                if (!this.m_Properties[i].isHidden() && !this.m_Properties[i].isExpert()) {
                    String name = this.m_Properties[i].getDisplayName();
                    Class<?> type = this.m_Properties[i].getPropertyType();
                    Method getter = this.m_Properties[i].getReadMethod();
                    Method setter = this.m_Properties[i].getWriteMethod();
                    if (getter != null && setter != null) {
                        JComponent view = null;
                        try {
                            String getterClass;
                            Object value;
                            Object[] args = new Object[]{};
                            this.m_Values[i] = value = getter.invoke(this.m_Target, args);
                            PropertyEditor editor = null;
                            Class<?> pec = this.m_Properties[i].getPropertyEditorClass();
                            if (pec != null) {
                                try {
                                    editor = (PropertyEditor)pec.newInstance();
                                }
                                catch (Exception jp) {
                                    // empty catch block
                                }
                            }
                            if (editor == null) {
                                editor = PropertyEditorManager.findEditor(type);
                            }
                            this.m_Editors[i] = editor;
                            if (editor == null) {
                                getterClass = this.m_Properties[i].getReadMethod().getDeclaringClass().getName();
                                break block35;
                            }
                            if (editor instanceof GenericObjectEditor) {
                                ((GenericObjectEditor)editor).setClassType(type);
                            }
                            if (value == null) {
                                getterClass = this.m_Properties[i].getReadMethod().getDeclaringClass().getName();
                                break block35;
                            }
                            editor.setValue(value);
                            String tipName = String.valueOf(name) + "TipText";
                            MethodDescriptor[] methodDescriptorArray2 = this.m_Methods;
                            int n3 = this.m_Methods.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                MethodDescriptor m_Method = methodDescriptorArray2[n4];
                                String mname = m_Method.getDisplayName();
                                Method meth = m_Method.getMethod();
                                if (mname.equals(tipName) && meth.getReturnType().equals(String.class)) {
                                    try {
                                        String tempTip = (String)meth.invoke(this.m_Target, args);
                                        int ci = tempTip.indexOf(46);
                                        this.m_TipTexts[i] = ci < 0 ? tempTip : tempTip.substring(0, ci);
                                        if (this.m_HelpText == null) break;
                                        if (firstTip) {
                                            Messages.getInstance();
                                            this.m_HelpText.append(Messages.getString("PropertySheetPanel_SetTarget_HelpText_Text_Fifth"));
                                            firstTip = false;
                                        }
                                        this.m_HelpText.append(name).append(" -- ");
                                        this.m_HelpText.append(tempTip).append("\n\n");
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                ++n4;
                            }
                            if (editor.isPaintable() && editor.supportsCustomEditor()) {
                                view = new PropertyPanel(editor);
                            } else if (editor.getTags() != null) {
                                view = new PropertyValueSelector(editor);
                            } else {
                                if (editor.getAsText() == null) {
                                    Messages.getInstance();
                                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("PropertySheetPanel_SetTarget_Error_Text_First"))).append(name);
                                    Messages.getInstance();
                                    System.err.println(stringBuilder.append(Messages.getString("PropertySheetPanel_SetTarget_Error_Text_Second")).toString());
                                    break block35;
                                }
                                view = new PropertyText(editor);
                            }
                            editor.addPropertyChangeListener(this);
                        }
                        catch (InvocationTargetException ex) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("PropertySheetPanel_SetTarget_Error_Text_Third"))).append(name);
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("PropertySheetPanel_SetTarget_Error_Text_Fourth")).append(ex.getTargetException()).toString());
                            ex.getTargetException().printStackTrace();
                            break block35;
                        }
                        catch (Exception ex) {
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("PropertySheetPanel_SetTarget_Error_Text_Fifth"))).append(name);
                            Messages.getInstance();
                            System.err.println(stringBuilder.append(Messages.getString("PropertySheetPanel_SetTarget_Error_Text_Sixth")).append(ex).toString());
                            ex.printStackTrace();
                            break block35;
                        }
                        this.m_Labels[i] = new JLabel(name, 4);
                        this.m_Labels[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 5));
                        this.m_Views[i] = view;
                        GridBagConstraints gbConstraints = new GridBagConstraints();
                        gbConstraints.anchor = 13;
                        gbConstraints.fill = 2;
                        gbConstraints.gridy = i + componentOffset;
                        gbConstraints.gridx = 0;
                        gbLayout.setConstraints(this.m_Labels[i], gbConstraints);
                        scrollablePanel.add(this.m_Labels[i]);
                        JPanel newPanel = new JPanel();
                        if (this.m_TipTexts[i] != null) {
                            this.m_Views[i].setToolTipText(this.m_TipTexts[i]);
                        }
                        newPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
                        newPanel.setLayout(new BorderLayout());
                        newPanel.add((Component)this.m_Views[i], "Center");
                        gbConstraints = new GridBagConstraints();
                        gbConstraints.anchor = 17;
                        gbConstraints.fill = 1;
                        gbConstraints.gridy = i + componentOffset;
                        gbConstraints.gridx = 1;
                        gbConstraints.weightx = 100.0;
                        gbLayout.setConstraints(newPanel, gbConstraints);
                        scrollablePanel.add(newPanel);
                        ++this.m_NumEditable;
                    }
                }
            }
            ++i;
        }
        if (this.m_NumEditable == 0) {
            Messages.getInstance();
            JLabel empty = new JLabel(Messages.getString("PropertySheetPanel_SetTarget_Empty_JLabel_Text"), 0);
            Dimension d = empty.getPreferredSize();
            empty.setPreferredSize(new Dimension(d.width * 2, d.height * 2));
            empty.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 10;
            gbConstraints.fill = 2;
            gbConstraints.gridy = componentOffset;
            gbConstraints.gridx = 0;
            gbLayout.setConstraints(empty, gbConstraints);
            scrollablePanel.add(empty);
        }
        this.validate();
        this.setVisible(true);
    }

    protected void openHelpFrame() {
        JDialog jdtmp;
        JTextArea ta = new JTextArea();
        ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setText(this.m_HelpText.toString());
        ta.setCaretPosition(0);
        if (PropertyDialog.getParentDialog(this) != null) {
            Dialog dialog = PropertyDialog.getParentDialog(this);
            Messages.getInstance();
            jdtmp = new JDialog(dialog, Messages.getString("PropertySheetPanel_OpenHelpFrame_Jdtmp_JDialog_Text_First"));
        } else {
            Frame frame = PropertyDialog.getParentFrame(this);
            Messages.getInstance();
            jdtmp = new JDialog(frame, Messages.getString("PropertySheetPanel_OpenHelpFrame_Jdtmp_JDialog_Text_Second"));
        }
        final JDialog jd = jdtmp;
        jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jd.dispose();
                if (PropertySheetPanel.this.m_HelpDialog == jd) {
                    PropertySheetPanel.this.m_HelpBut.setEnabled(true);
                }
            }
        });
        jd.getContentPane().setLayout(new BorderLayout());
        jd.getContentPane().add((Component)new JScrollPane(ta), "Center");
        jd.pack();
        jd.setSize(400, 350);
        jd.setLocation(this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().x + this.m_aboutPanel.getTopLevelAncestor().getSize().width, this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().y);
        jd.setVisible(true);
        this.m_HelpDialog = jd;
    }

    protected void openCapabilitiesHelpDialog() {
        this.m_CapabilitiesDialog = PropertyDialog.getParentDialog(this) != null ? new CapabilitiesHelpDialog(PropertyDialog.getParentDialog(this)) : new CapabilitiesHelpDialog(PropertyDialog.getParentFrame(this));
        this.m_CapabilitiesDialog.setSize(400, 350);
        this.m_CapabilitiesDialog.setLocation(this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().x + this.m_aboutPanel.getTopLevelAncestor().getSize().width, this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().y);
        this.m_CapabilitiesDialog.setVisible(true);
        this.addPropertyChangeListener(this.m_CapabilitiesDialog);
    }

    public int editableProperties() {
        return this.m_NumEditable;
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            int i = 0;
            while (i < this.m_Editors.length) {
                if (this.m_Editors[i] == editor) {
                    Object value;
                    PropertyDescriptor property = this.m_Properties[i];
                    this.m_Values[i] = value = editor.getValue();
                    Method setter = property.getWriteMethod();
                    try {
                        Object[] args = new Object[]{value};
                        args[0] = value;
                        setter.invoke(this.m_Target, args);
                    }
                    catch (InvocationTargetException ex) {
                        if (ex.getTargetException() instanceof PropertyVetoException) {
                            Messages.getInstance();
                            String message = String.valueOf(Messages.getString("PropertySheetPanel_WasModified_Message_Text")) + ex.getTargetException().getMessage();
                            System.err.println(message);
                            Container jf = evt.getSource() instanceof JPanel ? ((JPanel)evt.getSource()).getParent() : new JFrame();
                            Messages.getInstance();
                            JOptionPane.showMessageDialog(jf, message, Messages.getString("PropertySheetPanel_WasModified_JOptionPaneShowMessageDialog_Text_First"), 2);
                            if (jf instanceof JFrame) {
                                ((Window)jf).dispose();
                            }
                        } else {
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(ex.getTargetException().getClass().getName()));
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("PropertySheetPanel_WasModified_Error_Text_First")).append(property.getName());
                            Messages.getInstance();
                            System.err.println(stringBuilder2.append(Messages.getString("PropertySheetPanel_WasModified_Error_Text_Second")).append(ex.getTargetException().getMessage()).toString());
                            Container jf = evt.getSource() instanceof JPanel ? ((JPanel)evt.getSource()).getParent() : new JFrame();
                            StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(ex.getTargetException().getClass().getName()));
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("PropertySheetPanel_WasModified_JOptionPaneShowMessageDialog_Second")).append(property.getName());
                            Messages.getInstance();
                            String string = stringBuilder4.append(Messages.getString("PropertySheetPanel_WasModified_JOptionPaneShowMessageDialog_Third")).append(ex.getTargetException().getMessage()).toString();
                            Messages.getInstance();
                            JOptionPane.showMessageDialog(jf, string, Messages.getString("PropertySheetPanel_WasModified_JOptionPaneShowMessageDialog_Fourth"), 2);
                            if (jf instanceof JFrame) {
                                ((Window)jf).dispose();
                            }
                        }
                    }
                    catch (Exception ex) {
                        Messages.getInstance();
                        System.err.println(String.valueOf(Messages.getString("PropertySheetPanel_WasModified_JOptionPaneShowMessageDialog_Fifth")) + property.getName());
                    }
                    if (this.m_Views[i] == null || !(this.m_Views[i] instanceof PropertyPanel)) break;
                    this.m_Views[i].repaint();
                    this.revalidate();
                    break;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.m_Properties.length) {
            block17: {
                Object o;
                try {
                    Method getter = this.m_Properties[i].getReadMethod();
                    Method setter = this.m_Properties[i].getWriteMethod();
                    if (getter == null || setter == null) break block17;
                    Object[] args = new Object[]{};
                    o = getter.invoke(this.m_Target, args);
                }
                catch (Exception ex) {
                    o = null;
                }
                if (!(o == this.m_Values[i] || o != null && o.equals(this.m_Values[i]))) {
                    this.m_Values[i] = o;
                    if (this.m_Editors[i] != null) {
                        this.m_Editors[i].removePropertyChangeListener(this);
                        this.m_Editors[i].setValue(o);
                        this.m_Editors[i].addPropertyChangeListener(this);
                        if (this.m_Views[i] != null) {
                            this.m_Views[i].repaint();
                        }
                    }
                }
            }
            ++i;
        }
        if (Beans.isInstanceOf(this.m_Target, Component.class)) {
            ((Component)Beans.getInstanceOf(this.m_Target, Component.class)).repaint();
        }
    }

    protected class CapabilitiesHelpDialog
    extends JDialog
    implements PropertyChangeListener {
        private static final long serialVersionUID = -1404770987103289858L;
        private CapabilitiesHelpDialog m_Self;

        public CapabilitiesHelpDialog(Frame owner) {
            super(owner);
            this.initialize();
        }

        public CapabilitiesHelpDialog(Dialog owner) {
            super(owner);
            this.initialize();
        }

        protected void initialize() {
            Messages.getInstance();
            this.setTitle(Messages.getString("PropertySheetPanel_CapabilitiesHelpDialog_Initialize_SetTitle_Text"));
            this.m_Self = this;
            PropertySheetPanel.this.m_CapabilitiesText = new JTextArea();
            PropertySheetPanel.this.m_CapabilitiesText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            PropertySheetPanel.this.m_CapabilitiesText.setLineWrap(true);
            PropertySheetPanel.this.m_CapabilitiesText.setWrapStyleWord(true);
            PropertySheetPanel.this.m_CapabilitiesText.setEditable(false);
            this.updateText();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CapabilitiesHelpDialog.this.m_Self.dispose();
                    if (PropertySheetPanel.this.m_CapabilitiesDialog == CapabilitiesHelpDialog.this.m_Self) {
                        PropertySheetPanel.this.m_CapabilitiesBut.setEnabled(true);
                    }
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(PropertySheetPanel.this.m_CapabilitiesText), "Center");
            this.pack();
        }

        protected void updateText() {
            StringBuffer helpText = new StringBuffer();
            if (PropertySheetPanel.this.m_Target instanceof CapabilitiesHandler) {
                helpText.append(PropertySheetPanel.addCapabilities("CAPABILITIES", ((CapabilitiesHandler)PropertySheetPanel.this.m_Target).getCapabilities()));
            }
            if (PropertySheetPanel.this.m_Target instanceof MultiInstanceCapabilitiesHandler) {
                helpText.append(PropertySheetPanel.addCapabilities("MI CAPABILITIES", ((MultiInstanceCapabilitiesHandler)PropertySheetPanel.this.m_Target).getMultiInstanceCapabilities()));
            }
            PropertySheetPanel.this.m_CapabilitiesText.setText(helpText.toString());
            PropertySheetPanel.this.m_CapabilitiesText.setCaretPosition(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateText();
        }
    }
}

