/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.Messages;
import weka.gui.TaskLogger;
import weka.gui.WekaTaskMonitor;

public class LogPanel
extends JPanel
implements Logger,
TaskLogger {
    private static final long serialVersionUID = -4072464549112439484L;
    protected JLabel m_StatusLab;
    protected JTextArea m_LogText;
    protected JButton m_logButton;
    protected boolean m_First;
    protected WekaTaskMonitor m_TaskMonitor;

    public LogPanel() {
        this(null, false, false, true);
    }

    public LogPanel(WekaTaskMonitor tm) {
        this(tm, true, false, true);
    }

    public LogPanel(WekaTaskMonitor tm, boolean logHidden) {
        this(tm, logHidden, false, true);
    }

    public LogPanel(WekaTaskMonitor tm, boolean logHidden, boolean statusHidden, boolean titledBorder) {
        Messages.getInstance();
        this.m_StatusLab = new JLabel(Messages.getString("LogPanel_TaskLogger_StatusLab_JLabel_Text"));
        this.m_LogText = new JTextArea(4, 20);
        Messages.getInstance();
        this.m_logButton = new JButton(Messages.getString("LogPanel_TaskLogger_LogButton_JButton_Text"));
        this.m_First = true;
        this.m_TaskMonitor = null;
        this.m_TaskMonitor = tm;
        this.m_LogText.setEditable(false);
        this.m_LogText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Messages.getInstance();
        this.m_StatusLab.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("LogPanel_StatusLab_SetBorder_BorderFactoryCreateCompoundBorder_Text")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JScrollPane js = new JScrollPane(this.m_LogText);
        js.getViewport().addChangeListener(new ChangeListener(){
            private int lastHeight;

            @Override
            public void stateChanged(ChangeEvent e) {
                JViewport vp = (JViewport)e.getSource();
                int h = vp.getViewSize().height;
                if (h != this.lastHeight) {
                    this.lastHeight = h;
                    int x = h - vp.getExtentSize().height;
                    vp.setViewPosition(new Point(0, x));
                }
            }
        });
        if (logHidden) {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("LogPanel_Jf_JFrame_Text"));
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.setVisible(false);
                }
            });
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)js, "Center");
            jf.pack();
            jf.setSize(450, 350);
            this.m_logButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    jf.setVisible(true);
                }
            });
            this.setLayout(new BorderLayout());
            JPanel logButPanel = new JPanel();
            logButPanel.setLayout(new BorderLayout());
            logButPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
            logButPanel.add((Component)this.m_logButton, "Center");
            JPanel p1 = new JPanel();
            p1.setLayout(new BorderLayout());
            p1.add((Component)this.m_StatusLab, "Center");
            p1.add((Component)logButPanel, "East");
            if (tm == null) {
                this.add((Component)p1, "South");
            } else {
                JPanel p2 = new JPanel();
                p2.setLayout(new BorderLayout());
                p2.add((Component)p1, "Center");
                p2.add((Component)this.m_TaskMonitor, "East");
                this.add((Component)p2, "South");
            }
        } else {
            JPanel p1 = new JPanel();
            if (titledBorder) {
                Messages.getInstance();
                p1.setBorder(BorderFactory.createTitledBorder(Messages.getString("LogPanel_P1_SetBorder_BorderFactoryCreateTitledBorder_Text")));
            }
            p1.setLayout(new BorderLayout());
            p1.add((Component)js, "Center");
            this.setLayout(new BorderLayout());
            this.add((Component)p1, "Center");
            if (tm == null) {
                if (!statusHidden) {
                    this.add((Component)this.m_StatusLab, "South");
                }
            } else if (!statusHidden) {
                JPanel p2 = new JPanel();
                p2.setLayout(new BorderLayout());
                p2.add((Component)this.m_StatusLab, "Center");
                p2.add((Component)this.m_TaskMonitor, "East");
                this.add((Component)p2, "South");
            }
        }
        this.addPopup();
    }

    private String printLong(long l) {
        String str = Long.toString(l);
        String result = "";
        int count = 0;
        int i = str.length() - 1;
        while (i >= 0) {
            result = String.valueOf(str.charAt(i)) + result;
            if (++count == 3 && i > 0) {
                result = "," + result;
                count = 0;
            }
            --i;
        }
        return result;
    }

    private void addPopup() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 16 || e.isAltDown()) {
                    JPopupMenu gcMenu = new JPopupMenu();
                    Messages.getInstance();
                    JMenuItem availMem = new JMenuItem(Messages.getString("LogPanel_AddPopup_AvailMem_JMenuItem_Text"));
                    availMem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ee) {
                            System.gc();
                            Runtime currR = Runtime.getRuntime();
                            long freeM = currR.freeMemory();
                            long totalM = currR.totalMemory();
                            long maxM = currR.maxMemory();
                            LogPanel logPanel = LogPanel.this;
                            Messages.getInstance();
                            StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("LogPanel_AddPopup_LogMessage_Text_First"))).append(LogPanel.this.printLong(freeM));
                            Messages.getInstance();
                            StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("LogPanel_AddPopup_LogMessage_Text_Second")).append(LogPanel.this.printLong(totalM));
                            Messages.getInstance();
                            logPanel.logMessage(stringBuilder2.append(Messages.getString("LogPanel_AddPopup_LogMessage_Text_Third")).append(LogPanel.this.printLong(maxM)).toString());
                            LogPanel logPanel2 = LogPanel.this;
                            Messages.getInstance();
                            StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("LogPanel_AddPopup_StatusMessage_Text_First"))).append(LogPanel.this.printLong(freeM));
                            Messages.getInstance();
                            StringBuilder stringBuilder4 = stringBuilder3.append(Messages.getString("LogPanel_AddPopup_StatusMessage_Text_Second")).append(LogPanel.this.printLong(totalM));
                            Messages.getInstance();
                            logPanel2.statusMessage(stringBuilder4.append(Messages.getString("LogPanel_AddPopup_StatusMessage_Text_Third")).append(LogPanel.this.printLong(maxM)).toString());
                        }
                    });
                    gcMenu.add(availMem);
                    Messages.getInstance();
                    JMenuItem runGC = new JMenuItem(Messages.getString("LogPanel_AddPopup_RunGC_JMenuItem_Text"));
                    runGC.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ee) {
                            LogPanel logPanel = LogPanel.this;
                            Messages.getInstance();
                            logPanel.statusMessage(Messages.getString("LogPanel_AddPopup_StatusMessage_Text_Fourth"));
                            System.gc();
                            LogPanel logPanel2 = LogPanel.this;
                            Messages.getInstance();
                            logPanel2.statusMessage(Messages.getString("LogPanel_AddPopup_StatusMessage_Text_Fifth"));
                        }
                    });
                    gcMenu.add(runGC);
                    gcMenu.show(LogPanel.this, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void taskStarted() {
        if (this.m_TaskMonitor != null) {
            this.m_TaskMonitor.taskStarted();
        }
    }

    @Override
    public void taskFinished() {
        if (this.m_TaskMonitor != null) {
            this.m_TaskMonitor.taskFinished();
        }
    }

    protected static String getTimestamp() {
        return new SimpleDateFormat("HH:mm:ss:").format(new Date());
    }

    @Override
    public synchronized void logMessage(String message) {
        if (this.m_First) {
            this.m_First = false;
        } else {
            this.m_LogText.append("\n");
        }
        this.m_LogText.append(String.valueOf(LogPanel.getTimestamp()) + ' ' + message);
        weka.core.logging.Logger.log(Logger.Level.INFO, message);
    }

    @Override
    public synchronized void statusMessage(String message) {
        this.m_StatusLab.setText(message);
    }

    public static void main(String[] args) {
        try {
            Messages.getInstance();
            final JFrame jf = new JFrame(Messages.getString("LogPanel_Main_JFrame_Text"));
            jf.getContentPane().setLayout(new BorderLayout());
            LogPanel lp = new LogPanel();
            jf.getContentPane().add((Component)lp, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setVisible(true);
            Messages.getInstance();
            lp.logMessage(Messages.getString("LogPanel_Main_Lp_LogMessage_Text_First"));
            Messages.getInstance();
            lp.statusMessage(Messages.getString("LogPanel_Main_Lp_StatusMessage_Text"));
            Messages.getInstance();
            lp.logMessage(Messages.getString("LogPanel_Main_Lp_LogMessage_Text_Second"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

