/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import weka.gui.Messages;

public class ListSelectorDialog
extends JDialog {
    private static final long serialVersionUID = 906147926840288895L;
    protected JButton m_SelectBut;
    protected JButton m_CancelBut;
    protected JButton m_PatternBut;
    protected JList m_List;
    protected int m_Result;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected String m_PatternRegEx;

    public ListSelectorDialog(Frame parentFrame, JList userList) {
        Messages.getInstance();
        super((Window)parentFrame, Messages.getString("ListSelectorDialog_Text"), Dialog.ModalityType.DOCUMENT_MODAL);
        Messages.getInstance();
        this.m_SelectBut = new JButton(Messages.getString("ListSelectorDialog_SelectBut_JButton_Text"));
        Messages.getInstance();
        this.m_CancelBut = new JButton(Messages.getString("ListSelectorDialog_CancelBut_JButton_Text"));
        Messages.getInstance();
        this.m_PatternBut = new JButton(Messages.getString("ListSelectorDialog_PatternBut_JButton_Text"));
        this.m_PatternRegEx = ".*";
        this.m_List = userList;
        this.m_CancelBut.setMnemonic('C');
        this.m_CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectorDialog.this.m_Result = 1;
                ListSelectorDialog.this.setVisible(false);
            }
        });
        this.m_SelectBut.setMnemonic('S');
        this.m_SelectBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectorDialog.this.m_Result = 0;
                ListSelectorDialog.this.setVisible(false);
            }
        });
        this.m_PatternBut.setMnemonic('P');
        this.m_PatternBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListSelectorDialog.this.selectPattern();
            }
        });
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        Box b1 = new Box(0);
        b1.add(this.m_SelectBut);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(this.m_PatternBut);
        b1.add(Box.createHorizontalStrut(10));
        b1.add(this.m_CancelBut);
        c.add((Component)b1, "South");
        c.add((Component)new JScrollPane(this.m_List), "Center");
        this.getRootPane().setDefaultButton(this.m_SelectBut);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (double)this.getWidth() > screen.getWidth() ? (int)screen.getWidth() : this.getWidth();
        int height = (double)this.getHeight() > screen.getHeight() ? (int)screen.getHeight() : this.getHeight();
        this.setSize(width, height);
    }

    public int showDialog() {
        this.m_Result = 1;
        int[] origSelected = this.m_List.getSelectedIndices();
        this.setVisible(true);
        if (this.m_Result == 1) {
            this.m_List.setSelectedIndices(origSelected);
        }
        return this.m_Result;
    }

    protected void selectPattern() {
        Container container = this.m_PatternBut.getParent();
        Messages.getInstance();
        String pattern = JOptionPane.showInputDialog(container, Messages.getString("ListSelectorDialog_SelectPattern_Pattern_JOptionPaneShowInputDialog_Text"), this.m_PatternRegEx);
        if (pattern != null) {
            try {
                Pattern.compile(pattern);
                this.m_PatternRegEx = pattern;
                this.m_List.clearSelection();
                int i = 0;
                while (i < this.m_List.getModel().getSize()) {
                    if (Pattern.matches(pattern, this.m_List.getModel().getElementAt(i).toString())) {
                        this.m_List.addSelectionInterval(i, i);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                Container container2 = this.m_PatternBut.getParent();
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("ListSelectorDialog_SelectPattern_Exception_JOptionPaneShowInputDialog_Text_First"))).append(pattern);
                Messages.getInstance();
                String string = stringBuilder.append(Messages.getString("ListSelectorDialog_SelectPattern_Exception_JOptionPaneShowInputDialog_Text_Second")).append(ex).toString();
                Messages.getInstance();
                JOptionPane.showMessageDialog(container2, string, Messages.getString("ListSelectorDialog_SelectPattern_Exception_JOptionPaneShowInputDialog_Text_Third"), 0);
            }
        }
    }

    public static void main(String[] args) {
        try {
            DefaultListModel<String> lm = new DefaultListModel<String>();
            Messages.getInstance();
            lm.addElement(Messages.getString("ListSelectorDialog_Main_DefaultListModel_AddElement_Text_First"));
            Messages.getInstance();
            lm.addElement(Messages.getString("ListSelectorDialog_Main_DefaultListModel_AddElement_Text_Second"));
            Messages.getInstance();
            lm.addElement(Messages.getString("ListSelectorDialog_Main_DefaultListModel_AddElement_Text_Third"));
            Messages.getInstance();
            lm.addElement(Messages.getString("ListSelectorDialog_Main_DefaultListModel_AddElement_Text_Fourth"));
            Messages.getInstance();
            lm.addElement(Messages.getString("ListSelectorDialog_Main_DefaultListModel_AddElement_Text_Fifth"));
            JList jl = new JList(lm);
            ListSelectorDialog jd = new ListSelectorDialog(null, jl);
            int result = jd.showDialog();
            if (result == 0) {
                Messages.getInstance();
                System.err.println(Messages.getString("ListSelectorDialog_Main_DefaultListModel_Error_Text_First"));
                int[] selected = jl.getSelectedIndices();
                int i = 0;
                while (i < selected.length) {
                    System.err.println(selected[i] + " " + lm.elementAt(selected[i]));
                    ++i;
                }
            } else {
                Messages.getInstance();
                System.err.println(Messages.getString("ListSelectorDialog_Main_DefaultListModel_Error_Text_Second"));
            }
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

