/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import weka.gui.Messages;

public class JListHelper {
    public static final int MOVE_UP = 0;
    public static final int MOVE_DOWN = 1;

    protected static void moveItems(JList list, int moveby, int direction) {
        DefaultListModel model = (DefaultListModel)list.getModel();
        switch (direction) {
            case 0: {
                int[] indices = list.getSelectedIndices();
                int i = 0;
                while (i < indices.length) {
                    if (indices[i] != 0) {
                        Object o = model.remove(indices[i]);
                        int n = i;
                        indices[n] = indices[n] - moveby;
                        model.insertElementAt(o, indices[i]);
                    }
                    ++i;
                }
                list.setSelectedIndices(indices);
                break;
            }
            case 1: {
                int[] indices = list.getSelectedIndices();
                int i = indices.length - 1;
                while (i >= 0) {
                    if (indices[i] != model.getSize() - 1) {
                        Object o = model.remove(indices[i]);
                        int n = i;
                        indices[n] = indices[n] + moveby;
                        model.insertElementAt(o, indices[i]);
                    }
                    --i;
                }
                list.setSelectedIndices(indices);
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(JListHelper.class.getName()));
                Messages.getInstance();
                StringBuilder stringBuilder2 = stringBuilder.append(Messages.getString("JListHelper_MoveItems_Error_Text_First")).append(direction);
                Messages.getInstance();
                System.err.println(stringBuilder2.append(Messages.getString("JListHelper_MoveItems_Error_Text_Second")).toString());
            }
        }
    }

    public static void moveUp(JList list) {
        if (JListHelper.canMoveUp(list)) {
            JListHelper.moveItems(list, 1, 0);
        }
    }

    public static void moveDown(JList list) {
        if (JListHelper.canMoveDown(list)) {
            JListHelper.moveItems(list, 1, 1);
        }
    }

    public static void moveTop(JList list) {
        if (JListHelper.canMoveUp(list)) {
            int[] indices = list.getSelectedIndices();
            int diff = indices[0];
            JListHelper.moveItems(list, diff, 0);
        }
    }

    public static void moveBottom(JList list) {
        if (JListHelper.canMoveDown(list)) {
            int[] indices = list.getSelectedIndices();
            int diff = list.getModel().getSize() - 1 - indices[indices.length - 1];
            JListHelper.moveItems(list, diff, 1);
        }
    }

    public static boolean canMoveUp(JList list) {
        boolean result = false;
        int[] indices = list.getSelectedIndices();
        if (indices.length > 0 && indices[0] > 0) {
            result = true;
        }
        return result;
    }

    public static boolean canMoveDown(JList list) {
        boolean result = false;
        int[] indices = list.getSelectedIndices();
        if (indices.length > 0 && indices[indices.length - 1] < list.getModel().getSize() - 1) {
            result = true;
        }
        return result;
    }
}

