/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.SystemInfo;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.ConverterUtils;
import weka.core.logging.Logger;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.Messages;
import weka.gui.SimpleCLI;
import weka.gui.arffviewer.ArffViewer;
import weka.gui.beans.KnowledgeFlow;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class GUIChooser
extends JFrame {
    private static final long serialVersionUID = 9001529425230247914L;
    protected GUIChooser m_Self;
    private JMenuBar m_jMenuBar;
    private JMenu m_jMenuProgram;
    private JMenu m_jMenuVisualization;
    private JMenu m_jMenuTools;
    private JMenu m_jMenuHelp;
    protected JPanel m_PanelApplications;
    protected JButton m_ExplorerBut;
    protected JFrame m_ExplorerFrame;
    protected JButton m_ExperimenterBut;
    protected JFrame m_ExperimenterFrame;
    protected JButton m_KnowledgeFlowBut;
    protected String m_pendingKnowledgeFlowLoad;
    protected JFrame m_KnowledgeFlowFrame;
    protected JButton m_SimpleBut;
    protected SimpleCLI m_SimpleCLI;
    protected Vector m_ArffViewers;
    protected JFrame m_SqlViewerFrame;
    protected JFrame m_BayesNetGUIFrame;
    protected JFrame m_EnsembleLibraryFrame;
    protected Vector m_Plots;
    protected Vector m_ROCs;
    protected Vector m_TreeVisualizers;
    protected Vector m_GraphVisualizers;
    protected JFrame m_BoundaryVisualizerFrame;
    protected JFrame m_SystemInfoFrame;
    protected JFrame m_MemoryUsageFrame;
    protected static LogWindow m_LogWindow;
    Image m_weka;
    protected JFileChooser m_FileChooserTreeVisualizer;
    protected JFileChooser m_FileChooserGraphVisualizer;
    protected JFileChooser m_FileChooserPlot;
    protected JFileChooser m_FileChooserROC;
    protected Image m_Icon;
    protected HashSet<Container> m_ChildFrames;
    private static GUIChooser m_chooser;
    private static Memory m_Memory;

    static {
        try {
            Object MacApp = Class.forName("com.apple.eawt.Application").newInstance();
            Object macArffHandler = Class.forName("weka.gui.MacArffOpenFilesHandler").newInstance();
            Class<?> fileHandlerClass = Class.forName("com.apple.eawt.OpenFilesHandler");
            Class[] paramClass = new Class[]{fileHandlerClass};
            Object[] args = new Object[]{macArffHandler};
            Method m = MacApp.getClass().getMethod("setOpenFileHandler", paramClass);
            System.out.println("Trying to install a file handler for Mac...");
            m.invoke(MacApp, macArffHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_LogWindow = new LogWindow();
        m_Memory = new Memory(true);
    }

    public static synchronized void createSingleton() {
        if (m_chooser == null) {
            m_chooser = new GUIChooser();
        }
    }

    public static GUIChooser getSingleton() {
        return m_chooser;
    }

    public GUIChooser() {
        Messages.getInstance();
        super(Messages.getString("GUIChooser_Title_Text"));
        this.m_PanelApplications = new JPanel();
        Messages.getInstance();
        this.m_ExplorerBut = new JButton(Messages.getString("GUIChooser_Explorer_Text"));
        Messages.getInstance();
        this.m_ExperimenterBut = new JButton(Messages.getString("GUIChooser_Experimenter_Text"));
        Messages.getInstance();
        this.m_KnowledgeFlowBut = new JButton(Messages.getString("GUIChooser_KnowledgeFlow_Text"));
        this.m_pendingKnowledgeFlowLoad = null;
        Messages.getInstance();
        this.m_SimpleBut = new JButton(Messages.getString("GUIChooser_Simple_CLI_Text"));
        this.m_ArffViewers = new Vector();
        this.m_Plots = new Vector();
        this.m_ROCs = new Vector();
        this.m_TreeVisualizers = new Vector();
        this.m_GraphVisualizers = new Vector();
        this.m_weka = Toolkit.getDefaultToolkit().getImage(GUIChooser.class.getClassLoader().getResource("weka/gui/images/weka_background.gif"));
        this.m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
        this.m_ChildFrames = new HashSet();
        this.m_Self = this;
        Messages.getInstance();
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", Messages.getString("GUIChooser_BIF_Files_Text")));
        Messages.getInstance();
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", Messages.getString("GUIChooser_XML_Files_Text")));
        Messages.getInstance();
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_ARFF_Files_Text_Front"))).append(".arff");
        Messages.getInstance();
        this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", stringBuilder.append(Messages.getString("GUIChooser_ARFF_Files_Text_End")).toString()));
        this.m_FileChooserPlot.setMultiSelectionEnabled(true);
        Messages.getInstance();
        StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_ARFF_Files_Text_Front"))).append(".arff");
        Messages.getInstance();
        this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", stringBuilder2.append(Messages.getString("GUIChooser_ARFF_Files_Text_End")).toString()));
        this.m_Icon = Toolkit.getDefaultToolkit().getImage(GUIChooser.class.getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
        this.setIconImage(this.m_Icon);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_PanelApplications, "East");
        Messages.getInstance();
        this.m_PanelApplications.setBorder(BorderFactory.createTitledBorder(Messages.getString("GUIChooser_Applications_Text")));
        this.m_PanelApplications.setLayout(new GridLayout(4, 1));
        this.m_PanelApplications.add(this.m_ExplorerBut);
        this.m_PanelApplications.add(this.m_ExperimenterBut);
        this.m_PanelApplications.add(this.m_KnowledgeFlowBut);
        this.m_PanelApplications.add(this.m_SimpleBut);
        JPanel wekaPan = new JPanel();
        wekaPan.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wekaPan.setLayout(new BorderLayout());
        Messages.getInstance();
        wekaPan.setToolTipText(Messages.getString("GUIChooser_Weka_Native_Bird_Text"));
        ImageIcon wii = new ImageIcon(this.m_weka);
        JLabel wekaLab = new JLabel(wii);
        wekaPan.add((Component)wekaLab, "Center");
        Messages.getInstance();
        StringBuilder stringBuilder3 = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_Information_Text_Front"))).append(" ").append(Version.VERSION).append("<br>").append("(c) ").append(Copyright.getFromYear()).append(" - ").append(Copyright.getToYear()).append("<br>").append(Copyright.getOwner()).append("<br>").append(Copyright.getAddress());
        Messages.getInstance();
        String infoString = stringBuilder3.append(Messages.getString("GUIChooser_Information_Text_End")).toString();
        JLabel infoLab = new JLabel(infoString);
        infoLab.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        wekaPan.add((Component)infoLab, "South");
        this.getContentPane().add((Component)wekaPan, "Center");
        this.m_jMenuBar = new JMenuBar();
        this.m_jMenuProgram = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuProgram);
        Messages.getInstance();
        this.m_jMenuProgram.setText(Messages.getString("GUIChooser_Program_Text"));
        this.m_jMenuProgram.setMnemonic('P');
        JMenuItem jMenuItemProgramLogWindow = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramLogWindow);
        Messages.getInstance();
        jMenuItemProgramLogWindow.setText(Messages.getString("GUIChooser_LogWindow_Text"));
        jMenuItemProgramLogWindow.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        m_LogWindow.setIconImage(this.m_Icon);
        jMenuItemProgramLogWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                m_LogWindow.setVisible(true);
            }
        });
        final JMenuItem jMenuItemProgramMemUsage = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramMemUsage);
        Messages.getInstance();
        jMenuItemProgramMemUsage.setText(Messages.getString("GUIChooser_Memory_Usage_Text"));
        jMenuItemProgramMemUsage.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenuItemProgramMemUsage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_MemoryUsageFrame == null) {
                    final MemoryUsagePanel panel = new MemoryUsagePanel();
                    jMenuItemProgramMemUsage.setEnabled(false);
                    Messages.getInstance();
                    GUIChooser.this.m_MemoryUsageFrame = new JFrame(Messages.getString("GUIChooser_Memory_Usage_List_Text"));
                    GUIChooser.this.m_MemoryUsageFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().add((Component)panel, "Center");
                    GUIChooser.this.m_MemoryUsageFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            panel.stopMonitoring();
                            (this).GUIChooser.this.m_MemoryUsageFrame.dispose();
                            (this).GUIChooser.this.m_MemoryUsageFrame = null;
                            jMenuItemProgramMemUsage.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_MemoryUsageFrame.pack();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(400, 50);
                    Point l = panel.getFrameLocation();
                    if (l.x != -1 && l.y != -1) {
                        GUIChooser.this.m_MemoryUsageFrame.setLocation(l);
                    }
                    GUIChooser.this.m_MemoryUsageFrame.setVisible(true);
                    Dimension size = GUIChooser.this.m_MemoryUsageFrame.getPreferredSize();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(new Dimension((int)size.getWidth(), (int)size.getHeight()));
                }
            }
        });
        this.m_jMenuProgram.add(new JSeparator());
        JMenuItem jMenuItemProgramExit = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItemProgramExit);
        Messages.getInstance();
        jMenuItemProgramExit.setText(Messages.getString("GUIChooser_Exit_Text"));
        jMenuItemProgramExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItemProgramExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.m_jMenuVisualization = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuVisualization);
        this.m_jMenuVisualization.setText(Messages.getString("GUIChooser_Visualization_Text"));
        this.m_jMenuVisualization.setMnemonic('V');
        JMenuItem jMenuItemVisualizationPlot = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationPlot);
        Messages.getInstance();
        jMenuItemVisualizationPlot.setText(Messages.getString("GUIChooser_Plot_Text"));
        jMenuItemVisualizationPlot.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItemVisualizationPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserPlot.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                VisualizePanel panel = new VisualizePanel();
                String filenames = "";
                File[] files = GUIChooser.this.m_FileChooserPlot.getSelectedFiles();
                int j = 0;
                while (j < files.length) {
                    String filename = files[j].getAbsolutePath();
                    if (j > 0) {
                        filenames = String.valueOf(filenames) + ", ";
                    }
                    filenames = String.valueOf(filenames) + filename;
                    Messages.getInstance();
                    System.err.println(String.valueOf(Messages.getString("GUIChooser_LoadingInstancesFrom_Error_Text")) + filename);
                    try {
                        BufferedReader r = new BufferedReader(new FileReader(filename));
                        Instances i = new Instances(r);
                        i.setClassIndex(i.numAttributes() - 1);
                        PlotData2D pd1 = new PlotData2D(i);
                        if (j == 0) {
                            Messages.getInstance();
                            pd1.setPlotName(Messages.getString("GUIChooser_MasterPlot_Text"));
                            panel.setMasterPlot(pd1);
                        } else {
                            Messages.getInstance();
                            pd1.setPlotName(String.valueOf(Messages.getString("GUIChooser_Plot_Text")) + (j + 1));
                            pd1.m_useCustomColour = true;
                            pd1.m_customColour = j % 2 == 0 ? Color.red : Color.blue;
                            panel.addPlot(pd1);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        GUIChooser gUIChooser = GUIChooser.this.m_Self;
                        Messages.getInstance();
                        StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_Plot_LoadingFile_Error_Text_Front"))).append(files[j]);
                        Messages.getInstance();
                        JOptionPane.showMessageDialog(gUIChooser, stringBuilder.append(Messages.getString("GUIChooser_Plot_LoadingFile_Error_Text_End")).append(ex.getMessage()).toString());
                        return;
                    }
                    ++j;
                }
                Messages.getInstance();
                final JFrame frame = new JFrame(String.valueOf(Messages.getString("GUIChooser_Plot_PlotName_Text")) + filenames);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        (this).GUIChooser.this.m_Plots.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_Plots.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationROC = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationROC);
        Messages.getInstance();
        jMenuItemVisualizationROC.setText(Messages.getString("GUIChooser_ROC_Text"));
        jMenuItemVisualizationROC.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItemVisualizationROC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserROC.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooser.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                Instances result = null;
                try {
                    result = new Instances(new BufferedReader(new FileReader(filename)));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIChooser gUIChooser = GUIChooser.this.m_Self;
                    Messages.getInstance();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_ROC_LoadingFile_Error_Text_Front"))).append(filename);
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(gUIChooser, stringBuilder.append(Messages.getString("GUIChooser_ROC_LoadingFile_Error_Text_End")).append(ex.getMessage()).toString());
                    return;
                }
                result.setClassIndex(result.numAttributes() - 1);
                ThresholdVisualizePanel vmc = new ThresholdVisualizePanel();
                Messages.getInstance();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_ROC_AreaUnderROC_Text_Front"))).append(Utils.doubleToString(ThresholdCurve.getROCArea(result), 4));
                Messages.getInstance();
                vmc.setROCString(stringBuilder.append(Messages.getString("GUIChooser_ROC_AreaUnderROC_Text_End")).toString());
                vmc.setName(result.relationName());
                PlotData2D tempd = new PlotData2D(result);
                tempd.setPlotName(result.relationName());
                tempd.addInstanceNumberAttribute();
                try {
                    vmc.addPlot(tempd);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIChooser gUIChooser = GUIChooser.this.m_Self;
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(gUIChooser, String.valueOf(Messages.getString("GUIChooser_ROC_AddingPlot_Error_Text")) + ex.getMessage());
                    return;
                }
                Messages.getInstance();
                final JFrame frame = new JFrame(String.valueOf(Messages.getString("GUIChooser_ROC_File_Text")) + filename);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)vmc, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        (this).GUIChooser.this.m_ROCs.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_ROCs.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationTree = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationTree);
        Messages.getInstance();
        jMenuItemVisualizationTree.setText(Messages.getString("GUIChooser_TreeVisualizer_Text"));
        jMenuItemVisualizationTree.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItemVisualizationTree.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserTreeVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooser.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                TreeBuild builder = new TreeBuild();
                Node top = null;
                PlaceNode2 arrange = new PlaceNode2();
                try {
                    top = builder.create(new FileReader(filename));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIChooser gUIChooser = GUIChooser.this.m_Self;
                    Messages.getInstance();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_TreeVisualizer_LoadingFile_Error_Text_Front"))).append(filename);
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(gUIChooser, stringBuilder.append(Messages.getString("GUIChooser_TreeVisualizer_LoadingFile_Error_Text_End")).append(ex.getMessage()).toString());
                    return;
                }
                Messages.getInstance();
                final JFrame frame = new JFrame(String.valueOf(Messages.getString("GUIChooser_TreeVisualizer_File_Text")) + filename);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)new TreeVisualizer(null, top, (NodePlace)arrange), "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        (this).GUIChooser.this.m_TreeVisualizers.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_TreeVisualizers.add(frame);
            }
        });
        JMenuItem jMenuItemVisualizationGraph = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationGraph);
        Messages.getInstance();
        jMenuItemVisualizationGraph.setText(Messages.getString("GUIChooser_GraphVisualizer_Text"));
        jMenuItemVisualizationGraph.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItemVisualizationGraph.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int retVal = GUIChooser.this.m_FileChooserGraphVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (retVal != 0) {
                    return;
                }
                String filename = GUIChooser.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                GraphVisualizer panel = new GraphVisualizer();
                try {
                    if (filename.toLowerCase().endsWith(".xml") || filename.toLowerCase().endsWith(".bif")) {
                        panel.readBIF(new FileInputStream(filename));
                    } else {
                        panel.readDOT(new FileReader(filename));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    GUIChooser gUIChooser = GUIChooser.this.m_Self;
                    Messages.getInstance();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(Messages.getString("GUIChooser_GraphVisualizer_LoadingFile_Error_Text_Front"))).append(filename);
                    Messages.getInstance();
                    JOptionPane.showMessageDialog(gUIChooser, stringBuilder.append(Messages.getString("GUIChooser_GraphVisualizer_LoadingFile_Error_Text_End")).append(ex.getMessage()).toString());
                    return;
                }
                Messages.getInstance();
                final JFrame frame = new JFrame(String.valueOf(Messages.getString("GUIChooser_GraphVisualizer_File_Text")) + filename);
                frame.setIconImage(GUIChooser.this.m_Icon);
                frame.getContentPane().setLayout(new BorderLayout());
                frame.getContentPane().add((Component)panel, "Center");
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        (this).GUIChooser.this.m_GraphVisualizers.remove(frame);
                        frame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                frame.pack();
                frame.setSize(800, 600);
                frame.setVisible(true);
                GUIChooser.this.m_GraphVisualizers.add(frame);
            }
        });
        final JMenuItem jMenuItemVisualizationBoundary = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItemVisualizationBoundary);
        Messages.getInstance();
        jMenuItemVisualizationBoundary.setText(Messages.getString("GUIChooser_BoundaryVisualizer_Text"));
        jMenuItemVisualizationBoundary.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenuItemVisualizationBoundary.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_BoundaryVisualizerFrame == null) {
                    jMenuItemVisualizationBoundary.setEnabled(false);
                    Messages.getInstance();
                    GUIChooser.this.m_BoundaryVisualizerFrame = new JFrame(Messages.getString("GUIChooser_BoundaryVisualizer_JFrame_Text"));
                    GUIChooser.this.m_BoundaryVisualizerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().setLayout(new BorderLayout());
                    final BoundaryVisualizer bv = new BoundaryVisualizer();
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().add((Component)bv, "Center");
                    GUIChooser.this.m_BoundaryVisualizerFrame.setSize(bv.getMinimumSize());
                    GUIChooser.this.m_BoundaryVisualizerFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            bv.stopPlotting();
                            (this).GUIChooser.this.m_BoundaryVisualizerFrame.dispose();
                            (this).GUIChooser.this.m_BoundaryVisualizerFrame = null;
                            jMenuItemVisualizationBoundary.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BoundaryVisualizerFrame.pack();
                    GUIChooser.this.m_BoundaryVisualizerFrame.setResizable(false);
                    GUIChooser.this.m_BoundaryVisualizerFrame.setVisible(true);
                    BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                }
            }
        });
        Messages.getInstance();
        JMenu jMenuExtensions = new JMenu(Messages.getString("GUIChooser_Extensions_Text"));
        jMenuExtensions.setMnemonic(69);
        this.m_jMenuBar.add(jMenuExtensions);
        jMenuExtensions.setVisible(false);
        String extensions = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
        if (extensions.length() > 0) {
            jMenuExtensions.setVisible(true);
            String[] classnames = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
            Hashtable<String, JMenu> submenus = new Hashtable<String, JMenu>();
            String[] stringArray = classnames;
            int n = classnames.length;
            int n2 = 0;
            while (n2 < n) {
                String classname = stringArray[n2];
                try {
                    MainMenuExtension ext = (MainMenuExtension)Class.forName(classname).newInstance();
                    JMenu submenu = null;
                    if (ext.getSubmenuTitle() != null && (submenu = (JMenu)submenus.get(ext.getSubmenuTitle())) == null) {
                        submenu = new JMenu(ext.getSubmenuTitle());
                        submenus.put(ext.getSubmenuTitle(), submenu);
                        this.insertMenuItem(jMenuExtensions, submenu);
                    }
                    JMenuItem menuitem = new JMenuItem();
                    menuitem.setText(ext.getMenuTitle());
                    ActionListener listener = ext.getActionListener(this.m_Self);
                    if (listener != null) {
                        menuitem.addActionListener(listener);
                    } else {
                        final JMenuItem finalMenuitem = menuitem;
                        final MainMenuExtension finalExt = ext;
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Container frame = GUIChooser.this.createFrame(GUIChooser.this.m_Self, finalMenuitem.getText(), null, null, null, -1, -1, null, false, false);
                                finalExt.fillFrame(frame);
                                frame.setVisible(true);
                            }
                        });
                    }
                    if (submenu != null) {
                        this.insertMenuItem(submenu, menuitem);
                    } else {
                        this.insertMenuItem(jMenuExtensions, menuitem);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        this.m_jMenuTools = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuTools);
        Messages.getInstance();
        this.m_jMenuTools.setText(Messages.getString("GUIChooser_Tools_Text"));
        this.m_jMenuTools.setMnemonic('T');
        JMenuItem jMenuItemToolsArffViewer = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsArffViewer);
        Messages.getInstance();
        jMenuItemToolsArffViewer.setText(Messages.getString("GUIChooser_ArffViewer_Text"));
        jMenuItemToolsArffViewer.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        jMenuItemToolsArffViewer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ArffViewer av = new ArffViewer();
                av.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent w) {
                        (this).GUIChooser.this.m_ArffViewers.remove(av);
                        GUIChooser.this.checkExit();
                    }
                });
                av.setVisible(true);
                GUIChooser.this.m_ArffViewers.add(av);
            }
        });
        final JMenuItem jMenuItemToolsSql = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemToolsSql);
        Messages.getInstance();
        jMenuItemToolsSql.setText(Messages.getString("GUIChooser_SqlViewer_Text"));
        jMenuItemToolsSql.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItemToolsSql.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_SqlViewerFrame == null) {
                    jMenuItemToolsSql.setEnabled(false);
                    final SqlViewer sql = new SqlViewer(null);
                    Messages.getInstance();
                    GUIChooser.this.m_SqlViewerFrame = new JFrame(Messages.getString("GUIChooser_SqlViewer_JFrame_Text"));
                    GUIChooser.this.m_SqlViewerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().add((Component)sql, "Center");
                    GUIChooser.this.m_SqlViewerFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            sql.saveSize();
                            (this).GUIChooser.this.m_SqlViewerFrame.dispose();
                            (this).GUIChooser.this.m_SqlViewerFrame = null;
                            jMenuItemToolsSql.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SqlViewerFrame.pack();
                    GUIChooser.this.m_SqlViewerFrame.setVisible(true);
                }
            }
        });
        final JMenuItem jMenuItemBayesNet = new JMenuItem();
        this.m_jMenuTools.add(jMenuItemBayesNet);
        Messages.getInstance();
        jMenuItemBayesNet.setText(Messages.getString("GUIChooser_BayesNetEditor_Text"));
        jMenuItemBayesNet.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItemBayesNet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_BayesNetGUIFrame == null) {
                    jMenuItemBayesNet.setEnabled(false);
                    GUI bayesNetGUI = new GUI();
                    JMenuBar bayesBar = bayesNetGUI.getMenuBar();
                    Messages.getInstance();
                    GUIChooser.this.m_BayesNetGUIFrame = new JFrame(Messages.getString("GUIChooser_BayesNetworkEditor_JFrame_Text"));
                    GUIChooser.this.m_BayesNetGUIFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BayesNetGUIFrame.setJMenuBar(bayesBar);
                    GUIChooser.this.m_BayesNetGUIFrame.getContentPane().add((Component)bayesNetGUI, "Center");
                    GUIChooser.this.m_BayesNetGUIFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            (this).GUIChooser.this.m_BayesNetGUIFrame.dispose();
                            (this).GUIChooser.this.m_BayesNetGUIFrame = null;
                            jMenuItemBayesNet.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BayesNetGUIFrame.setSize(800, 600);
                    GUIChooser.this.m_BayesNetGUIFrame.setVisible(true);
                }
            }
        });
        this.m_jMenuHelp = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuHelp);
        Messages.getInstance();
        this.m_jMenuHelp.setText(Messages.getString("GUIChooser_Help_Text"));
        this.m_jMenuHelp.setMnemonic('H');
        JMenuItem jMenuItemHelpHomepage = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpHomepage);
        Messages.getInstance();
        jMenuItemHelpHomepage.setText(Messages.getString("GUIChooser_WekaHomepage_Text"));
        jMenuItemHelpHomepage.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        jMenuItemHelpHomepage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.getInstance();
                BrowserHelper.openURL(Messages.getString("GUIChooser_WekaHomepage_URL_Text"));
            }
        });
        this.m_jMenuHelp.add(new JSeparator());
        JMenuItem jMenuItemHelpWekaWiki = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpWekaWiki);
        Messages.getInstance();
        jMenuItemHelpWekaWiki.setText(Messages.getString("GUIChooser_WekaHOWTO_Text"));
        jMenuItemHelpWekaWiki.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuItemHelpWekaWiki.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.getInstance();
                BrowserHelper.openURL(Messages.getString("GUIChooser_WekaWiki_URL_Text"));
            }
        });
        JMenuItem jMenuItemHelpSourceforge = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpSourceforge);
        Messages.getInstance();
        jMenuItemHelpSourceforge.setText(Messages.getString("GUIChooser_WekaOnSourceforge_Text"));
        jMenuItemHelpSourceforge.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItemHelpSourceforge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Messages.getInstance();
                BrowserHelper.openURL(Messages.getString("GUIChooser_WekaOnSourceforge_URL_Text"));
            }
        });
        final JMenuItem jMenuItemHelpSysInfo = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItemHelpSysInfo);
        Messages.getInstance();
        jMenuItemHelpSysInfo.setText(Messages.getString("GUIChooser_SystemInfo_Text"));
        jMenuItemHelpSysInfo.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItemHelpSysInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_SystemInfoFrame == null) {
                    jMenuItemHelpSysInfo.setEnabled(false);
                    Messages.getInstance();
                    GUIChooser.this.m_SystemInfoFrame = new JFrame(Messages.getString("GUIChooser_SystemInfo_JFrame_Text"));
                    GUIChooser.this.m_SystemInfoFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().setLayout(new BorderLayout());
                    Hashtable info = new SystemInfo().getSystemInfo();
                    Vector names = new Vector();
                    Enumeration enm = info.keys();
                    while (enm.hasMoreElements()) {
                        names.add(enm.nextElement());
                    }
                    Collections.sort(names);
                    Object[][] data = new String[info.size()][2];
                    int i = 0;
                    while (i < names.size()) {
                        data[i][0] = names.get(i).toString();
                        data[i][1] = info.get(data[i][0]).toString();
                        ++i;
                    }
                    Object[] objectArray = new String[2];
                    Messages.getInstance();
                    objectArray[0] = Messages.getString("GUIChooser_SystemInfo_TitleKey_Text");
                    Messages.getInstance();
                    objectArray[1] = Messages.getString("GUIChooser_SystemInfo_TitleValue_Text");
                    Object[] titles = objectArray;
                    JTable table = new JTable(data, titles);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().add((Component)new JScrollPane(table), "Center");
                    GUIChooser.this.m_SystemInfoFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            (this).GUIChooser.this.m_SystemInfoFrame.dispose();
                            (this).GUIChooser.this.m_SystemInfoFrame = null;
                            jMenuItemHelpSysInfo.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SystemInfoFrame.pack();
                    GUIChooser.this.m_SystemInfoFrame.setSize(800, 600);
                    GUIChooser.this.m_SystemInfoFrame.setVisible(true);
                }
            }
        });
        this.m_ExplorerBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIChooser.this.showExplorer(null);
            }
        });
        this.m_ExperimenterBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_ExperimenterFrame == null) {
                    System.out.println("CALLED ExperimentEnvironment");
                    GUIChooser.this.m_ExperimenterBut.setEnabled(false);
                    Messages.getInstance();
                    GUIChooser.this.m_ExperimenterFrame = new JFrame(Messages.getString("GUIChooser_WekaExperimentEnvironment_JFrame_Text"));
                    GUIChooser.this.m_ExperimenterFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().add((Component)new Experimenter(false), "Center");
                    GUIChooser.this.m_ExperimenterFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            (this).GUIChooser.this.m_ExperimenterFrame.dispose();
                            (this).GUIChooser.this.m_ExperimenterFrame = null;
                            (this).GUIChooser.this.m_ExperimenterBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExperimenterFrame.pack();
                    GUIChooser.this.m_ExperimenterFrame.setSize(800, 600);
                    GUIChooser.this.m_ExperimenterFrame.setVisible(true);
                }
            }
        });
        KnowledgeFlowApp.addStartupListener(new StartUpListener(){

            @Override
            public void startUpComplete() {
                if (GUIChooser.this.m_KnowledgeFlowFrame == null) {
                    final KnowledgeFlowApp kna = KnowledgeFlowApp.getSingleton();
                    GUIChooser.this.m_KnowledgeFlowBut.setEnabled(false);
                    if (GUIChooser.this.m_pendingKnowledgeFlowLoad != null && GUIChooser.this.m_pendingKnowledgeFlowLoad.length() > 0) {
                        KnowledgeFlowApp.getSingleton().loadInitialLayout(GUIChooser.this.m_pendingKnowledgeFlowLoad);
                        GUIChooser.this.m_pendingKnowledgeFlowLoad = null;
                    }
                    Messages.getInstance();
                    GUIChooser.this.m_KnowledgeFlowFrame = new JFrame(Messages.getString("GUIChooser_WekaKnowledgeFlowEnvironment_JFrame_Text"));
                    GUIChooser.this.m_KnowledgeFlowFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().add((Component)kna, "Center");
                    GUIChooser.this.m_KnowledgeFlowFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            kna.clearLayout();
                            (this).GUIChooser.this.m_KnowledgeFlowFrame.dispose();
                            (this).GUIChooser.this.m_KnowledgeFlowFrame = null;
                            (this).GUIChooser.this.m_KnowledgeFlowBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_KnowledgeFlowFrame.pack();
                    GUIChooser.this.m_KnowledgeFlowFrame.setSize(1000, 750);
                    GUIChooser.this.m_KnowledgeFlowFrame.setVisible(true);
                }
            }
        });
        this.m_KnowledgeFlowBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIChooser.this.showKnowledgeFlow(null);
            }
        });
        this.m_SimpleBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GUIChooser.this.m_SimpleCLI == null) {
                    GUIChooser.this.m_SimpleBut.setEnabled(false);
                    try {
                        GUIChooser.this.m_SimpleCLI = new SimpleCLI();
                        GUIChooser.this.m_SimpleCLI.setIconImage(GUIChooser.this.m_Icon);
                    }
                    catch (Exception ex) {
                        Messages.getInstance();
                        throw new Error(Messages.getString("GUIChooser_UnableToStartSimpleCLI_Error_Text"));
                    }
                    GUIChooser.this.m_SimpleCLI.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent w) {
                            (this).GUIChooser.this.m_SimpleCLI.dispose();
                            (this).GUIChooser.this.m_SimpleCLI = null;
                            (this).GUIChooser.this.m_SimpleBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SimpleCLI.setVisible(true);
                }
            }
        });
        this.setJMenuBar(this.m_jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.pack();
    }

    public void showKnowledgeFlow(String fileToLoad) {
        if (this.m_KnowledgeFlowFrame == null) {
            KnowledgeFlow.startApp();
            this.m_pendingKnowledgeFlowLoad = fileToLoad;
        } else if (fileToLoad != null) {
            KnowledgeFlowApp.getSingleton().loadInitialLayout(fileToLoad);
        }
    }

    public void showExplorer(String fileToLoad) {
        Explorer expl = null;
        if (this.m_ExplorerFrame == null) {
            this.m_ExplorerBut.setEnabled(false);
            this.m_ExplorerFrame = new JFrame("Weka Explorer");
            this.m_ExplorerFrame.setIconImage(this.m_Icon);
            this.m_ExplorerFrame.getContentPane().setLayout(new BorderLayout());
            expl = new Explorer();
            this.m_ExplorerFrame.getContentPane().add((Component)expl, "Center");
            this.m_ExplorerFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent w) {
                    GUIChooser.this.m_ExplorerFrame.dispose();
                    GUIChooser.this.m_ExplorerFrame = null;
                    GUIChooser.this.m_ExplorerBut.setEnabled(true);
                    GUIChooser.this.checkExit();
                }
            });
            this.m_ExplorerFrame.pack();
            this.m_ExplorerFrame.setSize(800, 600);
            this.m_ExplorerFrame.setVisible(true);
        } else {
            Component o = this.m_ExplorerFrame.getContentPane().getComponent(0);
            if (o instanceof Explorer) {
                expl = (Explorer)o;
            }
        }
        if (fileToLoad != null) {
            try {
                AbstractFileLoader loader = ConverterUtils.getLoaderForFile(fileToLoad);
                loader.setFile(new File(fileToLoad));
                expl.getPreprocessPanel().setInstancesFromFile(loader);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem) {
        this.insertMenuItem(menu, menuitem, 0);
    }

    protected void insertMenuItem(JMenu menu, JMenuItem menuitem, int startIndex) {
        boolean inserted = false;
        String newStr = menuitem.getText().toLowerCase();
        int i = startIndex;
        while (i < menu.getMenuComponentCount()) {
            JMenuItem current;
            String currentStr;
            if (menu.getMenuComponent(i) instanceof JMenuItem && (currentStr = (current = (JMenuItem)menu.getMenuComponent(i)).getText().toLowerCase()).compareTo(newStr) > 0) {
                inserted = true;
                menu.insert(menuitem, i);
                break;
            }
            ++i;
        }
        if (!inserted) {
            menu.add(menuitem);
        }
    }

    protected Container createFrame(GUIChooser parent, String title, Component c, LayoutManager layout, Object layoutConstraints, int width, int height, JMenuBar menu, boolean listener, boolean visible) {
        ChildFrameSDI result = null;
        final ChildFrameSDI frame = new ChildFrameSDI(parent, title);
        frame.setLayout(layout);
        if (c != null) {
            frame.getContentPane().add(c, layoutConstraints);
        }
        frame.setJMenuBar(menu);
        frame.pack();
        if (width > -1 && height > -1) {
            frame.setSize(width, height);
        }
        frame.validate();
        int screenHeight = this.getGraphicsConfiguration().getBounds().height;
        int screenWidth = this.getGraphicsConfiguration().getBounds().width;
        frame.setLocation((screenWidth - frame.getBounds().width) / 2, (screenHeight - frame.getBounds().height) / 2);
        if (listener) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    frame.dispose();
                }
            });
        }
        if (visible) {
            frame.setVisible(true);
        }
        result = frame;
        return result;
    }

    protected void createTitle(String title) {
        Messages.getInstance();
        String newTitle = String.valueOf(Messages.getString("GUIChooser_CreateTitle_Text_Front")) + new Version();
        if (title.length() != 0) {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(newTitle));
            Messages.getInstance();
            newTitle = stringBuilder.append(Messages.getString("GUIChooser_CreateTitle_Text_End")).append(title).toString();
        }
        this.setTitle(newTitle);
    }

    public void addChildFrame(Container c) {
        this.m_ChildFrames.add(c);
    }

    public boolean removeChildFrame(Container c) {
        boolean result = this.m_ChildFrames.remove(c);
        return result;
    }

    private void checkExit() {
        if (!this.isVisible() && this.m_ExplorerFrame == null && this.m_ExperimenterFrame == null && this.m_KnowledgeFlowFrame == null && this.m_SimpleCLI == null && this.m_ArffViewers.size() == 0 && this.m_SqlViewerFrame == null && this.m_EnsembleLibraryFrame == null && this.m_Plots.size() == 0 && this.m_ROCs.size() == 0 && this.m_TreeVisualizers.size() == 0 && this.m_GraphVisualizers.size() == 0 && this.m_BoundaryVisualizerFrame == null && this.m_SystemInfoFrame == null) {
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        Messages.getInstance();
        Logger.log(Logger.Level.INFO, Messages.getString("GUIChooser_Main_LoggingStarted_Text"));
        LookAndFeel.setLookAndFeel();
        try {
            GUIChooser.createSingleton();
            m_chooser.setVisible(true);
            if (args != null && args.length > 0) {
                m_chooser.showExplorer(args[0]);
            }
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        System.gc();
                        if (!m_Memory.isOutOfMemory()) continue;
                        m_chooser.dispose();
                        if (m_chooser.m_ExperimenterFrame != null) {
                            m_chooser.m_ExperimenterFrame.dispose();
                            m_chooser.m_ExperimenterFrame = null;
                        }
                        if (m_chooser.m_ExplorerFrame != null) {
                            m_chooser.m_ExplorerFrame.dispose();
                            m_chooser.m_ExplorerFrame = null;
                        }
                        if (m_chooser.m_KnowledgeFlowFrame != null) {
                            m_chooser.m_KnowledgeFlowFrame.dispose();
                            m_chooser.m_KnowledgeFlowFrame = null;
                        }
                        if (m_chooser.m_SimpleCLI != null) {
                            m_chooser.m_SimpleCLI.dispose();
                            m_chooser.m_SimpleCLI = null;
                        }
                        if (m_chooser.m_ArffViewers.size() > 0) {
                            int i = 0;
                            while (i < m_chooser.m_ArffViewers.size()) {
                                ArffViewer av = (ArffViewer)m_chooser.m_ArffViewers.get(i);
                                av.dispose();
                                ++i;
                            }
                            m_chooser.m_ArffViewers.clear();
                        }
                        m_chooser = null;
                        System.gc();
                        m_LogWindow.setVisible(true);
                        m_LogWindow.toFront();
                        Messages.getInstance();
                        System.err.println(Messages.getString("GUIChooser_Main_Error_Text_Front"));
                        m_Memory.showOutOfMemory();
                        Messages.getInstance();
                        System.err.println(Messages.getString("GUIChooser_Main_Error_Text_End"));
                        System.exit(-1);
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected GUIChooser m_Parent;

        public ChildFrameSDI(GUIChooser parent, String title) {
            super(title);
            this.m_Parent = parent;
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (ChildFrameSDI.this.getParentFrame() != null) {
                        ChildFrameSDI.this.getParentFrame().createTitle(ChildFrameSDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public GUIChooser getParentFrame() {
            return this.m_Parent;
        }

        @Override
        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }
}

