/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class RemoveWithValuesTest
extends AbstractFilterTest {
    public RemoveWithValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        RemoveWithValues f = new RemoveWithValues();
        f.setAttributeIndex("3");
        f.setInvertSelection(true);
        return f;
    }

    public void testString() {
        Instances icopy = new Instances(this.m_Instances);
        try {
            ((RemoveWithValues)this.m_Filter).setAttributeIndex("1");
            this.m_Filter.setInputFormat(icopy);
            RemoveWithValuesTest.fail("Should have thrown an exception selecting on a STRING attribute!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNominal() {
        ((RemoveWithValues)this.m_Filter).setAttributeIndex("2");
        Instances result = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RemoveWithValuesTest.assertEquals("Default nominal selection matches all values", this.m_Instances.numInstances(), result.numInstances());
        try {
            ((RemoveWithValues)this.m_Filter).setNominalIndices("1-2");
        }
        catch (Exception ex) {
            RemoveWithValuesTest.fail("Shouldn't ever get here unless Range chamges incompatibly");
        }
        result = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RemoveWithValuesTest.assertTrue(this.m_Instances.numInstances() > result.numInstances());
        try {
            ((RemoveWithValues)this.m_Filter).setNominalIndices("3-last");
        }
        catch (Exception ex) {
            RemoveWithValuesTest.fail("Shouldn't ever get here unless Range chamges incompatibly");
        }
        Instances result2 = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result2.numAttributes());
        RemoveWithValuesTest.assertTrue(this.m_Instances.numInstances() > result2.numInstances());
        RemoveWithValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances() + result2.numInstances());
        ((RemoveWithValues)this.m_Filter).setInvertSelection(false);
        result = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RemoveWithValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances() + result2.numInstances());
    }

    public void testNumeric() {
        ((RemoveWithValues)this.m_Filter).setAttributeIndex("3");
        Instances result = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RemoveWithValuesTest.assertEquals("Default split point matches values less than 0", 0, result.numInstances());
        ((RemoveWithValues)this.m_Filter).setSplitPoint(3.0);
        result = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RemoveWithValuesTest.assertTrue(this.m_Instances.numInstances() > result.numInstances());
        ((RemoveWithValues)this.m_Filter).setInvertSelection(false);
        Instances result2 = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result2.numAttributes());
        RemoveWithValuesTest.assertTrue(this.m_Instances.numInstances() > result2.numInstances());
        RemoveWithValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances() + result2.numInstances());
    }

    public void testMatchMissingValues() {
        ((RemoveWithValues)this.m_Filter).setAttributeIndex("5");
        ((RemoveWithValues)this.m_Filter).setInvertSelection(false);
        ((RemoveWithValues)this.m_Filter).setMatchMissingValues(false);
        Instances result = this.useFilter();
        RemoveWithValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RemoveWithValuesTest.assertTrue(result.numInstances() > 0);
        int i = 0;
        while (i < result.numInstances()) {
            RemoveWithValuesTest.assertTrue("Should select only instances with missing values", result.instance(i).isMissing(4));
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
    }

    public static Test suite() {
        return new TestSuite(RemoveWithValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(RemoveWithValuesTest.suite());
    }
}

