/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Wavelet;

public class WaveletTest
extends AbstractFilterTest {
    public WaveletTest(String name) {
        super(name);
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities(this.m_FilteredClassifier.getCapabilities());
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(2);
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (this.m_Instances.classIndex() == i) {
                ++i;
                continue;
            }
            if (!this.m_Instances.attribute(i).isNumeric()) {
                this.m_Instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
    }

    @Override
    public Filter getFilter() {
        return this.getFilter(0, 0);
    }

    protected Filter getFilter(int algorithm, int padding) {
        Wavelet filter = new Wavelet();
        filter.setAlgorithm(new SelectedTag(algorithm, Wavelet.TAGS_ALGORITHM));
        filter.setAlgorithm(new SelectedTag(padding, Wavelet.TAGS_PADDING));
        return filter;
    }

    public void testTypicalHAAR() {
        this.m_Filter = this.getFilter(0, 0);
        Instances icopy = new Instances(this.m_Instances);
        Instances result = this.useFilter();
        WaveletTest.assertEquals(Wavelet.nextPowerOf2(this.m_Instances.numAttributes()) + 1, result.numAttributes());
        WaveletTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        this.m_Instances = new Instances(icopy);
        this.m_Instances.setClassIndex(-1);
        result = this.useFilter();
        WaveletTest.assertEquals(Wavelet.nextPowerOf2(this.m_Instances.numAttributes()), result.numAttributes());
        WaveletTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(WaveletTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(WaveletTest.suite());
    }
}

