/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.AbstractTimeSeriesFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.TimeSeriesDelta;

public class TimeSeriesDeltaTest
extends AbstractTimeSeriesFilterTest {
    public TimeSeriesDeltaTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("3");
    }

    public Filter getFilter(String rangelist) {
        TimeSeriesDelta af = new TimeSeriesDelta();
        af.setAttributeIndices(rangelist);
        af.setFillWithMissing(false);
        return af;
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("1,2,3,4,5,6");
        ((TimeSeriesDelta)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        TimeSeriesDeltaTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        TimeSeriesDeltaTest.assertEquals(this.m_Instances.numInstances() - 1, result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            Instance in = this.m_Instances.instance(i + 1);
            Instance out = result.instance(i);
            int j = 0;
            while (j < result.numAttributes()) {
                if (j != 4 && j != 5 && j != 6) {
                    if (in.isMissing(j)) {
                        TimeSeriesDeltaTest.assertTrue("Nonselected missing values should pass through", out.isMissing(j));
                    } else if (result.attribute(j).isString()) {
                        TimeSeriesDeltaTest.assertEquals("Nonselected attributes shouldn't change. " + in + " --> " + out, this.m_Instances.attribute(j).value((int)in.value(j)), result.attribute(j).value((int)out.value(j)));
                    } else {
                        TimeSeriesDeltaTest.assertEquals("Nonselected attributes shouldn't change. " + in + " --> " + out, in.value(j), out.value(j), 0.001);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(TimeSeriesDeltaTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(TimeSeriesDeltaTest.suite());
    }
}

