/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class ReplaceMissingValuesTest
extends AbstractFilterTest {
    public ReplaceMissingValuesTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new ReplaceMissingValues();
    }

    public void testTypical() {
        Instances result = this.useFilter();
        ReplaceMissingValuesTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ReplaceMissingValuesTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int j = 0;
        while (j < this.m_Instances.numAttributes()) {
            Attribute inatt = this.m_Instances.attribute(j);
            Attribute outatt = result.attribute(j);
            int i = 0;
            while (i < this.m_Instances.numInstances()) {
                if (this.m_Instances.attribute(j).isString()) {
                    if (this.m_Instances.instance(i).isMissing(j)) {
                        ReplaceMissingValuesTest.assertTrue("Missing values in strings cannot be replaced", result.instance(i).isMissing(j));
                    } else {
                        ReplaceMissingValuesTest.assertEquals("String values should not have changed", inatt.value((int)this.m_Instances.instance(i).value(j)), outatt.value((int)result.instance(i).value(j)));
                    }
                } else {
                    ReplaceMissingValuesTest.assertTrue("All non-string missing values should have been replaced", !result.instance(i).isMissing(j));
                }
                ++i;
            }
            ++j;
        }
    }

    public static Test suite() {
        return new TestSuite(ReplaceMissingValuesTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ReplaceMissingValuesTest.suite());
    }
}

