/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RELAGGS;

public class RELAGGSTest
extends AbstractFilterTest {
    public RELAGGSTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestInstances test = new TestInstances();
        test.setNumDate(1);
        test.setNumNominal(1);
        test.setNumNominalValues(10);
        test.setNumNumeric(1);
        test.setNumRelational(2);
        test.setNumString(0);
        test.setNumRelationalDate(2);
        test.setNumRelationalNominal(2);
        test.setNumRelationalNumeric(2);
        test.setNumRelationalString(0);
        test.setNumRelationalNominalValues(10);
        this.m_Instances = test.generate();
    }

    @Override
    public Filter getFilter() {
        return new RELAGGS();
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        return this.m_Instances;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        Instances result = this.useFilter();
        RELAGGSTest.assertEquals(this.m_Instances.numAttributes() + 78, result.numAttributes());
        RELAGGSTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public void testMaxCardinality() {
        this.m_Filter = this.getFilter();
        ((RELAGGS)this.m_Filter).setMaxCardinality(5);
        Instances result = this.useFilter();
        RELAGGSTest.assertEquals(this.m_Instances.numAttributes() + 38, result.numAttributes());
        RELAGGSTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public void testNoRelationalAttribute() {
        this.m_Filter = this.getFilter();
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (this.m_Instances.attribute(i).isRelationValued()) {
                this.m_Instances.deleteAttributeAt(i);
                continue;
            }
            ++i;
        }
        Instances result = this.useFilter();
        RELAGGSTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        RELAGGSTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(RELAGGSTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(RELAGGSTest.suite());
    }
}

