/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Attribute;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Obfuscate;

public class ObfuscateTest
extends AbstractFilterTest {
    public ObfuscateTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new Obfuscate();
    }

    public void testTypical() {
        Instances result = this.useFilter();
        ObfuscateTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ObfuscateTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        ObfuscateTest.assertTrue(!this.m_Instances.relationName().equals(result.relationName()));
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            Attribute inatt = this.m_Instances.attribute(i);
            Attribute outatt = result.attribute(i);
            if (!inatt.isString() && !inatt.isDate()) {
                ObfuscateTest.assertTrue("Attribute names should be changed", !inatt.name().equals(outatt.name()));
                if (inatt.isNominal()) {
                    ObfuscateTest.assertEquals("Number of nominal values shouldn't change", inatt.numValues(), outatt.numValues());
                    int j = 0;
                    while (j < inatt.numValues()) {
                        ObfuscateTest.assertTrue("Nominal labels should be changed", !inatt.value(j).equals(outatt.value(j)));
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(ObfuscateTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ObfuscateTest.suite());
    }
}

