/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NumericTransform;

public class NumericTransformTest
extends AbstractFilterTest {
    private static final double TOLERANCE = 0.001;

    public NumericTransformTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter("first-last");
    }

    public Filter getFilter(String rangelist) {
        try {
            NumericTransform af = new NumericTransform();
            af.setAttributeIndices(rangelist);
            return af;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            NumericTransformTest.fail("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage());
            return null;
        }
    }

    public void testDefault() {
        Instances result = this.useFilter();
        NumericTransformTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        NumericTransformTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            int j = 0;
            while (j < result.numAttributes()) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericTransformTest.assertTrue(result.instance(i).isMissing(j));
                } else if (result.attribute(j).isNumeric()) {
                    NumericTransformTest.assertEquals("Value should be same as Math.abs()", Math.abs(this.m_Instances.instance(i).value(j)), result.instance(i).value(j), 0.001);
                } else {
                    NumericTransformTest.assertEquals("Value shouldn't have changed", this.m_Instances.instance(i).value(j), result.instance(i).value(j), 0.001);
                }
                ++j;
            }
            ++i;
        }
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("1-3");
        ((NumericTransform)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        NumericTransformTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        NumericTransformTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            int j = 0;
            while (j < result.numAttributes()) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericTransformTest.assertTrue(result.instance(i).isMissing(j));
                } else if (result.attribute(j).isNumeric() && j >= 3) {
                    NumericTransformTest.assertEquals("Value should be same as Math.abs()", Math.abs(this.m_Instances.instance(i).value(j)), result.instance(i).value(j), 0.001);
                } else {
                    NumericTransformTest.assertEquals("Value shouldn't have changed", this.m_Instances.instance(i).value(j), result.instance(i).value(j), 0.001);
                }
                ++j;
            }
            ++i;
        }
    }

    public void testClassNameAndMethodName() throws Exception {
        ((NumericTransform)this.m_Filter).setClassName("java.lang.Math");
        ((NumericTransform)this.m_Filter).setMethodName("rint");
        Instances result = this.useFilter();
        NumericTransformTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        NumericTransformTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        int i = 0;
        while (i < result.numInstances()) {
            int j = 0;
            while (j < result.numAttributes()) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericTransformTest.assertTrue(result.instance(i).isMissing(j));
                } else if (result.attribute(j).isNumeric()) {
                    NumericTransformTest.assertEquals("Value should be same as Math.rint()", Math.rint(this.m_Instances.instance(i).value(j)), result.instance(i).value(j), 0.001);
                } else {
                    NumericTransformTest.assertEquals("Value shouldn't have changed", this.m_Instances.instance(i).value(j), result.instance(i).value(j), 0.001);
                }
                ++j;
            }
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(NumericTransformTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(NumericTransformTest.suite());
    }
}

