/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToString;

public class NominalToStringTest
extends AbstractFilterTest {
    public NominalToStringTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        NominalToString f = new NominalToString();
        f.setAttributeIndexes("2");
        return f;
    }

    @Override
    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = super.getFilteredClassifier();
        ((NominalToString)result.getFilter()).setAttributeIndexes("1");
        result.setClassifier(new ZeroR());
        return result;
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities(this.m_FilteredClassifier.getCapabilities());
        test.setNumRelational(0);
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        NominalToStringTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        NominalToStringTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        NominalToStringTest.assertEquals("Attribute type should now be STRING", 2, result.attribute(1).type());
        NominalToStringTest.assertEquals(4, result.attribute(1).numValues());
    }

    public void testMissing() {
        ((NominalToString)this.m_Filter).setAttributeIndexes("5");
        Instances result = this.useFilter();
        NominalToStringTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        NominalToStringTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        NominalToStringTest.assertEquals("Attribute type should now be STRING", 2, result.attribute(4).type());
        NominalToStringTest.assertEquals(5, result.attribute(4).numValues());
        int i = 0;
        while (i < result.numInstances()) {
            NominalToStringTest.assertTrue("Missing values should be preserved", this.m_Instances.instance(i).isMissing(4) == result.instance(i).isMissing(4));
            ++i;
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isNominal()) {
                    ((NominalToString)this.m_FilteredClassifier.getFilter()).setAttributeIndexes("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            NominalToStringTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(NominalToStringTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(NominalToStringTest.suite());
    }
}

