/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.core.Instances;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MultiInstanceToPropositional;

public class MultiInstanceToPropositionalTest
extends AbstractFilterTest {
    public MultiInstanceToPropositionalTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new MultiInstanceToPropositional();
    }

    @Override
    protected FilteredClassifier getFilteredClassifier() {
        FilteredClassifier result = new FilteredClassifier();
        result.setFilter(this.getFilter());
        result.setClassifier(new ZeroR());
        return result;
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = TestInstances.forCapabilities(this.m_FilteredClassifier.getCapabilities());
        test.setClassIndex(-1);
        Instances result = test.generate();
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestInstances test = new TestInstances();
        test.setNumNominal(1);
        test.setClassType(1);
        test.setMultiInstance(true);
        this.m_Instances = test.generate();
    }

    public void testTypical() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = this.useFilter();
        int count = 0;
        int i = 0;
        while (i < icopy.numInstances()) {
            count += icopy.instance(i).relationalValue(1).numInstances();
            ++i;
        }
        MultiInstanceToPropositionalTest.assertEquals(result.numInstances(), count);
        count = icopy.numAttributes() + icopy.attribute(1).relation().numAttributes() - 1;
        MultiInstanceToPropositionalTest.assertEquals(result.numAttributes(), count);
    }

    @Override
    public void testFilteredClassifier() {
    }

    public static Test suite() {
        return new TestSuite(MultiInstanceToPropositionalTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(MultiInstanceToPropositionalTest.suite());
    }
}

