/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.InstanceComparator;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ChangeDateFormat;

public class ChangeDateFormatTest
extends AbstractFilterTest {
    protected InstanceComparator m_Comparator;

    public ChangeDateFormatTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
        this.m_Comparator = new InstanceComparator(true);
    }

    @Override
    public Filter getFilter() {
        ChangeDateFormat f = new ChangeDateFormat();
        return f;
    }

    public void testTypical() {
        this.m_Filter = this.getFilter();
        ((ChangeDateFormat)this.m_Filter).setDateFormat("yyyy-MM");
        Instances result = this.useFilter();
        ChangeDateFormatTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ChangeDateFormatTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        boolean equal = false;
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && this.m_Comparator.compare(this.m_Instances.instance(i), result.instance(i)) == 0) {
                equal = true;
                break;
            }
            ++i;
        }
        if (equal) {
            ChangeDateFormatTest.fail("Instances not changed!");
        }
    }

    public void testSameFormat() {
        this.m_Filter = this.getFilter();
        ((ChangeDateFormat)this.m_Filter).setDateFormat("yyyy-MM-dd");
        Instances result = this.useFilter();
        ChangeDateFormatTest.assertEquals(this.m_Instances.numAttributes(), result.numAttributes());
        ChangeDateFormatTest.assertEquals(this.m_Instances.numInstances(), result.numInstances());
        boolean equal = true;
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            if (!(this.m_Instances.instance(i) instanceof SparseInstance) && this.m_Comparator.compare(this.m_Instances.instance(i), result.instance(i)) != 0) {
                equal = false;
                break;
            }
            ++i;
        }
        if (!equal) {
            ChangeDateFormatTest.fail("Instances modified!");
        }
    }

    @Override
    public void testFilteredClassifier() {
        try {
            Instances data = this.getFilteredClassifierData();
            int i = 0;
            while (i < data.numAttributes()) {
                if (data.classIndex() != i && data.attribute(i).isDate()) {
                    ((ChangeDateFormat)this.m_FilteredClassifier.getFilter()).setAttributeIndex("" + (i + 1));
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ChangeDateFormatTest.fail("Problem setting up test for FilteredClassifier: " + e.toString());
        }
        super.testFilteredClassifier();
    }

    public static Test suite() {
        return new TestSuite(ChangeDateFormatTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ChangeDateFormatTest.suite());
    }
}

