/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddID;

public class AddIDTest
extends AbstractFilterTest {
    public AddIDTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return new AddID();
    }

    public Filter getFilter(int pos) {
        AddID af = new AddID();
        af.setIDIndex("" + (pos + 1));
        return af;
    }

    protected void performTest() {
        Instances icopy = new Instances(this.m_Instances);
        Instances result = null;
        try {
            this.m_Filter.setInputFormat(icopy);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddIDTest.fail("Exception thrown on setInputFormat(): \n" + ex.getMessage());
        }
        try {
            result = Filter.useFilter(icopy, this.m_Filter);
            AddIDTest.assertNotNull(result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AddIDTest.fail("Exception thrown on useFilter(): \n" + ex.getMessage());
        }
        AddIDTest.assertEquals(icopy.numAttributes() + 1, result.numAttributes());
        AddIDTest.assertEquals(icopy.numInstances(), this.m_Instances.numInstances());
    }

    public void testAddFirst() {
        this.m_Filter = this.getFilter(0);
        this.testBuffered();
        this.performTest();
    }

    public void testAddLast() {
        this.m_Filter = this.getFilter(this.m_Instances.numAttributes() - 1);
        this.testBuffered();
        this.performTest();
    }

    public static Test suite() {
        return new TestSuite(AddIDTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(AddIDTest.suite());
    }
}

