/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.core.SelectedTag;
import weka.core.TestInstances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.PLSFilter;

public class PLSFilterTest
extends AbstractFilterTest {
    protected static final int NUM_ATTS = 5;
    protected static final int NUM_NUMERIC_ATTS = 20;

    public PLSFilterTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        return this.getFilter(5, 2);
    }

    public Filter getFilter(int numAtts, int algorithm) {
        PLSFilter filter = new PLSFilter();
        filter.setNumComponents(numAtts);
        filter.setReplaceMissing(true);
        filter.setPreprocessing(new SelectedTag(1, PLSFilter.TAGS_PREPROCESSING));
        filter.setAlgorithm(new SelectedTag(algorithm, PLSFilter.TAGS_ALGORITHM));
        return filter;
    }

    @Override
    protected Instances getFilteredClassifierData() throws Exception {
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        Instances result = test.generate();
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestInstances test = new TestInstances();
        test.setNumNominal(0);
        test.setNumNumeric(20);
        test.setClassType(0);
        this.m_Instances = test.generate();
    }

    protected void performTest(int algorithm) {
        Instances icopy = new Instances(this.m_Instances);
        this.m_Filter = this.getFilter(5, algorithm);
        Instances result = this.useFilter();
        PLSFilterTest.assertEquals(result.numAttributes(), 6);
        PLSFilterTest.assertEquals(result.numInstances(), icopy.numInstances());
        this.m_Filter = this.getFilter(10, algorithm);
        result = this.useFilter();
        PLSFilterTest.assertEquals(result.numAttributes(), 11);
        PLSFilterTest.assertEquals(result.numInstances(), icopy.numInstances());
    }

    public void testPLS1() {
        this.performTest(2);
    }

    public void testSIMPLS() {
        this.performTest(1);
    }

    public static Test suite() {
        return new TestSuite(PLSFilterTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(PLSFilterTest.suite());
    }
}

