/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;
import weka.datagenerators.Test;

public class RDG1
extends ClassificationGenerator {
    static final long serialVersionUID = 7751005204635320414L;
    protected int m_NumAttributes;
    protected int m_NumClasses;
    private int m_MaxRuleSize;
    private int m_MinRuleSize;
    private int m_NumIrrelevant;
    private int m_NumNumeric;
    private boolean m_VoteFlag = false;
    private FastVector m_DecisionList = null;
    boolean[] m_AttList_Irr;

    public RDG1() {
        this.setNumAttributes(this.defaultNumAttributes());
        this.setNumClasses(this.defaultNumClasses());
        this.setMaxRuleSize(this.defaultMaxRuleSize());
        this.setMinRuleSize(this.defaultMinRuleSize());
        this.setNumIrrelevant(this.defaultNumIrrelevant());
        this.setNumNumeric(this.defaultNumNumeric());
    }

    public String globalInfo() {
        return "A data generator that produces data randomly by producing a decision list.\nThe decision list consists of rules.\nInstances are generated randomly one by one. If decision list fails to classify the current instance, a new rule according to this current instance is generated and added to the decision list.\n\nThe option -V switches on voting, which means that at the end of the generation all instances are reclassified to the class value that is supported by the most rules.\n\nThis data generator can generate 'boolean' attributes (= nominal with the values {true, false}) and numeric attributes. The rules can be 'A' or 'NOT A' for boolean values and 'B < random_value' or 'B >= random_value' for numeric values.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe number of attributes (default " + this.defaultNumAttributes() + ").", "a", 1, "-a <num>"));
        result.addElement(new Option("\tThe number of classes (default " + this.defaultNumClasses() + ")", "c", 1, "-c <num>"));
        result.addElement(new Option("\tmaximum size for rules (default " + this.defaultMaxRuleSize() + ") ", "R", 1, "-R <num>"));
        result.addElement(new Option("\tminimum size for rules (default " + this.defaultMinRuleSize() + ") ", "M", 1, "-M <num>"));
        result.addElement(new Option("\tnumber of irrelevant attributes (default " + this.defaultNumIrrelevant() + ")", "I", 1, "-I <num>"));
        result.addElement(new Option("\tnumber of numeric attributes (default " + this.defaultNumNumeric() + ")", "N", 1, "-N"));
        result.addElement(new Option("\tswitch on voting (default is no voting)", "V", 1, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('a', options);
        if (tmpStr.length() != 0) {
            this.setNumAttributes(Integer.parseInt(tmpStr));
        } else {
            this.setNumAttributes(this.defaultNumAttributes());
        }
        tmpStr = Utils.getOption('c', options);
        if (tmpStr.length() != 0) {
            this.setNumClasses(Integer.parseInt(tmpStr));
        } else {
            this.setNumClasses(this.defaultNumClasses());
        }
        tmpStr = Utils.getOption('R', options);
        if (tmpStr.length() != 0) {
            this.setMaxRuleSize(Integer.parseInt(tmpStr));
        } else {
            this.setMaxRuleSize(this.defaultMaxRuleSize());
        }
        tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMinRuleSize(Integer.parseInt(tmpStr));
        } else {
            this.setMinRuleSize(this.defaultMinRuleSize());
        }
        tmpStr = Utils.getOption('I', options);
        if (tmpStr.length() != 0) {
            this.setNumIrrelevant(Integer.parseInt(tmpStr));
        } else {
            this.setNumIrrelevant(this.defaultNumIrrelevant());
        }
        if (this.getNumAttributes() - this.getNumIrrelevant() < this.getMinRuleSize()) {
            throw new Exception("Possible rule size is below minimal rule size.");
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumNumeric(Integer.parseInt(tmpStr));
        } else {
            this.setNumNumeric(this.defaultNumNumeric());
        }
        this.setVoteFlag(Utils.getFlag('V', options));
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-a");
        result.add("" + this.getNumAttributes());
        result.add("-c");
        result.add("" + this.getNumClasses());
        result.add("-N");
        result.add("" + this.getNumNumeric());
        result.add("-I");
        result.add("" + this.getNumIrrelevant());
        result.add("-M");
        result.add("" + this.getMinRuleSize());
        result.add("-R");
        result.add("" + this.getMaxRuleSize());
        if (this.getVoteFlag()) {
            result.add("-V");
        }
        return result.toArray(new String[result.size()]);
    }

    protected int defaultNumAttributes() {
        return 10;
    }

    public void setNumAttributes(int numAttributes) {
        this.m_NumAttributes = numAttributes;
    }

    public int getNumAttributes() {
        return this.m_NumAttributes;
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain.";
    }

    protected int defaultNumClasses() {
        return 2;
    }

    public void setNumClasses(int numClasses) {
        this.m_NumClasses = numClasses;
    }

    public int getNumClasses() {
        return this.m_NumClasses;
    }

    public String numClassesTipText() {
        return "The number of classes to generate.";
    }

    protected int defaultMaxRuleSize() {
        return 10;
    }

    public int getMaxRuleSize() {
        return this.m_MaxRuleSize;
    }

    public void setMaxRuleSize(int newMaxRuleSize) {
        this.m_MaxRuleSize = newMaxRuleSize;
    }

    public String maxRuleSizeTipText() {
        return "The maximum number of tests in rules.";
    }

    protected int defaultMinRuleSize() {
        return 1;
    }

    public int getMinRuleSize() {
        return this.m_MinRuleSize;
    }

    public void setMinRuleSize(int newMinRuleSize) {
        this.m_MinRuleSize = newMinRuleSize;
    }

    public String minRuleSizeTipText() {
        return "The minimum number of tests in rules.";
    }

    protected int defaultNumIrrelevant() {
        return 0;
    }

    public int getNumIrrelevant() {
        return this.m_NumIrrelevant;
    }

    public void setNumIrrelevant(int newNumIrrelevant) {
        this.m_NumIrrelevant = newNumIrrelevant;
    }

    public String numIrrelevantTipText() {
        return "The number of irrelevant attributes.";
    }

    protected int defaultNumNumeric() {
        return 0;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumNumeric(int newNumNumeric) {
        this.m_NumNumeric = newNumNumeric;
    }

    public String numNumericTipText() {
        return "The number of numerical attributes.";
    }

    public boolean getVoteFlag() {
        return this.m_VoteFlag;
    }

    public void setVoteFlag(boolean newVoteFlag) {
        this.m_VoteFlag = newVoteFlag;
    }

    public String voteFlagTipText() {
        return "Whether to use voting or not.";
    }

    @Override
    public boolean getSingleModeFlag() {
        return !this.getVoteFlag();
    }

    public boolean[] getAttList_Irr() {
        return this.m_AttList_Irr;
    }

    public void setAttList_Irr(boolean[] newAttList_Irr) {
        this.m_AttList_Irr = newAttList_Irr;
    }

    public String attList_IrrTipText() {
        return "The array with the indices of the irrelevant attributes.";
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        this.m_DecisionList = new FastVector();
        this.setNumExamplesAct(this.getNumExamples());
        Instances dataset = this.defineDataset(random);
        return dataset;
    }

    @Override
    public Instance generateExample() throws Exception {
        Random random = this.getRandom();
        Instances format = this.getDatasetFormat();
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        if (this.getVoteFlag()) {
            throw new Exception("Examples cannot be generated one by one.");
        }
        format = this.generateExamples(1, random, format);
        return format.lastInstance();
    }

    @Override
    public Instances generateExamples() throws Exception {
        Random random = this.getRandom();
        Instances format = this.getDatasetFormat();
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        format = this.generateExamples(this.getNumExamplesAct(), random, format);
        if (this.getVoteFlag()) {
            format = this.voteDataset(format);
        }
        return format;
    }

    public Instances generateExamples(int num, Random random, Instances format) throws Exception {
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        int i = 0;
        while (i < num) {
            Instance example = this.generateExample(random, format);
            boolean classDefined = this.classifyExample(example);
            if (!classDefined) {
                example = this.updateDecisionList(random, example);
            }
            example.setDataset(format);
            format.add(example);
            ++i;
        }
        return format;
    }

    private Instance updateDecisionList(Random random, Instance example) throws Exception {
        Instances format = this.getDatasetFormat();
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        FastVector TestList = this.generateTestList(random, example);
        int maxSize = this.getMaxRuleSize() < TestList.size() ? this.getMaxRuleSize() : TestList.size();
        int ruleSize = (int)(random.nextDouble() * (double)(maxSize - this.getMinRuleSize())) + this.getMinRuleSize();
        RuleList newRule = new RuleList();
        int i = 0;
        while (i < ruleSize) {
            int testIndex = (int)(random.nextDouble() * (double)TestList.size());
            Test test = (Test)TestList.elementAt(testIndex);
            newRule.addTest(test);
            TestList.removeElementAt(testIndex);
            ++i;
        }
        double newClassValue = 0.0;
        if (this.m_DecisionList.size() > 0) {
            RuleList r = (RuleList)this.m_DecisionList.lastElement();
            double oldClassValue = r.getClassValue();
            newClassValue = (double)((int)oldClassValue + 1) % (double)this.getNumClasses();
        }
        newRule.setClassValue(newClassValue);
        this.m_DecisionList.addElement(newRule);
        example = (Instance)example.copy();
        example.setDataset(format);
        example.setClassValue(newClassValue);
        return example;
    }

    private FastVector generateTestList(Random random, Instance example) throws Exception {
        Instances format = this.getDatasetFormat();
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        int numTests = this.getNumAttributes() - this.getNumIrrelevant();
        FastVector TestList = new FastVector(numTests);
        boolean[] irrelevant = this.getAttList_Irr();
        int i = 0;
        while (i < this.getNumAttributes()) {
            if (!irrelevant[i]) {
                Test newTest = null;
                Attribute att = example.attribute(i);
                if (att.isNumeric()) {
                    double newSplit = random.nextDouble();
                    boolean newNot = newSplit < example.value(i);
                    newTest = new Test(i, newSplit, format, newNot);
                } else {
                    newTest = new Test(i, example.value(i), format, false);
                }
                TestList.addElement(newTest);
            }
            ++i;
        }
        return TestList;
    }

    private Instance generateExample(Random random, Instances format) throws Exception {
        double[] attributes = new double[this.getNumAttributes() + 1];
        int i = 0;
        while (i < this.getNumAttributes()) {
            double value = random.nextDouble();
            if (format.attribute(i).isNumeric()) {
                attributes[i] = value;
            } else if (format.attribute(i).isNominal()) {
                attributes[i] = value > 0.5 ? 1.0 : 0.0;
            } else {
                throw new Exception("Attribute type is not supported.");
            }
            ++i;
        }
        Instance example = new Instance(1.0, attributes);
        example.setDataset(format);
        example.setClassMissing();
        return example;
    }

    private boolean classifyExample(Instance example) throws Exception {
        double classValue = -1.0;
        Enumeration e = this.m_DecisionList.elements();
        while (e.hasMoreElements() && classValue < 0.0) {
            RuleList rl = (RuleList)e.nextElement();
            classValue = rl.classifyInstance(example);
        }
        if (classValue >= 0.0) {
            example.setClassValue(classValue);
            return true;
        }
        return false;
    }

    private Instance votedReclassifyExample(Instance example) throws Exception {
        int[] classVotes = new int[this.getNumClasses()];
        int i = 0;
        while (i < classVotes.length) {
            classVotes[i] = 0;
            ++i;
        }
        Enumeration e = this.m_DecisionList.elements();
        while (e.hasMoreElements()) {
            RuleList rl = (RuleList)e.nextElement();
            int classValue = (int)rl.classifyInstance(example);
            if (classValue < 0) continue;
            int n = classValue;
            classVotes[n] = classVotes[n] + 1;
        }
        int maxVote = 0;
        int vote = -1;
        int i2 = 0;
        while (i2 < classVotes.length) {
            if (classVotes[i2] > maxVote) {
                maxVote = classVotes[i2];
                vote = i2;
            }
            ++i2;
        }
        if (vote < 0) {
            throw new Exception("Error in instance classification.");
        }
        example.setClassValue(vote);
        return example;
    }

    private Instances defineDataset(Random random) throws Exception {
        Attribute attribute;
        FastVector attributes = new FastVector();
        FastVector nominalValues = new FastVector(2);
        nominalValues.addElement("false");
        nominalValues.addElement("true");
        FastVector classValues = new FastVector(this.getNumClasses());
        boolean[] attList_Irr = this.defineIrrelevant(random);
        this.setAttList_Irr(attList_Irr);
        int[] attList_Num = this.defineNumeric(random);
        int i = 0;
        while (i < this.getNumAttributes()) {
            attribute = attList_Num[i] == 0 ? new Attribute("a" + i) : new Attribute("a" + i, nominalValues);
            attributes.addElement(attribute);
            ++i;
        }
        i = 0;
        while (i < classValues.capacity()) {
            classValues.addElement("c" + i);
            ++i;
        }
        attribute = new Attribute("class", classValues);
        attributes.addElement(attribute);
        Instances dataset = new Instances(this.getRelationNameToUse(), attributes, this.getNumExamplesAct());
        dataset.setClassIndex(this.getNumAttributes());
        Instances format = new Instances(dataset, 0);
        this.setDatasetFormat(format);
        return dataset;
    }

    private boolean[] defineIrrelevant(Random random) {
        boolean[] irr = new boolean[this.getNumAttributes()];
        int i = 0;
        while (i < irr.length) {
            irr[i] = false;
            ++i;
        }
        int numIrr = 0;
        int i2 = 0;
        while (numIrr < this.getNumIrrelevant() && i2 < this.getNumAttributes() * 5) {
            int maybeNext = (int)(random.nextDouble() * (double)irr.length);
            if (!irr[maybeNext]) {
                irr[maybeNext] = true;
                ++numIrr;
            }
            ++i2;
        }
        return irr;
    }

    private int[] defineNumeric(Random random) {
        int[] num = new int[this.getNumAttributes()];
        int i = 0;
        while (i < num.length) {
            num[i] = 1;
            ++i;
        }
        int numNum = 0;
        int i2 = 0;
        while (numNum < this.getNumNumeric() && i2 < this.getNumAttributes() * 5) {
            int maybeNext = (int)(random.nextDouble() * (double)num.length);
            if (num[maybeNext] != 0) {
                num[maybeNext] = 0;
                ++numNum;
            }
            ++i2;
        }
        return num;
    }

    @Override
    public String generateStart() {
        return "";
    }

    @Override
    public String generateFinished() throws Exception {
        StringBuffer dLString = new StringBuffer();
        boolean[] attList_Irr = this.getAttList_Irr();
        Instances format = this.getDatasetFormat();
        dLString.append("%\n% Number of attributes chosen as irrelevant = " + this.getNumIrrelevant() + "\n");
        int i = 0;
        while (i < attList_Irr.length) {
            if (attList_Irr[i]) {
                dLString.append("% " + format.attribute(i).name() + "\n");
            }
            ++i;
        }
        dLString.append("%\n% DECISIONLIST (number of rules = " + this.m_DecisionList.size() + "):\n");
        i = 0;
        while (i < this.m_DecisionList.size()) {
            RuleList rl = (RuleList)this.m_DecisionList.elementAt(i);
            dLString.append("% RULE " + i + ": " + rl.toString() + "\n");
            ++i;
        }
        return dLString.toString();
    }

    private Instances voteDataset(Instances dataset) throws Exception {
        int i = 0;
        while (i < dataset.numInstances()) {
            Instance inst = dataset.firstInstance();
            inst = this.votedReclassifyExample(inst);
            dataset.add(inst);
            dataset.delete(0);
            ++i;
        }
        return dataset;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5674 $");
    }

    public static void main(String[] args) {
        RDG1.runDataGenerator(new RDG1(), args);
    }

    private class RuleList
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 2830125413361938177L;
        private FastVector m_RuleList = null;
        double m_ClassValue = 0.0;

        private RuleList() {
        }

        public double getClassValue() {
            return this.m_ClassValue;
        }

        public void setClassValue(double newClassValue) {
            this.m_ClassValue = newClassValue;
        }

        private void addTest(Test newTest) {
            if (this.m_RuleList == null) {
                this.m_RuleList = new FastVector();
            }
            this.m_RuleList.addElement(newTest);
        }

        private double classifyInstance(Instance example) throws Exception {
            boolean passedAllTests = true;
            Enumeration e = this.m_RuleList.elements();
            while (passedAllTests && e.hasMoreElements()) {
                Test test = (Test)e.nextElement();
                passedAllTests = test.passesTest(example);
            }
            if (passedAllTests) {
                return this.m_ClassValue;
            }
            return -1.0;
        }

        public String toString() {
            Test test;
            StringBuffer str = new StringBuffer();
            str = str.append("  c" + (int)this.m_ClassValue + " := ");
            Enumeration e = this.m_RuleList.elements();
            if (e.hasMoreElements()) {
                test = (Test)e.nextElement();
                str = str.append(test.toPrologString());
            }
            while (e.hasMoreElements()) {
                test = (Test)e.nextElement();
                str = str.append(", " + test.toPrologString());
            }
            return str.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5674 $");
        }
    }
}

