/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;

public class LED24
extends ClassificationGenerator
implements TechnicalInformationHandler {
    static final long serialVersionUID = -7880209100415868737L;
    protected double m_NoisePercent;
    protected static final int[][] m_originalInstances;
    protected int m_numIrrelevantAttributes = 17;

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[7];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[7];
        nArray2[2] = 1;
        nArray2[5] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[0] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[6] = 1;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[0] = 1;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[7];
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[5] = 1;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[3] = 1;
        nArray6[5] = 1;
        nArray6[6] = 1;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[0] = 1;
        nArray7[1] = 1;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArray7[5] = 1;
        nArray7[6] = 1;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[0] = 1;
        nArray8[2] = 1;
        nArray8[5] = 1;
        nArrayArray[7] = nArray8;
        nArrayArray[8] = new int[]{1, 1, 1, 1, 1, 1, 1};
        int[] nArray9 = new int[7];
        nArray9[0] = 1;
        nArray9[1] = 1;
        nArray9[2] = 1;
        nArray9[3] = 1;
        nArray9[5] = 1;
        nArray9[6] = 1;
        nArrayArray[9] = nArray9;
        m_originalInstances = nArrayArray;
    }

    public LED24() {
        this.setNoisePercent(this.defaultNoisePercent());
    }

    public String globalInfo() {
        return "This generator produces data for a display with 7 LEDs. The original output consists of 10 concepts and 7 boolean attributes. Here, in addition to the 7 necessary boolean attributes, 17 other, irrelevant boolean attributes with random values are added to make it harder. By default 10 percent of noise are added to the data.\n\nMore information can be found here:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INBOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "L. Breiman J.H. Friedman R.A. Olshen and C.J. Stone");
        result.setValue(TechnicalInformation.Field.YEAR, "1984");
        result.setValue(TechnicalInformation.Field.TITLE, "Classification and Regression Trees");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Wadsworth International Group");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Belmont, California");
        result.setValue(TechnicalInformation.Field.PAGES, "43-49");
        result.setValue(TechnicalInformation.Field.ISBN, "0412048418");
        result.setValue(TechnicalInformation.Field.URL, "http://www.ics.uci.edu/~mlearn/databases/led-display-creator/");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.add(new Option("\tThe noise percentage. (default " + this.defaultNoisePercent() + ")", "N", 1, "-N <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNoisePercent(Double.parseDouble(tmpStr));
        } else {
            this.setNoisePercent(this.defaultNoisePercent());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-N");
        result.add("" + this.getNoisePercent());
        return result.toArray(new String[result.size()]);
    }

    protected double defaultNoisePercent() {
        return 10.0;
    }

    public double getNoisePercent() {
        return this.m_NoisePercent;
    }

    public void setNoisePercent(double value) {
        if (!(value >= 0.0) || !(value <= 100.0)) {
            throw new IllegalArgumentException("Noise percent must be in [0,100] (provided: " + value + ")!");
        }
        this.m_NoisePercent = value;
    }

    public String noisePercentTipText() {
        return "The noise percent: 0 <= perc <= 100.";
    }

    @Override
    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        int i;
        FastVector attValues;
        this.m_Random = new Random(this.getSeed());
        this.setNumExamplesAct(this.getNumExamples());
        FastVector atts = new FastVector();
        int n = 1;
        while (n <= 24) {
            attValues = new FastVector();
            i = 0;
            while (i < 2) {
                attValues.addElement("" + i);
                ++i;
            }
            atts.addElement(new Attribute("att" + n, attValues));
            ++n;
        }
        attValues = new FastVector();
        i = 0;
        while (i < 10) {
            attValues.addElement("" + i);
            ++i;
        }
        atts.addElement(new Attribute("class", attValues));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), atts, 0);
        return this.m_DatasetFormat;
    }

    @Override
    public Instance generateExample() throws Exception {
        Instance result = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double[] atts = new double[this.m_DatasetFormat.numAttributes()];
        int selected = random.nextInt(10);
        int i = 0;
        while (i < 7) {
            atts[i] = (double)(1 + random.nextInt(100)) <= this.getNoisePercent() ? (double)(m_originalInstances[selected][i] == 0 ? 1 : 0) : (double)m_originalInstances[selected][i];
            ++i;
        }
        i = 0;
        while (i < this.m_numIrrelevantAttributes) {
            atts[i + 7] = random.nextInt(2);
            ++i;
        }
        atts[atts.length - 1] = selected;
        result = new Instance(1.0, atts);
        result.setDataset(this.m_DatasetFormat);
        return result;
    }

    @Override
    public Instances generateExamples() throws Exception {
        Instances result = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        int i = 0;
        while (i < this.getNumExamplesAct()) {
            result.add(this.generateExample());
            ++i;
        }
        return result;
    }

    @Override
    public String generateStart() {
        return "";
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    public static void main(String[] args) {
        LED24.runDataGenerator(new LED24(), args);
    }
}

