/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class DataGenerator
implements OptionHandler,
Randomizable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3698585946221802578L;
    protected boolean m_Debug = false;
    protected Instances m_DatasetFormat = null;
    protected String m_RelationName = "";
    protected int m_NumExamplesAct;
    protected transient PrintWriter m_DefaultOutput;
    protected transient PrintWriter m_Output = this.m_DefaultOutput = new PrintWriter(new OutputStreamWriter(System.out));
    protected int m_Seed;
    protected Random m_Random = null;
    protected boolean m_CreatingRelationName = false;
    protected static HashSet m_OptionBlacklist = new HashSet();

    public DataGenerator() {
        DataGenerator.clearBlacklist();
        this.setNumExamplesAct(this.defaultNumExamplesAct());
        this.setSeed(this.defaultSeed());
    }

    protected Vector enumToVector(Enumeration enm) {
        Vector result = new Vector();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tPrints this help.", "h", 1, "-h"));
        result.addElement(new Option("\tThe name of the output file, otherwise the generated data is\n\tprinted to stdout.", "o", 1, "-o <file>"));
        result.addElement(new Option("\tThe name of the relation.", "r", 1, "-r <name>"));
        result.addElement(new Option("\tWhether to print debug informations.", "d", 0, "-d"));
        result.addElement(new Option("\tThe seed for random function (default " + this.defaultSeed() + ")", "S", 1, "-S"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('r', options = this.removeBlacklist(options));
        if (tmpStr.length() != 0) {
            this.setRelationName(Utils.unquote(tmpStr));
        } else {
            this.setRelationName("");
        }
        tmpStr = Utils.getOption('o', options);
        if (tmpStr.length() != 0) {
            this.setOutput(new PrintWriter(new FileOutputStream(tmpStr)));
        } else if (this.getOutput() == null) {
            throw new Exception("No Output defined!");
        }
        this.setDebug(Utils.getFlag('d', options));
        tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(this.defaultSeed());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (!this.m_CreatingRelationName) {
            result.add("-r");
            result.add(Utils.quote(this.getRelationNameToUse()));
        }
        if (this.getDebug()) {
            result.add("-d");
        }
        result.add("-S");
        result.add("" + this.getSeed());
        return result.toArray(new String[result.size()]);
    }

    public Instances defineDataFormat() throws Exception {
        if (this.getRelationName().length() == 0) {
            this.setRelationName(this.defaultRelationName());
        }
        return this.m_DatasetFormat;
    }

    public abstract Instance generateExample() throws Exception;

    public abstract Instances generateExamples() throws Exception;

    public abstract String generateStart() throws Exception;

    public abstract String generateFinished() throws Exception;

    public abstract boolean getSingleModeFlag() throws Exception;

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether the generator is run in debug mode or not.";
    }

    public void setRelationName(String relationName) {
        this.m_RelationName = relationName;
    }

    protected String defaultRelationName() {
        this.m_CreatingRelationName = true;
        StringBuffer result = new StringBuffer(this.getClass().getName());
        String[] options = this.getOptions();
        int i = 0;
        while (i < options.length) {
            String option = options[i].trim();
            if (i > 0) {
                result.append("_");
            }
            result.append(option.replaceAll(" ", "_"));
            ++i;
        }
        this.m_CreatingRelationName = false;
        return result.toString();
    }

    protected String getRelationNameToUse() {
        String result = this.getRelationName();
        if (result.length() == 0) {
            result = this.defaultRelationName();
        }
        return result;
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return "The relation name of the generated data (if empty, a generic one will be supplied).";
    }

    protected int defaultNumExamplesAct() {
        return 0;
    }

    protected void setNumExamplesAct(int numExamplesAct) {
        this.m_NumExamplesAct = numExamplesAct;
    }

    public int getNumExamplesAct() {
        return this.m_NumExamplesAct;
    }

    protected String numExamplesActTipText() {
        return "The actual number of examples to generate.";
    }

    public void setOutput(PrintWriter newOutput) {
        this.m_Output = newOutput;
        this.m_DefaultOutput = null;
    }

    public PrintWriter getOutput() {
        return this.m_Output;
    }

    public PrintWriter defaultOutput() {
        return this.m_DefaultOutput;
    }

    public String outputTipText() {
        return "The output writer to use for printing the generated data.";
    }

    public void setDatasetFormat(Instances newFormat) {
        this.m_DatasetFormat = new Instances(newFormat, 0);
    }

    public Instances getDatasetFormat() {
        if (this.m_DatasetFormat != null) {
            return new Instances(this.m_DatasetFormat, 0);
        }
        return null;
    }

    public String formatTipText() {
        return "The data format to use.";
    }

    protected int defaultSeed() {
        return 1;
    }

    @Override
    public int getSeed() {
        return this.m_Seed;
    }

    @Override
    public void setSeed(int newSeed) {
        this.m_Seed = newSeed;
        this.m_Random = new Random(newSeed);
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public Random getRandom() {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.getSeed());
        }
        return this.m_Random;
    }

    public void setRandom(Random newRandom) {
        this.m_Random = newRandom;
    }

    public String randomTipText() {
        return "The random number generator to use.";
    }

    protected String toStringFormat() {
        if (this.m_DatasetFormat == null) {
            return "";
        }
        return this.m_DatasetFormat.toString();
    }

    protected static void clearBlacklist() {
        m_OptionBlacklist.clear();
    }

    protected static void addToBlacklist(String option) {
        m_OptionBlacklist.add(option);
    }

    protected static boolean isOnBlacklist(String option) {
        return m_OptionBlacklist.contains(option);
    }

    protected String[] removeBlacklist(String[] options) {
        Option option;
        Enumeration enm = this.listOptions();
        Hashtable<String, Option> pool = new Hashtable<String, Option>();
        while (enm.hasMoreElements()) {
            option = (Option)enm.nextElement();
            if (!DataGenerator.isOnBlacklist(option.name())) continue;
            pool.put(option.name(), option);
        }
        enm = pool.keys();
        while (enm.hasMoreElements()) {
            option = (Option)pool.get(enm.nextElement());
            try {
                if (option.numArguments() == 0) {
                    Utils.getFlag(option.name(), options);
                    continue;
                }
                Utils.getOption(option.name(), options);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return options;
    }

    protected static String makeOptionString(DataGenerator generator) {
        StringBuffer result = new StringBuffer();
        result.append("\nData Generator options:\n\n");
        Enumeration enm = generator.listOptions();
        while (enm.hasMoreElements()) {
            Option option = (Option)enm.nextElement();
            if (DataGenerator.isOnBlacklist(option.name())) continue;
            result.append(String.valueOf(option.synopsis()) + "\n" + option.description() + "\n");
        }
        return result.toString();
    }

    public static void makeData(DataGenerator generator, String[] options) throws Exception {
        boolean singleMode;
        int i;
        boolean printhelp = Utils.getFlag('h', options);
        if (!printhelp) {
            try {
                options = generator.removeBlacklist(options);
                generator.setOptions(options);
                Vector<String> unknown = new Vector<String>();
                i = 0;
                while (i < options.length) {
                    if (options[i].length() != 0) {
                        unknown.add(options[i]);
                    }
                    ++i;
                }
                if (unknown.size() > 0) {
                    System.out.print("Unknown options:");
                    i = 0;
                    while (i < unknown.size()) {
                        System.out.print(" " + unknown.get(i));
                        ++i;
                    }
                    System.out.println();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                printhelp = true;
            }
        }
        if (printhelp) {
            System.out.println(DataGenerator.makeOptionString(generator));
            return;
        }
        generator.setDatasetFormat(generator.defineDataFormat());
        PrintWriter output = generator.getOutput();
        output.println("%");
        output.println("% Commandline");
        output.println("%");
        output.println("% " + generator.getClass().getName() + " " + Utils.joinOptions(generator.getOptions()));
        output.println("%");
        String commentAtStart = generator.generateStart();
        if (commentAtStart.length() > 0) {
            output.println("%");
            output.println("% Prologue");
            output.println("%");
            output.println(commentAtStart.trim());
            output.println("%");
        }
        if (singleMode = generator.getSingleModeFlag()) {
            output.println(generator.toStringFormat());
            i = 0;
            while (i < generator.getNumExamplesAct()) {
                Instance inst = generator.generateExample();
                output.println(inst);
                ++i;
            }
        } else {
            Instances dataset = generator.generateExamples();
            output.println(dataset);
        }
        String commentAtEnd = generator.generateFinished();
        if (commentAtEnd.length() > 0) {
            output.println("%");
            output.println("% Epilogue");
            output.println("%");
            output.println(commentAtEnd.trim());
            output.println("%");
        }
        output.flush();
        if (generator.getOutput() != generator.defaultOutput()) {
            output.close();
        }
    }

    protected static void runDataGenerator(DataGenerator datagenerator, String[] options) {
        try {
            DataGenerator.makeData(datagenerator, options);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("Data Generator options") == -1) {
                e.printStackTrace();
            }
            System.err.println(e.getMessage());
        }
    }
}

