/*
 * Decompiled with CFR 0.152.
 */
package weka.core.xml;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Element;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.ProtectedProperties;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.Version;
import weka.core.xml.XMLDocument;

public class XMLInstances
extends XMLDocument
implements Serializable {
    private static final long serialVersionUID = 3626821327547416099L;
    public static String FILE_EXTENSION = ".xrff";
    public static final String TAG_DATASET = "dataset";
    public static final String TAG_HEADER = "header";
    public static final String TAG_BODY = "body";
    public static final String TAG_NOTES = "notes";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_LABELS = "labels";
    public static final String TAG_LABEL = "label";
    public static final String TAG_METADATA = "metadata";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_INSTANCES = "instances";
    public static final String TAG_INSTANCE = "instance";
    public static final String TAG_VALUE = "value";
    public static final String ATT_VERSION = "version";
    public static final String ATT_TYPE = "type";
    public static final String ATT_FORMAT = "format";
    public static final String ATT_CLASS = "class";
    public static final String ATT_INDEX = "index";
    public static final String ATT_WEIGHT = "weight";
    public static final String ATT_MISSING = "missing";
    public static final String VAL_NUMERIC = "numeric";
    public static final String VAL_DATE = "date";
    public static final String VAL_NOMINAL = "nominal";
    public static final String VAL_STRING = "string";
    public static final String VAL_RELATIONAL = "relational";
    public static final String VAL_NORMAL = "normal";
    public static final String VAL_SPARSE = "sparse";
    public static final String DOCTYPE = "<!DOCTYPE dataset\n[\n   <!ELEMENT dataset (header,body)>\n   <!ATTLIST dataset name CDATA #REQUIRED>\n   <!ATTLIST dataset version CDATA \"" + Version.VERSION + "\">\n" + "\n" + "   <!" + "ELEMENT" + " " + "header" + " (" + "notes" + "?" + "," + "attributes" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "body" + " (" + "instances" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "notes" + " " + "ANY" + ">   <!--  comments, information, copyright, etc. -->\n" + "\n" + "   <!" + "ELEMENT" + " " + "attributes" + " (" + "attribute" + "+" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "attribute" + " (" + "labels" + "?" + "," + "metadata" + "?" + "," + "attributes" + "?" + ")" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "name" + " " + "CDATA" + " " + "#REQUIRED" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "type" + " (" + "numeric" + "|" + "date" + "|" + "nominal" + "|" + "string" + "|" + "relational" + ") " + "#REQUIRED" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "format" + " " + "CDATA" + " " + "#IMPLIED" + ">\n" + "   <!" + "ATTLIST" + " " + "attribute" + " " + "class" + " (" + "yes" + "|" + "no" + ") \"" + "no" + "\"" + ">\n" + "   <!" + "ELEMENT" + " " + "labels" + " (" + "label" + "*" + ")" + ">   <!-- only for type \"nominal\" -->\n" + "   <!" + "ELEMENT" + " " + "label" + " " + "ANY" + ">\n" + "   <!" + "ELEMENT" + " " + "metadata" + " (" + "property" + "*" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "property" + " " + "ANY" + ">\n" + "   <!" + "ATTLIST" + " " + "property" + " " + "name" + " " + "CDATA" + " " + "#REQUIRED" + ">\n" + "\n" + "   <!" + "ELEMENT" + " " + "instances" + " (" + "instance" + "*" + ")" + ">\n" + "   <!" + "ELEMENT" + " " + "instance" + " (" + "value" + "*" + ")" + ">\n" + "   <!" + "ATTLIST" + " " + "instance" + " " + "type" + " (" + "normal" + "|" + "sparse" + ") \"" + "normal" + "\"" + ">\n" + "   <!" + "ATTLIST" + " " + "instance" + " " + "weight" + " " + "CDATA" + " " + "#IMPLIED" + ">\n" + "   <!" + "ELEMENT" + " " + "value" + " (" + "#PCDATA" + "|" + "instances" + ")" + "*" + ">\n" + "   <!" + "ATTLIST" + " " + "value" + " " + "index" + " " + "CDATA" + " " + "#IMPLIED" + ">   <!-- 1-based index (only used for instance format \"sparse\") -->\n" + "   <!" + "ATTLIST" + " " + "value" + " " + "missing" + " (" + "yes" + "|" + "no" + ") \"" + "no" + "\"" + ">\n" + "]\n" + ">";
    protected int m_Precision = 6;
    protected Instances m_Instances = null;

    public XMLInstances() throws Exception {
        this.setDocType(DOCTYPE);
        this.setRootNode(TAG_DATASET);
        this.setValidating(true);
    }

    public XMLInstances(Instances data) throws Exception {
        this();
        this.setInstances(data);
    }

    public XMLInstances(Reader reader) throws Exception {
        this();
        this.setXML(reader);
    }

    protected void addAttribute(Element parent, Attribute att) {
        String tmpStr;
        Enumeration<?> enm;
        Element child;
        Element node = this.m_Document.createElement(TAG_ATTRIBUTE);
        parent.appendChild(node);
        node.setAttribute("name", this.validContent(att.name()));
        switch (att.type()) {
            case 0: {
                node.setAttribute(ATT_TYPE, VAL_NUMERIC);
                break;
            }
            case 3: {
                node.setAttribute(ATT_TYPE, VAL_DATE);
                break;
            }
            case 1: {
                node.setAttribute(ATT_TYPE, VAL_NOMINAL);
                break;
            }
            case 2: {
                node.setAttribute(ATT_TYPE, VAL_STRING);
                break;
            }
            case 4: {
                node.setAttribute(ATT_TYPE, VAL_RELATIONAL);
                break;
            }
            default: {
                node.setAttribute(ATT_TYPE, "???");
            }
        }
        if (att.isNominal()) {
            child = this.m_Document.createElement(TAG_LABELS);
            node.appendChild(child);
            enm = att.enumerateValues();
            while (enm.hasMoreElements()) {
                tmpStr = enm.nextElement().toString();
                Element label = this.m_Document.createElement(TAG_LABEL);
                child.appendChild(label);
                label.appendChild(this.m_Document.createTextNode(this.validContent(tmpStr)));
            }
        }
        if (att.isDate()) {
            node.setAttribute(ATT_FORMAT, this.validContent(att.getDateFormat()));
        }
        if (this.m_Instances.classIndex() > -1 && att == this.m_Instances.classAttribute()) {
            node.setAttribute(ATT_CLASS, "yes");
        }
        if (att.getMetadata() != null && att.getMetadata().size() > 0) {
            child = this.m_Document.createElement(TAG_METADATA);
            node.appendChild(child);
            enm = att.getMetadata().propertyNames();
            while (enm.hasMoreElements()) {
                tmpStr = enm.nextElement().toString();
                Element property = this.m_Document.createElement(TAG_PROPERTY);
                child.appendChild(property);
                property.setAttribute("name", this.validContent(tmpStr));
                property.appendChild(this.m_Document.createTextNode(this.validContent(att.getMetadata().getProperty(tmpStr, ""))));
            }
        }
        if (att.isRelationValued()) {
            child = this.m_Document.createElement(TAG_ATTRIBUTES);
            node.appendChild(child);
            int i = 0;
            while (i < att.relation().numAttributes()) {
                this.addAttribute(child, att.relation().attribute(i));
                ++i;
            }
        }
    }

    protected String validContent(String content) {
        String result = content;
        result = result.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        result = result.replaceAll("\n", "&#10;").replaceAll("\r", "&#13;").replaceAll("\t", "&#9;");
        return result;
    }

    protected void addInstance(Element parent, Instance inst) {
        Element node = this.m_Document.createElement(TAG_INSTANCE);
        parent.appendChild(node);
        boolean sparse = inst instanceof SparseInstance;
        if (sparse) {
            node.setAttribute(ATT_TYPE, VAL_SPARSE);
        }
        if (inst.weight() != 1.0) {
            node.setAttribute(ATT_WEIGHT, Utils.doubleToString(inst.weight(), this.m_Precision));
        }
        int i = 0;
        while (i < inst.numValues()) {
            int index = inst.index(i);
            Element value = this.m_Document.createElement(TAG_VALUE);
            node.appendChild(value);
            if (inst.isMissing(index)) {
                value.setAttribute(ATT_MISSING, "yes");
            } else if (inst.attribute(index).isRelationValued()) {
                Element child = this.m_Document.createElement(TAG_INSTANCES);
                value.appendChild(child);
                int n = 0;
                while (n < inst.relationalValue(i).numInstances()) {
                    this.addInstance(child, inst.relationalValue(i).instance(n));
                    ++n;
                }
            } else if (inst.attribute(index).type() == 0) {
                value.appendChild(this.m_Document.createTextNode(Utils.doubleToString(inst.value(index), this.m_Precision)));
            } else {
                value.appendChild(this.m_Document.createTextNode(this.validContent(inst.stringValue(index))));
            }
            if (sparse) {
                value.setAttribute(ATT_INDEX, "" + (index + 1));
            }
            ++i;
        }
    }

    protected void headerToXML() {
        Element root = this.m_Document.getDocumentElement();
        root.setAttribute("name", this.validContent(this.m_Instances.relationName()));
        root.setAttribute(ATT_VERSION, Version.VERSION);
        Element node = this.m_Document.createElement(TAG_HEADER);
        root.appendChild(node);
        Element child = this.m_Document.createElement(TAG_ATTRIBUTES);
        node.appendChild(child);
        int i = 0;
        while (i < this.m_Instances.numAttributes()) {
            this.addAttribute(child, this.m_Instances.attribute(i));
            ++i;
        }
    }

    protected void dataToXML() {
        Element root = this.m_Document.getDocumentElement();
        Element node = this.m_Document.createElement(TAG_BODY);
        root.appendChild(node);
        Element child = this.m_Document.createElement(TAG_INSTANCES);
        node.appendChild(child);
        int i = 0;
        while (i < this.m_Instances.numInstances()) {
            this.addInstance(child, this.m_Instances.instance(i));
            ++i;
        }
    }

    public void setInstances(Instances data) {
        this.m_Instances = new Instances(data);
        this.clear();
        this.headerToXML();
        this.dataToXML();
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    protected ProtectedProperties createMetadata(Element parent) throws Exception {
        ProtectedProperties result = null;
        Element metanode = null;
        Vector list = XMLInstances.getChildTags(parent, TAG_METADATA);
        if (list.size() > 0) {
            metanode = (Element)list.get(0);
        }
        if (metanode != null) {
            Properties props = new Properties();
            list = XMLInstances.getChildTags(metanode, TAG_PROPERTY);
            int i = 0;
            while (i < list.size()) {
                Element node = (Element)list.get(i);
                props.setProperty(node.getAttribute("name"), XMLInstances.getContent(node));
                ++i;
            }
            result = new ProtectedProperties(props);
        }
        return result;
    }

    protected FastVector createLabels(Element parent) throws Exception {
        FastVector result = new FastVector();
        Element labelsnode = null;
        Vector list = XMLInstances.getChildTags(parent, TAG_LABELS);
        if (list.size() > 0) {
            labelsnode = (Element)list.get(0);
        }
        if (labelsnode != null) {
            list = XMLInstances.getChildTags(labelsnode, TAG_LABEL);
            int i = 0;
            while (i < list.size()) {
                Element node = (Element)list.get(i);
                result.addElement(XMLInstances.getContent(node));
                ++i;
            }
        }
        return result;
    }

    protected Attribute createAttribute(Element node) throws Exception {
        int type;
        Attribute result = null;
        String name = node.getAttribute("name");
        String typeStr = node.getAttribute(ATT_TYPE);
        if (typeStr.equals(VAL_NUMERIC)) {
            type = 0;
        } else if (typeStr.equals(VAL_DATE)) {
            type = 3;
        } else if (typeStr.equals(VAL_NOMINAL)) {
            type = 1;
        } else if (typeStr.equals(VAL_STRING)) {
            type = 2;
        } else if (typeStr.equals(VAL_RELATIONAL)) {
            type = 4;
        } else {
            throw new Exception("Attribute type '" + typeStr + "' is not supported!");
        }
        ProtectedProperties metadata = this.createMetadata(node);
        switch (type) {
            case 0: {
                if (metadata == null) {
                    result = new Attribute(name);
                    break;
                }
                result = new Attribute(name, metadata);
                break;
            }
            case 3: {
                if (metadata == null) {
                    result = new Attribute(name, node.getAttribute(ATT_FORMAT));
                    break;
                }
                result = new Attribute(name, node.getAttribute(ATT_FORMAT), metadata);
                break;
            }
            case 1: {
                FastVector values = this.createLabels(node);
                if (metadata == null) {
                    result = new Attribute(name, values);
                    break;
                }
                result = new Attribute(name, values, metadata);
                break;
            }
            case 2: {
                if (metadata == null) {
                    result = new Attribute(name, null);
                    break;
                }
                result = new Attribute(name, null, metadata);
                break;
            }
            case 4: {
                Vector list = XMLInstances.getChildTags(node, TAG_ATTRIBUTES);
                node = (Element)list.get(0);
                FastVector atts = this.createAttributes(node, new int[1]);
                result = metadata == null ? new Attribute(name, new Instances(name, atts, 0)) : new Attribute(name, new Instances(name, atts, 0), metadata);
            }
        }
        return result;
    }

    protected FastVector createAttributes(Element parent, int[] classIndex) throws Exception {
        FastVector result = new FastVector();
        classIndex[0] = -1;
        Vector list = XMLInstances.getChildTags(parent, TAG_ATTRIBUTE);
        int i = 0;
        while (i < list.size()) {
            Element node = (Element)list.get(i);
            Attribute att = this.createAttribute(node);
            if (node.getAttribute(ATT_CLASS).equals("yes")) {
                classIndex[0] = i;
            }
            result.addElement(att);
            ++i;
        }
        return result;
    }

    protected Instance createInstance(Instances header, Element parent) throws Exception {
        Instance result = null;
        boolean sparse = parent.getAttribute(ATT_TYPE).equals(VAL_SPARSE);
        double[] values = new double[header.numAttributes()];
        double weight = parent.getAttribute(ATT_WEIGHT).length() != 0 ? Double.parseDouble(parent.getAttribute(ATT_WEIGHT)) : 1.0;
        Vector list = XMLInstances.getChildTags(parent, TAG_VALUE);
        int i = 0;
        while (i < list.size()) {
            Element node = (Element)list.get(i);
            int index = sparse ? Integer.parseInt(node.getAttribute(ATT_INDEX)) - 1 : i;
            if (node.getAttribute(ATT_MISSING).equals("yes")) {
                values[index] = Instance.missingValue();
            } else {
                String content = XMLInstances.getContent(node);
                switch (header.attribute(index).type()) {
                    case 0: {
                        values[index] = Double.parseDouble(content);
                        break;
                    }
                    case 3: {
                        values[index] = header.attribute(index).parseDate(content);
                        break;
                    }
                    case 1: {
                        values[index] = header.attribute(index).indexOfValue(content);
                        break;
                    }
                    case 2: {
                        values[index] = header.attribute(index).addStringValue(content);
                        break;
                    }
                    case 4: {
                        Vector subList = XMLInstances.getChildTags(node, TAG_INSTANCES);
                        Element child = (Element)subList.get(0);
                        Instances data = this.createInstances(header.attribute(index).relation(), child);
                        values[index] = header.attribute(index).addRelation(data);
                        break;
                    }
                    default: {
                        throw new Exception("Attribute type " + header.attribute(index).type() + " is not supported!");
                    }
                }
            }
            ++i;
        }
        result = sparse ? new SparseInstance(weight, values) : new Instance(weight, values);
        return result;
    }

    protected Instances createInstances(Instances header, Element parent) throws Exception {
        Instances result = new Instances(header, 0);
        Vector list = XMLInstances.getChildTags(parent, TAG_INSTANCE);
        int i = 0;
        while (i < list.size()) {
            result.add(this.createInstance(result, (Element)list.get(i)));
            ++i;
        }
        return result;
    }

    protected Instances headerFromXML() throws Exception {
        Version version2 = new Version();
        Element root = this.m_Document.getDocumentElement();
        if (version2.isOlder(root.getAttribute(ATT_VERSION))) {
            System.out.println("WARNING: loading data of version " + root.getAttribute(ATT_VERSION) + " with version " + Version.VERSION);
        }
        Vector list = XMLInstances.getChildTags(root, TAG_HEADER);
        Element node = (Element)list.get(0);
        list = XMLInstances.getChildTags(node, TAG_ATTRIBUTES);
        node = (Element)list.get(0);
        int[] classIndex = new int[1];
        FastVector atts = this.createAttributes(node, classIndex);
        Instances result = new Instances(root.getAttribute("name"), atts, 0);
        result.setClassIndex(classIndex[0]);
        return result;
    }

    protected Instances dataFromXML(Instances header) throws Exception {
        Vector list = XMLInstances.getChildTags(this.m_Document.getDocumentElement(), TAG_BODY);
        Element node = (Element)list.get(0);
        list = XMLInstances.getChildTags(node, TAG_INSTANCES);
        node = (Element)list.get(0);
        Instances result = this.createInstances(header, node);
        return result;
    }

    public void setXML(Reader reader) throws Exception {
        this.read(reader);
        this.m_Instances = this.dataFromXML(this.headerFromXML());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] args) {
        try {
            RevisionHandler i;
            BufferedReader r = null;
            if (args.length != 1) {
                throw new Exception("Usage: XMLInstances <filename>");
            }
            InputStream in = new FileInputStream(args[0]);
            if (args[0].endsWith(".gz")) {
                in = new GZIPInputStream(in);
            }
            r = new BufferedReader(new InputStreamReader(in));
            if (args[0].endsWith(".arff")) {
                i = new XMLInstances(new Instances(r));
                System.out.println(((XMLDocument)i).toString());
            } else {
                i = new XMLInstances(r).getInstances();
                System.out.println(((Instances)i).toSummaryString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

