/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.tokenizers.AbstractTokenizerTest;
import weka.core.tokenizers.NGramTokenizer;
import weka.core.tokenizers.Tokenizer;

public class NGramTokenizerTest
extends AbstractTokenizerTest {
    public NGramTokenizerTest(String name) {
        super(name);
    }

    @Override
    public Tokenizer getTokenizer() {
        return new NGramTokenizer();
    }

    public void testNumberOfGeneratedTokens() {
        String[] result;
        String s = "HOWEVER, the egg only got larger and larger, and more and more human";
        try {
            result = Tokenizer.tokenize(this.m_Tokenizer, new String[]{"-min", "1", "-max", "1", s});
            NGramTokenizerTest.assertEquals("number of tokens differ (1)", 13, result.length);
        }
        catch (Exception e) {
            NGramTokenizerTest.fail("Error tokenizing string '" + s + "'!");
        }
        try {
            result = Tokenizer.tokenize(this.m_Tokenizer, new String[]{"-min", "2", "-max", "2", s});
            NGramTokenizerTest.assertEquals("number of tokens differ (2)", 12, result.length);
        }
        catch (Exception e) {
            NGramTokenizerTest.fail("Error tokenizing string '" + s + "'!");
        }
        try {
            result = Tokenizer.tokenize(this.m_Tokenizer, new String[]{"-min", "1", "-max", "3", s});
            NGramTokenizerTest.assertEquals("number of tokens differ (3)", 36, result.length);
        }
        catch (Exception e) {
            NGramTokenizerTest.fail("Error tokenizing string '" + s + "'!");
        }
    }

    public static Test suite() {
        return new TestSuite(NGramTokenizerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(NGramTokenizerTest.suite());
    }
}

