/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.tokenizers.AbstractTokenizerTest;
import weka.core.tokenizers.AlphabeticTokenizer;
import weka.core.tokenizers.Tokenizer;

public class AlphabeticTokenizerTest
extends AbstractTokenizerTest {
    public AlphabeticTokenizerTest(String name) {
        super(name);
    }

    @Override
    public Tokenizer getTokenizer() {
        return new AlphabeticTokenizer();
    }

    public void testNumberOfGeneratedTokens() {
        String[] result;
        String s = "HOWEVER, the egg only got larger and larger, and more and more human";
        try {
            result = Tokenizer.tokenize(this.m_Tokenizer, new String[]{s});
            AlphabeticTokenizerTest.assertEquals("number of tokens differ (1)", 13, result.length);
        }
        catch (Exception e) {
            AlphabeticTokenizerTest.fail("Error tokenizing string '" + s + "'!");
        }
        s = "The planet Mars, I scarcely need remind the reader, revolves about the sun at a mean distance of 140,000,000 miles";
        try {
            result = Tokenizer.tokenize(this.m_Tokenizer, new String[]{s});
            AlphabeticTokenizerTest.assertEquals("number of tokens differ (2)", 19, result.length);
        }
        catch (Exception e) {
            AlphabeticTokenizerTest.fail("Error tokenizing string '" + s + "'!");
        }
    }

    public static Test suite() {
        return new TestSuite(AlphabeticTokenizerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(AlphabeticTokenizerTest.suite());
    }
}

