/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractConverterTest;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.URLSourcedLoader;

public abstract class AbstractFileConverterTest
extends AbstractConverterTest {
    protected String m_SourceFilename;
    protected String m_ExportFilename;
    protected String[] m_CommandlineOptions;

    public AbstractFileConverterTest(String name) {
        super(name);
    }

    protected String getSourceFilename() {
        String result = null;
        try {
            File file = File.createTempFile("weka_core_converters", ".arff");
            file.deleteOnExit();
            result = file.getAbsolutePath();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected String getExportFilename() {
        String result = null;
        try {
            File file = File.createTempFile("weka_core_converters", ((FileSourcedConverter)((Object)this.getLoader())).getFileExtension());
            file.deleteOnExit();
            result = file.getAbsolutePath();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected String[] getCommandlineOptions(boolean loader) {
        if (loader) {
            return new String[]{this.m_ExportFilename};
        }
        return new String[]{"-i", this.m_SourceFilename, "-o", this.m_ExportFilename};
    }

    protected void compareDatasets(Instances data1, Instances data2) throws Exception {
        if (!data2.equalHeaders(data1)) {
            throw new Exception("header has been modified");
        }
        if (data2.numInstances() != data1.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        int i = 0;
        while (i < data2.numInstances()) {
            Instance orig = data1.instance(i);
            Instance copy = data2.instance(i);
            int j = 0;
            while (j < orig.numAttributes()) {
                if (orig.isMissing(j) ? !copy.isMissing(j) : orig.value(j) != copy.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (orig.weight() != copy.weight()) {
                    throw new Exception("instance weights have changed");
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_SourceFilename = this.getSourceFilename();
        this.m_ExportFilename = this.getExportFilename();
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.m_SourceFilename));
        writer.write(this.m_Instances.toString());
        writer.newLine();
        writer.flush();
        writer.close();
    }

    @Override
    protected void tearDown() throws Exception {
        File file = new File(this.m_SourceFilename);
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(this.m_ExportFilename)).exists()) {
            file.delete();
        }
        this.m_SourceFilename = null;
        this.m_ExportFilename = null;
        super.tearDown();
    }

    public void testBatch() {
        try {
            this.m_Saver.setInstances(this.m_Instances);
            this.m_Saver.setFile(new File(this.m_ExportFilename));
            this.m_Saver.writeBatch();
            ((AbstractFileLoader)this.m_Loader).setFile(new File(this.m_ExportFilename));
            Instances data = this.m_Loader.getDataSet();
            try {
                if (this.m_Instances.classIndex() != data.classIndex()) {
                    data.setClassIndex(this.m_Instances.classIndex());
                }
                this.compareDatasets(this.m_Instances, data);
            }
            catch (Exception e) {
                AbstractFileConverterTest.fail("Incremental load failed (datasets differ): " + e.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractFileConverterTest.fail("Batch save/load failed: " + e.toString());
        }
    }

    public void testIncrementalLoader() {
        if (!(this.getLoader() instanceof IncrementalConverter)) {
            return;
        }
        try {
            Instance temp;
            this.m_Saver.setInstances(this.m_Instances);
            this.m_Saver.setFile(new File(this.m_ExportFilename));
            this.m_Saver.writeBatch();
            ((AbstractFileLoader)this.m_Loader).setFile(new File(this.m_ExportFilename));
            Instances data = new Instances(this.m_Loader.getStructure());
            do {
                if ((temp = this.m_Loader.getNextInstance(data)) == null) continue;
                data.add(temp);
            } while (temp != null);
            try {
                if (this.m_Instances.classIndex() != data.classIndex()) {
                    data.setClassIndex(this.m_Instances.classIndex());
                }
                this.compareDatasets(this.m_Instances, data);
            }
            catch (Exception e) {
                AbstractFileConverterTest.fail("Incremental load failed (datasets differ): " + e.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractFileConverterTest.fail("Incremental load failed: " + e.toString());
        }
    }

    public void testIncrementalSaver() {
        if (!(this.getSaver() instanceof IncrementalConverter)) {
            return;
        }
        try {
            File file = new File(this.m_ExportFilename);
            if (file.exists()) {
                file.delete();
            }
            this.m_Saver.setFile(new File(this.m_ExportFilename));
            this.m_Saver.setRetrieval(2);
            this.m_Saver.setStructure(new Instances(this.m_Instances, 0));
            int i = 0;
            while (i < this.m_Instances.numInstances()) {
                this.m_Saver.writeIncremental(this.m_Instances.instance(i));
                ++i;
            }
            this.m_Saver.writeIncremental(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractFileConverterTest.fail("Incremental save failed: " + e.toString());
        }
    }

    public void testLoaderCommandlineArgs() {
    }

    public void testSaverCommandlineArgs() {
        String[] options = this.getCommandlineOptions(false);
        try {
            ((OptionHandler)((Object)this.m_Saver)).setOptions(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractFileConverterTest.fail("Command line test failed ('" + Utils.arrayToString(options) + "'): " + e.toString());
        }
    }

    public void testURLSourcedLoader() {
        if (!(this.getLoader() instanceof URLSourcedLoader)) {
            return;
        }
        try {
            this.m_Saver.setInstances(this.m_Instances);
            this.m_Saver.setFile(new File(this.m_ExportFilename));
            this.m_Saver.writeBatch();
            ((URLSourcedLoader)((Object)this.m_Loader)).setURL(new File(this.m_ExportFilename).toURL().toString());
            Instances data = this.m_Loader.getDataSet();
            try {
                if (this.m_Instances.classIndex() != data.classIndex()) {
                    data.setClassIndex(this.m_Instances.classIndex());
                }
                this.compareDatasets(this.m_Instances, data);
            }
            catch (Exception e) {
                AbstractFileConverterTest.fail("URL load failed (datasets differ): " + e.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractFileConverterTest.fail("URL load failed: " + e.toString());
        }
    }

    public void testLoaderWithStream() {
        try {
            this.m_Saver.setInstances(this.m_Instances);
            this.m_Saver.setFile(new File(this.m_ExportFilename));
            this.m_Saver.writeBatch();
            this.m_Loader.setSource(new FileInputStream(new File(this.m_ExportFilename)));
            Instances data = this.m_Loader.getDataSet();
            try {
                if (this.m_Instances.classIndex() != data.classIndex()) {
                    data.setClassIndex(this.m_Instances.classIndex());
                }
                this.compareDatasets(this.m_Instances, data);
            }
            catch (Exception e) {
                AbstractFileConverterTest.fail("File stream loading failed (datasets differ): " + e.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractFileConverterTest.fail("File stream loading failed: " + e.toString());
        }
    }
}

