/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.SingleIndex;

public class SingleIndexTest
extends TestCase {
    public SingleIndexTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected SingleIndex getIndex(String initial, int upper) {
        SingleIndex result;
        if (initial == null) {
            result = new SingleIndex();
            result.setSingleIndex("1");
            result.setUpper(upper);
        } else {
            result = new SingleIndex(initial);
            result.setUpper(upper);
        }
        return result;
    }

    public void testDefaultConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        SingleIndex index = new SingleIndex();
        index.setSingleIndex(indexStr);
        index.setUpper(upper);
        SingleIndexTest.assertEquals(indexStr, index.getSingleIndex());
        SingleIndexTest.assertEquals(indexInt, index.getIndex());
    }

    public void testInitialValueConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        SingleIndex index = this.getIndex("1", upper);
        SingleIndexTest.assertEquals(indexStr, index.getSingleIndex());
        SingleIndexTest.assertEquals(indexInt, index.getIndex());
    }

    public void testFirst() throws Exception {
        int upper = 10;
        SingleIndex index = this.getIndex("first", upper);
        SingleIndexTest.assertEquals(0, index.getIndex());
        SingleIndexTest.assertEquals("first", index.getSingleIndex());
    }

    public void testLast() throws Exception {
        int upper = 10;
        SingleIndex index = this.getIndex("last", upper);
        SingleIndexTest.assertEquals(upper, index.getIndex());
        SingleIndexTest.assertEquals("last", index.getSingleIndex());
    }

    public static Test suite() {
        return new TestSuite(SingleIndexTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(SingleIndexTest.suite());
    }
}

