/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Range;

public class RangeTest
extends TestCase {
    public RangeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Range getRange(String initial, int upper) {
        Range result;
        if (initial == null) {
            result = new Range();
            result.setRanges("1");
            result.setUpper(upper);
        } else {
            result = new Range(initial);
            result.setUpper(upper);
        }
        return result;
    }

    public void testDefaultConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        Range index = new Range();
        index.setRanges(indexStr);
        index.setUpper(upper);
        RangeTest.assertEquals(indexStr, index.getRanges());
        RangeTest.assertEquals(1, index.getSelection().length);
        RangeTest.assertEquals(indexInt, index.getSelection()[0]);
    }

    public void testInitialValueConstructor() throws Exception {
        int upper = 10;
        int indexInt = 0;
        String indexStr = "" + (indexInt + 1);
        Range index = this.getRange("1", upper);
        RangeTest.assertEquals(indexStr, index.getRanges());
        RangeTest.assertEquals(1, index.getSelection().length);
        RangeTest.assertEquals(indexInt, index.getSelection()[0]);
    }

    public void testFirst() throws Exception {
        int upper = 10;
        Range index = this.getRange("first", upper);
        RangeTest.assertEquals("first", index.getRanges());
        RangeTest.assertEquals(1, index.getSelection().length);
        RangeTest.assertEquals(0, index.getSelection()[0]);
    }

    public void testLast() throws Exception {
        int upper = 10;
        Range index = this.getRange("last", upper);
        RangeTest.assertEquals("last", index.getRanges());
        RangeTest.assertEquals(1, index.getSelection().length);
        RangeTest.assertEquals(upper, index.getSelection()[0]);
    }

    public void testFirstLast() throws Exception {
        int upper = 10;
        Range index = this.getRange("first-last", upper);
        RangeTest.assertEquals("first-last", index.getRanges());
        RangeTest.assertEquals(upper + 1, index.getSelection().length);
    }

    public void testSimpleRange() throws Exception {
        int upper = 10;
        String range = "1-3";
        Range index = this.getRange(range, upper);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] expected = nArray;
        RangeTest.assertEquals(range, index.getRanges());
        RangeTest.assertEquals(expected.length, index.getSelection().length);
        int i = 0;
        while (i < expected.length) {
            RangeTest.assertEquals(expected[i], index.getSelection()[i]);
            ++i;
        }
    }

    public void testMixedRange() throws Exception {
        int upper = 10;
        String range = "1-3,6,8-last";
        Range index = this.getRange(range, upper);
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 5;
        nArray[4] = 7;
        nArray[5] = 8;
        nArray[6] = 9;
        nArray[7] = 10;
        int[] expected = nArray;
        RangeTest.assertEquals(range, index.getRanges());
        RangeTest.assertEquals(expected.length, index.getSelection().length);
        int i = 0;
        while (i < expected.length) {
            RangeTest.assertEquals(expected[i], index.getSelection()[i]);
            ++i;
        }
    }

    public void testUnorderedRange() throws Exception {
        int upper = 10;
        String range = "8-last,1-3,6";
        Range index = this.getRange(range, upper);
        int[] nArray = new int[8];
        nArray[0] = 7;
        nArray[1] = 8;
        nArray[2] = 9;
        nArray[3] = 10;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 5;
        int[] expected = nArray;
        RangeTest.assertEquals(range, index.getRanges());
        RangeTest.assertEquals(expected.length, index.getSelection().length);
        int i = 0;
        while (i < expected.length) {
            RangeTest.assertEquals(expected[i], index.getSelection()[i]);
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(RangeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(RangeTest.suite());
    }
}

