/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.MathematicalExpression;

public class MathematicalExpressionTest
extends TestCase {
    public MathematicalExpressionTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(MathematicalExpressionTest.class);
    }

    protected double getExpressionResult(String expression) throws Exception {
        HashMap<String, Double> symbols = new HashMap<String, Double>();
        symbols.put("A", new Double(4.0));
        symbols.put("B", new Double(2.0));
        symbols.put("C", new Double(2.0));
        return MathematicalExpression.evaluate(expression, symbols);
    }

    public void testAddSub() throws Exception {
        double result = this.getExpressionResult("A-B+C");
        MathematicalExpressionTest.assertEquals(4.0, result);
    }

    public void testOperatorOrder() throws Exception {
        double result = this.getExpressionResult("A-B*C");
        MathematicalExpressionTest.assertEquals(0.0, result);
    }

    public void testBrackets() throws Exception {
        double result = this.getExpressionResult("(A-B)*C");
        MathematicalExpressionTest.assertEquals(4.0, result);
    }

    public void testExpressionWithConstants() throws Exception {
        double result = this.getExpressionResult("A-B*(C+5)");
        MathematicalExpressionTest.assertEquals(-10.0, result);
    }

    public void testExpressionWithFunction() throws Exception {
        double result = this.getExpressionResult("pow(A,B*1)-C*2");
        MathematicalExpressionTest.assertEquals(12.0, result);
    }

    public void testExpressionWithIFELSE() throws Exception {
        double result = this.getExpressionResult("ifelse((C<1000|C>5000),(A+B),C+C)");
        MathematicalExpressionTest.assertEquals(6.0, result);
    }

    public static void main(String[] args) {
        TestRunner.run(MathematicalExpressionTest.suite());
    }
}

