/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.AlgVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TestInstances;

public class AlgVectorTest
extends TestCase {
    protected Random m_Random;

    public AlgVectorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Random = new Random(1L);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.m_Random = null;
    }

    protected Instances generateData(int nominal, int numeric, int rows) {
        Instances result;
        TestInstances test = new TestInstances();
        test.setClassIndex(-2);
        test.setNumNominal(nominal);
        test.setNumNumeric(numeric);
        test.setNumInstances(rows);
        try {
            result = test.generate();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public void testLengthConstructor() {
        int len = 22;
        AlgVector v = new AlgVector(len);
        AlgVectorTest.assertEquals("Length differs", len, v.numElements());
    }

    public void testArrayConstructor() {
        double[] data = new double[]{2.3, 1.2, 5.0};
        AlgVector v = new AlgVector(data);
        AlgVectorTest.assertEquals("Length differs", data.length, v.numElements());
        int i = 0;
        while (i < data.length) {
            AlgVectorTest.assertEquals(String.valueOf(i + 1) + ". value differs", (Object)data[i], (Object)v.getElement(i));
            ++i;
        }
    }

    protected void runTestOnData(Instances data) {
        int numeric = 0;
        int n = 0;
        while (n < data.numAttributes()) {
            if (data.attribute(n).isNumeric()) {
                ++numeric;
            }
            ++n;
        }
        n = 0;
        while (n < data.numInstances()) {
            block9: {
                try {
                    AlgVector v = new AlgVector(data.instance(n));
                    AlgVectorTest.assertEquals(String.valueOf(n + 1) + ": length differs", numeric, v.numElements());
                    int index = 0;
                    int i = 0;
                    while (i < data.numAttributes()) {
                        if (data.attribute(i).isNumeric()) {
                            AlgVectorTest.assertEquals(String.valueOf(n + 1) + "/" + (i + 1) + ": value differs", (Object)data.instance(n).value(i), (Object)v.getElement(index));
                            ++index;
                        }
                        ++i;
                    }
                    Instance inst = v.getAsInstance(data, new Random(1L));
                    int i2 = 0;
                    while (i2 < data.numAttributes()) {
                        if (data.attribute(i2).isNumeric()) {
                            AlgVectorTest.assertEquals(String.valueOf(n + 1) + "/" + (i2 + 1) + ": returned value differs", (Object)data.instance(n).value(i2), (Object)inst.value(i2));
                        }
                        ++i2;
                    }
                }
                catch (Exception e) {
                    if (e instanceof IllegalArgumentException) break block9;
                    AlgVectorTest.fail(e.toString());
                }
            }
            ++n;
        }
    }

    public void testNumericInstances() {
        this.runTestOnData(this.generateData(0, 5, 5));
    }

    public void testNominalInstances() {
        this.runTestOnData(this.generateData(5, 0, 5));
    }

    public void testMixedInstances() {
        this.runTestOnData(this.generateData(5, 5, 5));
    }

    public static Test suite() {
        return new TestSuite(AlgVectorTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(AlgVectorTest.suite());
    }
}

