/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.OPTICS_GUI.SERObject;
import weka.core.FastVector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class GraphPanel
extends JComponent
implements RevisionHandler {
    private static final long serialVersionUID = 7917937528738361470L;
    private FastVector resultVector;
    private int verticalAdjustment;
    private Color coreDistanceColor;
    private Color reachabilityDistanceColor;
    private int widthSlider;
    private boolean showCoreDistances;
    private boolean showReachabilityDistances;
    private int recentIndex = -1;

    public GraphPanel(FastVector resultVector, int verticalAdjustment, boolean showCoreDistances, boolean showReachbilityDistances) {
        this.resultVector = resultVector;
        this.verticalAdjustment = verticalAdjustment;
        this.coreDistanceColor = new Color(100, 100, 100);
        this.reachabilityDistanceColor = Color.orange;
        this.widthSlider = 5;
        this.showCoreDistances = showCoreDistances;
        this.showReachabilityDistances = showReachbilityDistances;
        this.addMouseMotionListener(new MouseHandler());
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        int stepSize = 0;
        int cDist = 0;
        int rDist = 0;
        int vectorIndex = 0;
        while (vectorIndex < this.resultVector.size()) {
            double coreDistance = ((DataObject)this.resultVector.elementAt(vectorIndex)).getCoreDistance();
            double reachDistance = ((DataObject)this.resultVector.elementAt(vectorIndex)).getReachabilityDistance();
            cDist = coreDistance == 2.147483647E9 ? this.getHeight() : (int)(coreDistance * (double)this.verticalAdjustment);
            rDist = reachDistance == 2.147483647E9 ? this.getHeight() : (int)(reachDistance * (double)this.verticalAdjustment);
            int x = vectorIndex + stepSize;
            if (this.isShowCoreDistances()) {
                g.setColor(this.coreDistanceColor);
                g.fillRect(x, this.getHeight() - cDist, this.widthSlider, cDist);
            }
            if (this.isShowReachabilityDistances()) {
                int sizer = this.widthSlider;
                if (!this.isShowCoreDistances()) {
                    sizer = 0;
                }
                g.setColor(this.reachabilityDistanceColor);
                g.fillRect(x + sizer, this.getHeight() - rDist, this.widthSlider, rDist);
            }
            stepSize = this.isShowCoreDistances() && this.isShowReachabilityDistances() ? (stepSize += this.widthSlider * 2) : (stepSize += this.widthSlider);
            ++vectorIndex;
        }
    }

    public void setResultVector(FastVector resultVector) {
        this.resultVector = resultVector;
    }

    public void setNewToolTip(String toolTip) {
        this.setToolTipText(toolTip);
    }

    public void adjustSize(SERObject serObject) {
        int i = 0;
        if (this.isShowCoreDistances() && this.isShowReachabilityDistances()) {
            i = 10;
        } else if (this.isShowCoreDistances() && !this.isShowReachabilityDistances() || !this.isShowCoreDistances() && this.isShowReachabilityDistances()) {
            i = 5;
        }
        this.setSize(new Dimension(i * serObject.getDatabaseSize() + serObject.getDatabaseSize(), this.getHeight()));
        this.setPreferredSize(new Dimension(i * serObject.getDatabaseSize() + serObject.getDatabaseSize(), this.getHeight()));
    }

    public boolean isShowCoreDistances() {
        return this.showCoreDistances;
    }

    public void setShowCoreDistances(boolean showCoreDistances) {
        this.showCoreDistances = showCoreDistances;
    }

    public boolean isShowReachabilityDistances() {
        return this.showReachabilityDistances;
    }

    public void setShowReachabilityDistances(boolean showReachabilityDistances) {
        this.showReachabilityDistances = showReachabilityDistances;
    }

    public void setVerticalAdjustment(int verticalAdjustment) {
        this.verticalAdjustment = verticalAdjustment;
    }

    public void setCoreDistanceColor(Color coreDistanceColor) {
        this.coreDistanceColor = coreDistanceColor;
        this.repaint();
    }

    public void setReachabilityDistanceColor(Color reachabilityDistanceColor) {
        this.reachabilityDistanceColor = reachabilityDistanceColor;
        this.repaint();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    private class MouseHandler
    extends MouseMotionAdapter
    implements RevisionHandler {
        private MouseHandler() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.showToolTip(e.getX());
        }

        private boolean showToolTip(int x) {
            int i = 0;
            if (GraphPanel.this.isShowCoreDistances() && GraphPanel.this.isShowReachabilityDistances()) {
                i = 11;
            } else if (GraphPanel.this.isShowCoreDistances() && !GraphPanel.this.isShowReachabilityDistances() || !GraphPanel.this.isShowCoreDistances() && GraphPanel.this.isShowReachabilityDistances() || !GraphPanel.this.isShowCoreDistances() && !GraphPanel.this.isShowReachabilityDistances()) {
                i = 6;
            }
            if (x / i == GraphPanel.this.recentIndex) {
                return false;
            }
            GraphPanel.this.recentIndex = x / i;
            DataObject dataObject = null;
            try {
                dataObject = (DataObject)GraphPanel.this.resultVector.elementAt(GraphPanel.this.recentIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (dataObject != null) {
                if (!GraphPanel.this.isShowCoreDistances() && !GraphPanel.this.isShowReachabilityDistances()) {
                    GraphPanel.this.setNewToolTip("<html><body><b>Please select a distance</b></body></html>");
                } else {
                    GraphPanel.this.setNewToolTip("<html><body><table><tr><td>DataObject:</td><td>" + dataObject + "</td></tr>" + "<tr><td>Key:</td><td>" + dataObject.getKey() + "</td></tr>" + "<tr><td>" + (GraphPanel.this.isShowCoreDistances() ? "<b>" : "") + "Core-Distance:" + (GraphPanel.this.isShowCoreDistances() ? "</b>" : "") + "</td><td>" + (GraphPanel.this.isShowCoreDistances() ? "<b>" : "") + (dataObject.getCoreDistance() == 2.147483647E9 ? "UNDEFINED" : Utils.doubleToString(dataObject.getCoreDistance(), 3, 5)) + (GraphPanel.this.isShowCoreDistances() ? "</b>" : "") + "</td></tr>" + "<tr><td>" + (GraphPanel.this.isShowReachabilityDistances() ? "<b>" : "") + "Reachability-Distance:" + (GraphPanel.this.isShowReachabilityDistances() ? "</b>" : "") + "</td><td>" + (GraphPanel.this.isShowReachabilityDistances() ? "<b>" : "") + (dataObject.getReachabilityDistance() == 2.147483647E9 ? "UNDEFINED" : Utils.doubleToString(dataObject.getReachabilityDistance(), 3, 5)) + (GraphPanel.this.isShowReachabilityDistances() ? "</b>" : "") + "</td></tr>" + "</table></body></html>");
                }
            }
            return true;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.4 $");
        }
    }
}

