/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.DataObjects;

import java.io.Serializable;
import weka.clusterers.forOPTICSAndDBScan.DataObjects.DataObject;
import weka.clusterers.forOPTICSAndDBScan.Databases.Database;
import weka.core.Instance;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ManhattanDataObject
implements DataObject,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3417720553766544582L;
    private Instance instance;
    private String key;
    private int clusterID;
    private boolean processed;
    private double c_dist;
    private double r_dist;
    private Database database;

    public ManhattanDataObject(Instance originalInstance, String key, Database database) {
        this.database = database;
        this.key = key;
        this.instance = originalInstance;
        this.clusterID = -1;
        this.processed = false;
        this.c_dist = 2.147483647E9;
        this.r_dist = 2.147483647E9;
    }

    @Override
    public boolean equals(DataObject dataObject) {
        if (this == dataObject) {
            return true;
        }
        Instance firstInstance = this.getInstance();
        Instance secondInstance = dataObject.getInstance();
        int firstNumValues = firstInstance.numValues();
        int secondNumValues = secondInstance.numValues();
        int numAttributes = firstInstance.numAttributes();
        int p1 = 0;
        int p2 = 0;
        while (p1 < firstNumValues || p2 < secondNumValues) {
            int secondI;
            int firstI = p1 >= firstNumValues ? numAttributes : firstInstance.index(p1);
            if (firstI == (secondI = p2 >= secondNumValues ? numAttributes : secondInstance.index(p2))) {
                if (firstInstance.valueSparse(p1) != secondInstance.valueSparse(p2)) {
                    return false;
                }
                ++p1;
                ++p2;
                continue;
            }
            if (firstI > secondI) {
                if (0.0 != secondInstance.valueSparse(p2)) {
                    return false;
                }
                ++p2;
                continue;
            }
            if (0.0 != firstInstance.valueSparse(p1)) {
                return false;
            }
            ++p1;
        }
        return true;
    }

    @Override
    public double distance(DataObject dataObject) {
        double dist = 0.0;
        Instance firstInstance = this.getInstance();
        Instance secondInstance = dataObject.getInstance();
        int firstNumValues = firstInstance.numValues();
        int secondNumValues = secondInstance.numValues();
        int numAttributes = firstInstance.numAttributes();
        int p1 = 0;
        int p2 = 0;
        while (p1 < firstNumValues || p2 < secondNumValues) {
            int firstI = p1 >= firstNumValues ? numAttributes : firstInstance.index(p1);
            int secondI = p2 >= secondNumValues ? numAttributes : secondInstance.index(p2);
            double cDistance = 0.0;
            if (firstI == secondI) {
                cDistance = this.computeDistance(firstI, firstInstance.valueSparse(p1), secondInstance.valueSparse(p2));
                ++p1;
                ++p2;
            } else if (firstI > secondI) {
                cDistance = this.computeDistance(secondI, 0.0, secondInstance.valueSparse(p2));
                ++p2;
            } else {
                cDistance = this.computeDistance(firstI, firstInstance.valueSparse(p1), 0.0);
                ++p1;
            }
            dist += Math.abs(cDistance);
        }
        return dist;
    }

    private double computeDistance(int index, double v, double v1) {
        switch (this.getInstance().attribute(index).type()) {
            case 1: {
                return Instance.isMissingValue(v) || Instance.isMissingValue(v1) || (int)v != (int)v1 ? 1 : 0;
            }
            case 0: {
                if (Instance.isMissingValue(v) || Instance.isMissingValue(v1)) {
                    if (Instance.isMissingValue(v) && Instance.isMissingValue(v1)) {
                        return 1.0;
                    }
                    return Instance.isMissingValue(v) ? this.norm(v1, index) : this.norm(v, index);
                }
                return this.norm(v, index) - this.norm(v1, index);
            }
        }
        return 0.0;
    }

    private double norm(double x, int i) {
        if (Double.isNaN(this.database.getAttributeMinValues()[i]) || Utils.eq(this.database.getAttributeMaxValues()[i], this.database.getAttributeMinValues()[i])) {
            return 0.0;
        }
        return (x - this.database.getAttributeMinValues()[i]) / (this.database.getAttributeMaxValues()[i] - this.database.getAttributeMinValues()[i]);
    }

    @Override
    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public void setClusterLabel(int clusterID) {
        this.clusterID = clusterID;
    }

    @Override
    public int getClusterLabel() {
        return this.clusterID;
    }

    @Override
    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    @Override
    public boolean isProcessed() {
        return this.processed;
    }

    @Override
    public void setCoreDistance(double c_dist) {
        this.c_dist = c_dist;
    }

    @Override
    public double getCoreDistance() {
        return this.c_dist;
    }

    @Override
    public void setReachabilityDistance(double r_dist) {
        this.r_dist = r_dist;
    }

    @Override
    public double getReachabilityDistance() {
        return this.r_dist;
    }

    public String toString() {
        return this.instance.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10571 $");
    }
}

