/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48Consolidated;

import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class InstancesConsolidated
extends Instances {
    private static final long serialVersionUID = 8452710983684965074L;

    public InstancesConsolidated(Instances dataset) {
        super(dataset);
    }

    public InstancesConsolidated(Instances source, int first, int toCopy) {
        super(source, first, toCopy);
    }

    public InstancesConsolidated[] getClasses() {
        int numClasses = this.numClasses();
        InstancesConsolidated[] classesVector = new InstancesConsolidated[numClasses];
        this.sort(this.classIndex());
        int[] classIndices = this.getClassIndices();
        int iClass = 0;
        while (iClass < numClasses) {
            int classSize = iClass == numClasses - 1 ? this.numInstances() - classIndices[iClass] : classIndices[iClass + 1] - classIndices[iClass];
            classesVector[iClass] = new InstancesConsolidated(this, classIndices[iClass], classSize);
            ++iClass;
        }
        classIndices = null;
        return classesVector;
    }

    private int[] getClassIndices() {
        int[] classIndices = new int[this.numClasses() + 1];
        int currentClass = 0;
        classIndices[currentClass] = 0;
        int i = 0;
        while (i < this.numInstances()) {
            int j;
            Instance current = this.instance(i);
            if (current.classIsMissing()) {
                j = currentClass + 1;
                while (j < classIndices.length) {
                    classIndices[j] = i;
                    ++j;
                }
                break;
            }
            if (current.classValue() != (double)currentClass) {
                j = currentClass + 1;
                while ((double)j <= current.classValue()) {
                    classIndices[j] = i;
                    ++j;
                }
                currentClass = (int)current.classValue();
            }
            ++i;
        }
        if (currentClass <= this.numClasses()) {
            int j = currentClass + 1;
            while (j < classIndices.length) {
                classIndices[j] = this.numInstances();
                ++j;
            }
        }
        return classIndices;
    }

    public int[] getClassesSize(InstancesConsolidated[] classesVector) {
        int numClasses = this.numClasses();
        int[] classSizeVector = new int[numClasses];
        int iClass = 0;
        while (iClass < numClasses) {
            classSizeVector[iClass] = classesVector[iClass].numInstances();
            ++iClass;
        }
        return classSizeVector;
    }

    public void add(InstancesConsolidated instances) {
        int i = 0;
        while (i < instances.numInstances()) {
            this.add(instances.instance(i));
            ++i;
        }
    }

    public void printClassesInformation(int dataSize, int iMinClass, int[] classSizeVector) {
        int numClasses = this.numClasses();
        System.out.println("Minority class value (" + iMinClass + "): " + this.classAttribute().value(iMinClass));
        System.out.println("Classes sizes:");
        int iClass = 0;
        while (iClass < numClasses) {
            float distrClass = dataSize == 0 ? 0.0f : 100.0f * (float)classSizeVector[iClass] / (float)dataSize;
            System.out.print(String.valueOf(classSizeVector[iClass]) + " (" + Utils.doubleToString(distrClass, 2) + "%)");
            if (iClass < numClasses - 1) {
                System.out.print(", ");
            }
            ++iClass;
        }
        System.out.println("");
    }
}

