/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Sourcable;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.C45PruneableClassifierTree;
import weka.classifiers.trees.j48Consolidated.C45ConsolidatedModelSelection;
import weka.classifiers.trees.j48Consolidated.C45ConsolidatedPruneableClassifierTree;
import weka.classifiers.trees.j48Consolidated.InstancesConsolidated;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instances;
import weka.core.Matchable;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Summarizable;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class J48Consolidated
extends J48
implements OptionHandler,
Drawable,
Matchable,
Sourcable,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = -2647522302468491144L;
    private static float m_coveragePercent = 99.0f;
    int m_numberSamplesByCoverage = 0;
    private double m_trueCoverage;
    private static int m_bagSizePercentToReduce = 75;
    private static float m_minExamplesPerClassPercent = 2.0f;
    String m_stExceptionalSituationsMessage = "";
    public static final int NumberSamples_FixedValue = 1;
    public static final int NumberSamples_BasedOnCoverage = 2;
    public static final Tag[] TAGS_WAYS_TO_SET_NUMBER_SAMPLES = new Tag[]{new Tag(1, "using a fixed value"), new Tag(2, "based on a coverage value (%)")};
    private int m_RMnumberSamplesHowToSet = 2;
    private float m_RMnumberSamples = m_coveragePercent;
    private boolean m_RMreplacement = false;
    private int m_RMbagSizePercent = -2;
    private float m_RMnewDistrMinClass = 50.0f;

    @Override
    public String globalInfo() {
        return "Class for generating a pruned or unpruned C45 consolidated tree. Uses the Consolidated Tree Construction (CTC) algorithm: a single tree is built based on a set of subsamples. New options are added to the J48 class to set the Resampling Method (RM) for the generation of samples to be used in the consolidation process.\nRecently, a new way has been added to determine the number of samples to be used in the consolidation process which guarantees the minimum percentage, the coverage value, of the examples of the original sample to be contained by the set of built subsamples. For more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jes\u00fas M. P\u00e9rez and Javier Muguerza and Olatz Arbelaitz and Ibai Gurrutxaga and Jos\u00e9 I. Mart\u00ed\u00adn");
        result.setValue(TechnicalInformation.Field.YEAR, "2007");
        result.setValue(TechnicalInformation.Field.TITLE, "Combining multiple class distribution modified subsamples in a single tree");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Recognition Letters");
        result.setValue(TechnicalInformation.Field.VOLUME, "28");
        result.setValue(TechnicalInformation.Field.NUMBER, "4");
        result.setValue(TechnicalInformation.Field.PAGES, "414-422");
        result.setValue(TechnicalInformation.Field.URL, "http://dx.doi.org/10.1016/j.patrec.2006.08.013");
        TechnicalInformation additional = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Igor Ibarguren and Jes\u00fas M. P\u00e9rez and Javier Muguerza and Ibai Gurrutxaga and Olatz Arbelaitz");
        additional.setValue(TechnicalInformation.Field.YEAR, "2014");
        additional.setValue(TechnicalInformation.Field.TITLE, "An extensive analysis of consolidated trees' robustness using a new resampling strategy on multiple classification contexts againsts a wide set of rule induction algorithms");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Knowledge Based Systems (submitted)");
        result.add(additional);
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result;
        try {
            result = new C45PruneableClassifierTree(null, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup).getCapabilities();
        }
        catch (Exception e) {
            result = new Capabilities(this);
        }
        result.setOwner(this);
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        C45ConsolidatedModelSelection modSelection = new C45ConsolidatedModelSelection(this.m_minNumObj, instances);
        this.m_root = new C45ConsolidatedPruneableClassifierTree(modSelection, !this.m_unpruned, this.m_CF, this.m_subtreeRaising, !this.m_noCleanup);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        Instances[] samplesVector = this.generateSamples(instances);
        ((C45ConsolidatedPruneableClassifierTree)this.m_root).buildClassifier(instances, samplesVector);
        ((C45ModelSelection)modSelection).cleanup();
    }

    protected Instances[] generateSamples(Instances instances) throws Exception {
        int dataSize;
        Instances[] samplesVector = null;
        this.getCapabilities().testWithFail(instances);
        InstancesConsolidated instancesWMC = new InstancesConsolidated(instances);
        instancesWMC.deleteWithMissingClass();
        if (this.m_Debug) {
            System.out.println("=== Generation of the set of samples ===");
            System.out.println(this.toStringResamplingMethod());
        }
        if ((dataSize = instancesWMC.numInstances()) == 0) {
            System.err.println("Original data size is 0! Handle zero training instances!");
        } else if (this.m_Debug) {
            System.out.println("Original data size: " + dataSize);
        }
        int bagSize = 0;
        if (this.m_RMbagSizePercent >= 0) {
            bagSize = dataSize * this.m_RMbagSizePercent / 100;
            if (bagSize == 0) {
                System.err.println("Size of samples is 0 (" + this.m_RMbagSizePercent + "% of " + dataSize + ")! Handle zero training instances!");
            }
        } else if (this.m_RMnewDistrMinClass < 0.0f) {
            throw new Exception("Size of samples, m_RMbagSizePercent, (" + this.m_RMbagSizePercent + ") has to be between 0 and 100, when m_RMnewDistrMinClass < 0 (stratified or free)!!!");
        }
        Random random = dataSize == 0 ? new Random(this.m_Seed) : instancesWMC.getRandomNumberGenerator(this.m_Seed);
        samplesVector = this.m_RMnewDistrMinClass == -2.0f ? this.generateStratifiedSamples(instancesWMC, dataSize, bagSize, random) : (this.m_RMnewDistrMinClass == -1.0f ? this.generateFreeDistrSamples(instancesWMC, dataSize, bagSize, random) : this.generateSamplesChangingMinClassDistr(instancesWMC, dataSize, bagSize, random));
        if (this.m_Debug) {
            System.out.println("=== End of Generation of the set of samples ===");
        }
        return samplesVector;
    }

    private Instances[] generateStratifiedSamples(InstancesConsolidated instances, int dataSize, int bagSize, Random random) throws Exception {
        int numberSamples;
        int bagSizePercent;
        int numClasses = instances.numClasses();
        InstancesConsolidated[] classesVector = instances.getClasses();
        int[] classSizeVector = instances.getClassesSize(classesVector);
        int iMinClass = Utils.minIndex(classSizeVector);
        if (this.m_Debug) {
            instances.printClassesInformation(dataSize, iMinClass, classSizeVector);
        }
        int[] newClassSizeVector = new int[numClasses];
        if (dataSize == bagSize && !this.m_RMreplacement) {
            System.out.println("It doesn't make sense that the original sample's size and the size of samples to be generated are the same without using replacementbecause all the samples will be entirely equal!!!\n" + m_bagSizePercentToReduce + "% will be used as the bag size percentage!!!");
            bagSizePercent = m_bagSizePercentToReduce;
            bagSize = dataSize * m_bagSizePercentToReduce / 100;
        } else {
            bagSizePercent = this.m_RMbagSizePercent;
        }
        int localBagSize = 0;
        int iClass = 0;
        while (iClass < numClasses) {
            if (iClass != iMinClass) {
                int newClassSize;
                newClassSizeVector[iClass] = newClassSize = Utils.round((double)classSizeVector[iClass] * (double)bagSizePercent / 100.0);
                localBagSize += newClassSize;
            }
            ++iClass;
        }
        newClassSizeVector[iMinClass] = bagSize - localBagSize;
        if (this.m_Debug) {
            System.out.println("New bag size: " + bagSize);
            System.out.println("Classes sizes of the new bag:");
            iClass = 0;
            while (iClass < numClasses) {
                System.out.print(newClassSizeVector[iClass]);
                if (iClass < numClasses - 1) {
                    System.out.print(", ");
                }
                ++iClass;
            }
            System.out.println("");
        }
        double[] bagBySampleClassRatioVector = new double[numClasses];
        int iClass2 = 0;
        while (iClass2 < numClasses) {
            bagBySampleClassRatioVector[iClass2] = classSizeVector[iClass2] > 0 ? (double)newClassSizeVector[iClass2] / (double)classSizeVector[iClass2] : Double.MAX_VALUE;
            ++iClass2;
        }
        if (this.m_RMnumberSamplesHowToSet == 2) {
            double coverage = (double)this.m_RMnumberSamples / 100.0;
            int iMostDisfavorClass = Utils.minIndex(bagBySampleClassRatioVector);
            if (this.m_Debug) {
                System.out.println("Ratio bag:sample by each class:");
                System.out.println("(*) The most disfavored class based on coverage");
                int iClass3 = 0;
                while (iClass3 < numClasses) {
                    System.out.print(Utils.doubleToString(bagBySampleClassRatioVector[iClass3], 2));
                    if (iClass3 == iMostDisfavorClass) {
                        System.out.print("(*)");
                    }
                    if (iClass3 < numClasses - 1) {
                        System.out.print(", ");
                    }
                    ++iClass3;
                }
                System.out.println("");
            }
            numberSamples = this.m_RMreplacement ? (int)Math.ceil(-1.0 * Math.log(1.0 - coverage) / bagBySampleClassRatioVector[iMostDisfavorClass]) : (int)Math.ceil(Math.log(1.0 - coverage) / Math.log(1.0 - bagBySampleClassRatioVector[iMostDisfavorClass]));
            System.out.println("The number of samples to guarantee at least a coverage of " + Utils.doubleToString(100.0 * coverage, 0) + "% is " + numberSamples + ".");
            this.m_numberSamplesByCoverage = numberSamples;
            if (numberSamples < 3) {
                numberSamples = 3;
                System.out.println("(*) Forced the number of samples to be 3!!!");
                this.m_stExceptionalSituationsMessage = String.valueOf(this.m_stExceptionalSituationsMessage) + " (*) Forced the number of samples to be 3!!!\n";
            }
        } else {
            numberSamples = (int)this.m_RMnumberSamples;
        }
        this.m_trueCoverage = 0.0;
        iClass = 0;
        while (iClass < numClasses) {
            double trueCoverageByClass = classSizeVector[iClass] > 0 ? (this.m_RMreplacement ? 1.0 - Math.pow(Math.E, -1.0 * bagBySampleClassRatioVector[iClass] * (double)numberSamples) : 1.0 - Math.pow(1.0 - bagBySampleClassRatioVector[iClass], numberSamples)) : 0.0;
            double ratioClassDistr = (double)classSizeVector[iClass] / (double)dataSize;
            this.m_trueCoverage += ratioClassDistr * trueCoverageByClass;
            ++iClass;
        }
        Instances[] samplesVector = new Instances[numberSamples];
        int iSample = 0;
        while (iSample < numberSamples) {
            Instances bagData = null;
            InstancesConsolidated bagClass = null;
            int iClass4 = 0;
            while (iClass4 < numClasses) {
                bagClass = this.m_RMreplacement ? new InstancesConsolidated(classesVector[iClass4].resampleWithWeights(random)) : new InstancesConsolidated(classesVector[iClass4]);
                bagClass.randomize(random);
                if (newClassSizeVector[iClass4] < classSizeVector[iClass4]) {
                    InstancesConsolidated newBagData;
                    bagClass = newBagData = new InstancesConsolidated(bagClass, 0, newClassSizeVector[iClass4]);
                    newBagData = null;
                }
                if (bagData == null) {
                    bagData = bagClass;
                } else {
                    ((InstancesConsolidated)bagData).add(bagClass);
                }
                bagClass = null;
                ++iClass4;
            }
            bagData.randomize(random);
            samplesVector[iSample] = bagData;
            bagData = null;
            ++iSample;
        }
        classesVector = null;
        classSizeVector = null;
        newClassSizeVector = null;
        return samplesVector;
    }

    private Instances[] generateFreeDistrSamples(InstancesConsolidated instances, int dataSize, int bagSize, Random random) throws Exception {
        int numberSamples;
        if (dataSize == bagSize && !this.m_RMreplacement) {
            System.out.println("It doesn't make sense that the original sample's size and the size of samples to be generated are the same without using replacementbecause all the samples will be entirely equal!!!\n" + m_bagSizePercentToReduce + "% will be used as the bag size percentage!!!");
            bagSize = dataSize * m_bagSizePercentToReduce / 100;
        }
        if (this.m_Debug) {
            System.out.println("New bag size: " + bagSize);
        }
        double bagBySampleRatio = (double)bagSize / (double)dataSize;
        if (this.m_RMnumberSamplesHowToSet == 2) {
            double coverage = (double)this.m_RMnumberSamples / 100.0;
            numberSamples = this.m_RMreplacement ? (int)Math.ceil(-1.0 * Math.log(1.0 - coverage) / bagBySampleRatio) : (int)Math.ceil(Math.log(1.0 - coverage) / Math.log(1.0 - bagBySampleRatio));
            System.out.println("The number of samples to guarantee at least a coverage of " + Utils.doubleToString(100.0 * coverage, 0) + "% is " + numberSamples + ".");
            this.m_numberSamplesByCoverage = numberSamples;
            if (numberSamples < 3) {
                numberSamples = 3;
                System.out.println("(*) Forced the number of samples to be 3!!!");
                this.m_stExceptionalSituationsMessage = String.valueOf(this.m_stExceptionalSituationsMessage) + " (*) Forced the number of samples to be 3!!!\n";
            }
        } else {
            numberSamples = (int)this.m_RMnumberSamples;
        }
        this.m_trueCoverage = this.m_RMreplacement ? 1.0 - Math.pow(Math.E, -1.0 * bagBySampleRatio * (double)numberSamples) : 1.0 - Math.pow(1.0 - bagBySampleRatio, numberSamples);
        Instances[] samplesVector = new Instances[numberSamples];
        int iSample = 0;
        while (iSample < numberSamples) {
            Instances bagData = null;
            bagData = this.m_RMreplacement ? new Instances(instances.resampleWithWeights(random)) : new Instances(instances);
            bagData.randomize(random);
            if (bagSize < dataSize) {
                Instances newBagData;
                bagData = newBagData = new Instances(bagData, 0, bagSize);
                newBagData = null;
            }
            samplesVector[iSample] = bagData;
            bagData = null;
            ++iSample;
        }
        return samplesVector;
    }

    private Instances[] generateSamplesChangingMinClassDistr(InstancesConsolidated instances, int dataSize, int bagSize, Random random) throws Exception {
        int numberSamples;
        int iClass;
        int iClass2;
        int numClasses = instances.numClasses();
        if (numClasses > 2 && this.m_RMnewDistrMinClass != 50.0f) {
            throw new Exception("In the case of multi-class datasets, the only posibility to change the distribution of classes is to balance them!!!\nUse the special value '50.0' in <distribution minority class> for this purpose!!!");
        }
        InstancesConsolidated[] classesVector = instances.getClasses();
        int[] classSizeVector = instances.getClassesSize(classesVector);
        int[] iClassSizeOrdVector = Utils.sort(classSizeVector);
        int i_iMinClass = 0;
        while (i_iMinClass < numClasses && classSizeVector[iClassSizeOrdVector[i_iMinClass]] == 0) {
            ++i_iMinClass;
        }
        int iMinClass = i_iMinClass < numClasses ? iClassSizeOrdVector[i_iMinClass] : 0;
        int iMajClass = Utils.maxIndex(classSizeVector);
        boolean isBalanced = false;
        if (iMinClass == iMajClass) {
            isBalanced = true;
            iMajClass = numClasses - 1;
        }
        if (this.m_Debug) {
            instances.printClassesInformation(dataSize, iMinClass, classSizeVector);
        }
        float distrMinClass = dataSize == 0 ? 0.0f : 100.0f * (float)classSizeVector[iMinClass] / (float)dataSize;
        int minExamplesPerClass = (int)Math.ceil((double)((float)dataSize * m_minExamplesPerClassPercent) / 100.0);
        if (minExamplesPerClass < this.m_minNumObj) {
            minExamplesPerClass = this.m_minNumObj;
        }
        if (this.m_Debug) {
            System.out.println("Minimum number of examples to be guaranteed in each class: " + minExamplesPerClass);
        }
        int iClass3 = 0;
        while (iClass3 < numClasses) {
            if (classSizeVector[iClass3] < minExamplesPerClass && classSizeVector[iClass3] > 0) {
                System.out.println("The " + iClass3 + "-th class has too few examples (" + classSizeVector[iClass3] + ")!!!\n" + "It will be oversampled ranmdoly up to " + minExamplesPerClass + "!!!");
                this.m_stExceptionalSituationsMessage = String.valueOf(this.m_stExceptionalSituationsMessage) + " (*) Forced the " + iClass3 + "-th class to be oversampled!!!\n";
                InstancesConsolidated bagClass = classesVector[iClass3];
                while (bagClass.numInstances() < minExamplesPerClass) {
                    bagClass.add(classesVector[iClass3].instance(random.nextInt(classSizeVector[iClass3])));
                }
                dataSize = dataSize - classSizeVector[iClass3] + minExamplesPerClass;
                classesVector[iClass3] = bagClass;
                classSizeVector[iClass3] = minExamplesPerClass;
            }
            ++iClass3;
        }
        int[] maxClassSizeVector = new int[numClasses];
        if (numClasses == 2) {
            if (this.m_RMnewDistrMinClass > distrMinClass) {
                maxClassSizeVector[iMinClass] = classSizeVector[iMinClass];
                maxClassSizeVector[iMajClass] = Utils.round((float)classSizeVector[iMinClass] * (100.0f - this.m_RMnewDistrMinClass) / this.m_RMnewDistrMinClass);
            } else {
                maxClassSizeVector[iMajClass] = classSizeVector[iMajClass];
                maxClassSizeVector[iMinClass] = Utils.round((float)classSizeVector[iMajClass] * this.m_RMnewDistrMinClass / (100.0f - this.m_RMnewDistrMinClass));
            }
        } else {
            int iClass4 = 0;
            while (iClass4 < numClasses) {
                maxClassSizeVector[iClass4] = classSizeVector[iMinClass];
                ++iClass4;
            }
        }
        int[] newClassSizeVector = new int[numClasses];
        boolean forceToReduceSamplesSize = false;
        if (this.m_RMbagSizePercent == -2) {
            if (numClasses == 2) {
                if (Utils.eq(this.m_RMnewDistrMinClass, distrMinClass)) {
                    System.out.println("It doesn't make sense that the original distribution and the distribution to be changed (RMnewDistrMinClass) are the same and the size of samples to be generated is maximum (RMbagSizePercent=-2) (without using replacement) because all the samples will be entirely equal!!!\n" + m_bagSizePercentToReduce + "% will be used as the bag size percentage!!!");
                    forceToReduceSamplesSize = true;
                }
            } else if (isBalanced) {
                System.out.println("In the case of multi-class datasets, if the original sample is balanced, it doesn't make sense that the size of samples to be generated is maximum (RMbagSizePercent=-2) (without using replacement) because all the samples will be entirely equal!!!\n" + m_bagSizePercentToReduce + "% will be used as the bag size percentage!!!");
                forceToReduceSamplesSize = true;
            }
            if (!forceToReduceSamplesSize) {
                bagSize = 0;
                iClass2 = 0;
                while (iClass2 < numClasses) {
                    if (classSizeVector[iClass2] == 0) {
                        newClassSizeVector[iClass2] = 0;
                    } else {
                        newClassSizeVector[iClass2] = maxClassSizeVector[iClass2];
                        bagSize += maxClassSizeVector[iClass2];
                    }
                    ++iClass2;
                }
            }
        } else if (this.m_RMbagSizePercent == -1) {
            bagSize = classSizeVector[iMinClass];
        } else if (dataSize == bagSize) {
            System.out.println("It doesn't make sense that the original sample's size and the size of samples to be generated are the same(without using replacement) because all the samples will be entirely equal!!!\n" + m_bagSizePercentToReduce + "% will be used as the bag size percentage!!!");
            forceToReduceSamplesSize = true;
        }
        if (this.m_RMbagSizePercent != -2 || forceToReduceSamplesSize) {
            if (numClasses == 2) {
                if (forceToReduceSamplesSize) {
                    bagSize = dataSize * m_bagSizePercentToReduce / 100;
                    this.m_stExceptionalSituationsMessage = String.valueOf(this.m_stExceptionalSituationsMessage) + " (*) Forced to reduce the size of the generated samples!!!\n";
                }
                newClassSizeVector[iMinClass] = Utils.round(this.m_RMnewDistrMinClass * (float)bagSize / 100.0f);
                newClassSizeVector[iMajClass] = bagSize - newClassSizeVector[iMinClass];
            } else {
                int bagSizePercent = this.m_RMbagSizePercent == -1 ? 50 : (forceToReduceSamplesSize ? m_bagSizePercentToReduce : this.m_RMbagSizePercent);
                int classSize = (int)((float)(bagSizePercent * classSizeVector[iMinClass]) / 100.0f);
                bagSize = 0;
                iClass = 0;
                while (iClass < numClasses) {
                    if (classSizeVector[iClass] == 0) {
                        newClassSizeVector[iClass] = 0;
                    } else {
                        newClassSizeVector[iClass] = classSize;
                        bagSize += classSize;
                    }
                    ++iClass;
                }
            }
        }
        if (this.m_Debug) {
            System.out.println("New bag size: " + bagSize);
            System.out.println("New minority class size: " + newClassSizeVector[iMinClass] + " (" + (int)((double)newClassSizeVector[iMinClass] / (double)bagSize * 100.0) + "%)");
            System.out.print("New majority class size: " + newClassSizeVector[iMajClass]);
            if (numClasses > 2) {
                System.out.print(" (" + (int)((double)newClassSizeVector[iMajClass] / (double)bagSize * 100.0) + "%)");
            }
            System.out.println();
        }
        iClass2 = 0;
        while (iClass2 < numClasses) {
            if (newClassSizeVector[iClass2] > classSizeVector[iClass2]) {
                throw new Exception("There aren't enough instances of the " + iClass2 + "-th class (" + classSizeVector[iClass2] + ") to extract " + newClassSizeVector[iClass2] + " for the new samples whithout replacement!!!");
            }
            ++iClass2;
        }
        double[] bagBySampleClassRatioVector = new double[numClasses];
        iClass = 0;
        while (iClass < numClasses) {
            bagBySampleClassRatioVector[iClass] = classSizeVector[iClass] > 0 ? (double)newClassSizeVector[iClass] / (double)classSizeVector[iClass] : Double.MAX_VALUE;
            ++iClass;
        }
        if (this.m_RMnumberSamplesHowToSet == 2) {
            double coverage = (double)this.m_RMnumberSamples / 100.0;
            int iMostDisfavorClass = Utils.minIndex(bagBySampleClassRatioVector);
            if (this.m_Debug) {
                System.out.println("Ratio bag:sample by each class:");
                System.out.println("(*) The most disfavored class based on coverage");
                int iClass5 = 0;
                while (iClass5 < numClasses) {
                    System.out.print(Utils.doubleToString(bagBySampleClassRatioVector[iClass5], 2));
                    if (iClass5 == iMostDisfavorClass) {
                        System.out.print("(*)");
                    }
                    if (iClass5 < numClasses - 1) {
                        System.out.print(", ");
                    }
                    ++iClass5;
                }
                System.out.println("");
            }
            numberSamples = (int)Math.ceil(Math.log(1.0 - coverage) / Math.log(1.0 - bagBySampleClassRatioVector[iMostDisfavorClass]));
            System.out.println("The number of samples to guarantee at least a coverage of " + Utils.doubleToString(100.0 * coverage, 0) + "% is " + numberSamples + ".");
            this.m_numberSamplesByCoverage = numberSamples;
            if (numberSamples < 3) {
                numberSamples = 3;
                System.out.println("(*) Forced the number of samples to be 3!!!");
                this.m_stExceptionalSituationsMessage = String.valueOf(this.m_stExceptionalSituationsMessage) + " (*) Forced the number of samples to be 3!!!\n";
            }
        } else {
            numberSamples = (int)this.m_RMnumberSamples;
        }
        this.m_trueCoverage = 0.0;
        iClass = 0;
        while (iClass < numClasses) {
            double trueCoverageByClass = classSizeVector[iClass] > 0 ? (this.m_RMreplacement ? 1.0 - Math.pow(Math.E, -1.0 * bagBySampleClassRatioVector[iClass] * (double)numberSamples) : 1.0 - Math.pow(1.0 - bagBySampleClassRatioVector[iClass], numberSamples)) : 0.0;
            double ratioClassDistr = (double)classSizeVector[iClass] / (double)dataSize;
            this.m_trueCoverage += ratioClassDistr * trueCoverageByClass;
            ++iClass;
        }
        Instances[] samplesVector = new Instances[numberSamples];
        int iSample = 0;
        while (iSample < numberSamples) {
            InstancesConsolidated bagData = null;
            InstancesConsolidated bagClass = null;
            int iClass6 = 0;
            while (iClass6 < numClasses) {
                if (classSizeVector[iClass6] > 0) {
                    bagClass = new InstancesConsolidated(classesVector[iClass6]);
                    bagClass.randomize(random);
                    if (newClassSizeVector[iClass6] < classSizeVector[iClass6]) {
                        InstancesConsolidated newBagData;
                        bagClass = newBagData = new InstancesConsolidated(bagClass, 0, newClassSizeVector[iClass6]);
                        newBagData = null;
                    }
                    if (bagData == null) {
                        bagData = bagClass;
                    } else {
                        bagData.add(bagClass);
                    }
                    bagClass = null;
                }
                ++iClass6;
            }
            if (bagData == null) {
                bagData = instances;
            } else {
                bagData.randomize(random);
            }
            samplesVector[iSample] = bagData;
            bagData = null;
            ++iSample;
        }
        classesVector = null;
        classSizeVector = null;
        maxClassSizeVector = null;
        newClassSizeVector = null;
        return samplesVector;
    }

    protected void printSamplesVector(Instances[] samplesVector) {
        int iSample = 0;
        while (iSample < samplesVector.length) {
            System.out.println("==== SAMPLE " + iSample + " ====");
            System.out.println(samplesVector[iSample]);
            System.out.println(" ");
            ++iSample;
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            newVector.addElement((Option)en.nextElement());
        }
        newVector.addElement(new Option("\tSet the number of samples to be generated based on a coverage value\n\tas a percentage (by default)", "RM-C", 0, "-RM-C"));
        newVector.addElement(new Option("\tNumber of samples to be generated for the use in the construction of the\n\tconsolidated tree.\n\tIt can be set as a fixed value or based on a coverage value as a percentage, \n\twhen -RM-C option is used, which guarantees the number of samples necessary \n\tto adequately cover the examples of the original sample.\n\t(default: 5 for a fixed value and \n\t " + Utils.doubleToString(m_coveragePercent, 0) + "% for the case based on a coverage value)", "RM-N", 1, "-RM-N <Number of samples>"));
        newVector.addElement(new Option("\tUse replacement to generate the set of samples\n\t(default false)", "RM-R", 0, "-RM-R"));
        newVector.addElement(new Option("\tSize of each sample(bag), as a percentage of the training set size.\n\tCombined with the option <distribution minority class> accepts:\n\t * -1 (sizeOfMinClass): The size of the minority class\n\t * -2 (maxSize): Maximum size taking <distribution minority class>\n\t             into account and using no replacement\n\t(default -2(maxSize))", "RM-B", 1, "-RM-B <Size of each sample(%)>"));
        newVector.addElement(new Option("\tDetermines the new value of the distribution of the minority class.\n\tIt can be one of the following values:\n\t * A value between 0 and 100 to change the portion of minority class\n\t              instances in the new samples\n\t   (If the dataset is multi-class, only the special value 50.0 will\n\t              be accepted to balance the classes)\n\t * -1 (free): Works with the instances without taking their class\n\t              into account\n\t * -2 (stratified): Maintains the original class distribution in the\n\t              new samples\n\t(default 50.0)", "RM-D", 1, "-RM-D <distribution minority class>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        if (Utils.getFlag("RM-C", options)) {
            this.setRMnumberSamplesHowToSet(new SelectedTag(2, TAGS_WAYS_TO_SET_NUMBER_SAMPLES));
        } else {
            this.setRMnumberSamplesHowToSet(new SelectedTag(1, TAGS_WAYS_TO_SET_NUMBER_SAMPLES));
        }
        String RMnumberSamplesString = Utils.getOption("RM-N", options);
        if (RMnumberSamplesString.length() != 0) {
            this.setRMnumberSamples(new Float(RMnumberSamplesString).floatValue());
        } else if (this.m_RMnumberSamplesHowToSet == 2) {
            this.setRMnumberSamples(m_coveragePercent);
        } else {
            this.setRMnumberSamples(5.0f);
        }
        String RMbagSizePercentString = Utils.getOption("RM-B", options);
        if (RMbagSizePercentString.length() != 0) {
            this.setRMbagSizePercent(Integer.parseInt(RMbagSizePercentString), false);
        } else {
            this.setRMbagSizePercent(-2, false);
        }
        String RMnewDistrMinClassString = Utils.getOption("RM-D", options);
        if (RMnewDistrMinClassString.length() != 0) {
            this.setRMnewDistrMinClass(new Float(RMnewDistrMinClassString).floatValue(), false);
        } else {
            this.setRMnewDistrMinClass(50.0f, false);
        }
        this.setRMreplacement(Utils.getFlag("RM-R", options), true);
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-Q");
        result.add("" + this.m_Seed);
        if (this.m_RMnumberSamplesHowToSet == 2) {
            result.add("-RM-C");
        }
        result.add("-RM-N");
        result.add("" + this.m_RMnumberSamples);
        if (this.m_RMreplacement) {
            result.add("-RM-R");
        }
        result.add("-RM-B");
        result.add("" + this.m_RMbagSizePercent);
        result.add("-RM-D");
        result.add("" + this.m_RMnewDistrMinClass);
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        if (this.m_unpruned) {
            return "J48Consolidated unpruned tree\n" + this.toStringResamplingMethod() + this.m_root.toString();
        }
        return "J48Consolidated pruned tree\n" + this.toStringResamplingMethod() + this.m_root.toString();
    }

    public String toStringResamplingMethod() {
        String st = "[RM] N_S=";
        if (this.m_RMnumberSamplesHowToSet == 2) {
            st = String.valueOf(st) + "f(" + Utils.doubleToString(this.m_RMnumberSamples, 2) + "% of coverage)";
            if (this.m_numberSamplesByCoverage != 0) {
                st = String.valueOf(st) + "=" + this.m_numberSamplesByCoverage;
            }
        } else {
            st = String.valueOf(st) + (int)this.m_RMnumberSamples;
        }
        if (this.m_RMnewDistrMinClass == -2.0f) {
            st = String.valueOf(st) + " stratified";
        } else if (this.m_RMnewDistrMinClass == -1.0f) {
            st = String.valueOf(st) + " free distribution";
        } else {
            st = String.valueOf(st) + " %Min=";
            st = Utils.eq(this.m_RMnewDistrMinClass, 50.0) ? String.valueOf(st) + "balanced" : String.valueOf(st) + this.m_RMnewDistrMinClass;
        }
        st = String.valueOf(st) + " Size=";
        st = this.m_RMbagSizePercent == -2 ? String.valueOf(st) + "maxSize" : (this.m_RMbagSizePercent == -1 ? String.valueOf(st) + "sizeOfMinClass" : String.valueOf(st) + this.m_RMbagSizePercent + "%");
        st = this.m_RMreplacement ? String.valueOf(st) + " (with replacement)" : String.valueOf(st) + " (without replacement)";
        st = String.valueOf(st) + "\n";
        st = String.valueOf(st) + this.m_stExceptionalSituationsMessage;
        st = String.valueOf(st) + "True coverage achieved: " + this.m_trueCoverage + "\n";
        char[] ch_line = new char[st.length()];
        int i = 0;
        while (i < ch_line.length) {
            ch_line[i] = 45;
            ++i;
        }
        String line = String.valueOf(ch_line);
        line = String.valueOf(line) + "\n";
        st = String.valueOf(st) + line;
        return st;
    }

    public String RMnumberSamplesHowToSetTipText() {
        return "Way to set the number of samples to be generated:\n * using a fixed value which directly indicates the number of samples to be generated\n * based on a coverage value as a percentage (by default)\n";
    }

    public SelectedTag getRMnumberSamplesHowToSet() {
        return new SelectedTag(this.m_RMnumberSamplesHowToSet, TAGS_WAYS_TO_SET_NUMBER_SAMPLES);
    }

    public void setRMnumberSamplesHowToSet(SelectedTag newWayToSetNumberSamples) throws Exception {
        if (newWayToSetNumberSamples.getTags() == TAGS_WAYS_TO_SET_NUMBER_SAMPLES) {
            int newEvWay = newWayToSetNumberSamples.getSelectedTag().getID();
            if (newEvWay == 1 || newEvWay == 2) {
                this.m_RMnumberSamplesHowToSet = newEvWay;
            } else {
                throw new IllegalArgumentException("Wrong selection type, value should be: between 1 and 2");
            }
        }
    }

    public String RMnumberSamplesTipText() {
        return "Number of samples to be generated for the use in the consolidation process (fixed value) or based on a coverage value as a %.\n * if RMnumberSamplesHowToSet == " + new SelectedTag(1, TAGS_WAYS_TO_SET_NUMBER_SAMPLES).getSelectedTag().getReadable() + "\n" + "    A positive value which directly indicates the number of samples to be generated\n" + " * if RMnumberSamplesHowToSet == " + new SelectedTag(2, TAGS_WAYS_TO_SET_NUMBER_SAMPLES).getSelectedTag().getReadable() + "\n" + "    A positive value as a percentage, the coverage value, which guarantees the number of samples necessary\n" + "    to adequately cover the examples of the original sample\n" + " (default: 5 for a fixed value or " + Utils.doubleToString(m_coveragePercent, 0) + "% for the case based on a coverage value)";
    }

    public float getRMnumberSamples() {
        return this.m_RMnumberSamples;
    }

    public void setRMnumberSamples(float v) throws Exception {
        if (this.m_RMnumberSamplesHowToSet == 1) {
            if (v < 0.0f) {
                throw new Exception("Number of samples has to be greater than zero!");
            }
            if (v == 0.0f) {
                System.err.println("Number of samples is 0. It doesn't make sense to build a consolidated tree without set of samples. Handle zero training instances!");
            }
            if (v == 1.0f || v == 2.0f) {
                System.out.println("It doesn't make sense to build a consolidated tree with 1 or 2 samples, but it's possible!");
            }
        } else {
            if (v < -1.0f) {
                throw new Exception("Coverage value has to be greater than zero!");
            }
            if (v == 0.0f) {
                System.err.println("Coverage value is 0. It doesn't make sense to build a consolidated tree without set of samples. Handle zero training instances!");
            }
        }
        this.m_RMnumberSamples = v;
    }

    public String RMreplacementTipText() {
        return "Whether replacement is performed to generate the set of samples.";
    }

    public boolean getRMreplacement() {
        return this.m_RMreplacement;
    }

    public void setRMreplacement(boolean v) throws Exception {
        this.setRMreplacement(v, true);
    }

    public void setRMreplacement(boolean v, boolean checkComb) throws Exception {
        if (checkComb) {
            this.checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(v, this.m_RMbagSizePercent, this.m_RMnewDistrMinClass);
        }
        this.m_RMreplacement = v;
    }

    public String RMbagSizePercentTipText() {
        return "Size of each sample(bag), as a percentage of the training set size/-1=sizeOfMinClass/-2=maxSize.\nCombined with the option <distribution minority class>, RMnewDistrMinClass, accepts:\n * -1 (sizeOfMinClass): The size of the minority class\n * -2 (maxSize): Maximum size taking <distribution minority class> into account\n             and using no replacement. (default: -2 (maxSize))";
    }

    public int getRMbagSizePercent() {
        return this.m_RMbagSizePercent;
    }

    public void setRMbagSizePercent(int v) throws Exception {
        this.setRMbagSizePercent(v, true);
    }

    public void setRMbagSizePercent(int v, boolean checkComb) throws Exception {
        if (v < -2 || v > 100) {
            throw new Exception("Size of sample (%) has to be greater than zero and smaller than or equal to 100 (or combining with the option <distribution minority class> -1 for 'sizeOfMinClass' or -2 for 'maxSize')!");
        }
        if (v == 0) {
            throw new Exception("Size of sample (%) has to be greater than zero and smaller than or equal to 100!");
        }
        if (checkComb) {
            this.checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(this.m_RMreplacement, v, this.m_RMnewDistrMinClass);
        }
        this.m_RMbagSizePercent = v;
    }

    public String RMnewDistrMinClassTipText() {
        return "Determines the new value of the distribution of the minority class, if we want to change it/-1=free/-2=stratified.\nIt can be one of the following values:\n * A value between 0 and 100 to change the portion of minority class instances in the new samples\n   (If the dataset is multi-class, only the special value 50.0 will be accepted to balance the classes)\n * -1 (free): Works with the instances without taking their class into account.\n * -2 (stratified): Maintains the original class distribution in the new samples.\n (default: 50.0)";
    }

    public float getRMnewDistrMinClass() {
        return this.m_RMnewDistrMinClass;
    }

    public void setRMnewDistrMinClass(float v) throws Exception {
        this.setRMnewDistrMinClass(v, true);
    }

    public void setRMnewDistrMinClass(float v, boolean checkComb) throws Exception {
        if (v < -2.0f || v == 0.0f || v >= 100.0f) {
            throw new Exception("Minority class distribution has to be greater than zero and smaller than 100 (or -1 for 'sizeOfMinClass' or -2 for 'maxSize')!");
        }
        if (checkComb) {
            this.checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(this.m_RMreplacement, this.m_RMbagSizePercent, v);
        }
        this.m_RMnewDistrMinClass = v;
    }

    private void checkBagSizePercentAndReplacementAndNewDistrMinClassOptions(boolean replacement, int bagSizePercent, float newDistrMinClass) throws Exception {
        if (newDistrMinClass > 0.0f && newDistrMinClass < 100.0f && replacement) {
            throw new Exception("Using replacement isn't contemplated to change the distribution of minority class!");
        }
        if (newDistrMinClass == -1.0f || newDistrMinClass == -2.0f) {
            if (bagSizePercent < 0) {
                throw new Exception("Size of sample (%) has to be greater than zero and smaller than or equal to 100!");
            }
            if (!replacement && bagSizePercent == 100) {
                System.err.println("It doesn't make sense that size of sample (%) is 100, when replacement is false!");
            }
        }
    }

    @Override
    public String reducedErrorPruningTipText() {
        return "J48 option not implemented for J48Consolidated";
    }

    @Override
    public void setReducedErrorPruning(boolean v) {
        this.m_reducedErrorPruning = false;
        throw new RuntimeException("J48 option not implemented for J48Consolidated");
    }

    @Override
    public String numFoldsTipText() {
        return "J48 option not implemented for J48Consolidated";
    }

    @Override
    public void setNumFolds(int v) {
        this.m_numFolds = 3;
        throw new RuntimeException("J48 option not implemented for J48Consolidated");
    }

    @Override
    public String binarySplitsTipText() {
        return "J48 option not implemented for J48Consolidated";
    }

    @Override
    public void setBinarySplits(boolean v) {
        this.m_binarySplits = false;
        throw new RuntimeException("J48 option not implemented for J48Consolidated");
    }

    @Override
    public String seedTipText() {
        return "Seed for random data shuffling in the generation of samples";
    }

    @Override
    public String toSummaryString() {
        String stNumberSamplesByCoverage = this.m_RMnumberSamplesHowToSet == 2 ? "Number of samples based on coverage: " + this.measureNumberSamplesByCoverage() + "\n" : "";
        return String.valueOf(super.toSummaryString()) + stNumberSamplesByCoverage + "True coverage: " + this.measureTrueCoverage() + "\n";
    }

    public double measureNumberSamplesByCoverage() {
        return this.m_numberSamplesByCoverage;
    }

    public double measureTrueCoverage() {
        return this.m_trueCoverage;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Enumeration enm = super.enumerateMeasures();
        Vector measures = new Vector();
        while (enm.hasMoreElements()) {
            measures.add(enm.nextElement());
        }
        if (this.m_RMnumberSamplesHowToSet == 2) {
            measures.add("measureNumberSamplesByCoverage");
        }
        measures.add("measureTrueCoverage");
        return measures.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureTrueCoverage") == 0) {
            return this.measureTrueCoverage();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureNumberSamplesByCoverage") == 0) {
            return this.measureNumberSamplesByCoverage();
        }
        return super.getMeasure(additionalMeasureName);
    }

    public static void main(String[] argv) {
        J48Consolidated.runClassifier(new J48Consolidated(), argv);
    }
}

