/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.misc;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.misc.SerializedClassifier;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.M5P;
import weka.core.CheckOptionHandler;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.SerializationHelper;
import weka.core.TestInstances;
import weka.test.Regression;

public class SerializedClassifierTest
extends TestCase {
    public static final String MODEL_FILENAME = String.valueOf(System.getProperty("user.dir")) + "/" + "temp.model";
    protected SerializedClassifier m_Classifier;
    protected CheckOptionHandler m_OptionTester;

    public SerializedClassifierTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.m_Classifier = null;
        this.m_OptionTester = new CheckOptionHandler();
        this.m_OptionTester.setSilent(true);
        File file = new File(MODEL_FILENAME);
        if (file.exists()) {
            file.delete();
        }
    }

    @Override
    protected void tearDown() {
        this.m_Classifier = null;
        this.m_OptionTester = null;
        File file = new File(MODEL_FILENAME);
        if (file.exists()) {
            file.delete();
        }
    }

    protected double[] trainAndSerializeClassifier(Instances data) {
        double[] result;
        try {
            Classifier classifier = data.classAttribute().isNominal() ? new J48() : new M5P();
            classifier.buildClassifier(data);
            result = new double[data.numInstances()];
            int i = 0;
            while (i < result.length) {
                result[i] = classifier.classifyInstance(data.instance(i));
                ++i;
            }
            SerializationHelper.write(MODEL_FILENAME, (Object)classifier);
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Training base classifier failed: " + e);
            return null;
        }
        return result;
    }

    protected void performTest(boolean nomClass) {
        double[] originalResults;
        Instances data;
        try {
            TestInstances test = new TestInstances();
            if (nomClass) {
                test.setClassType(1);
                test.setNumNominal(5);
                test.setNumNominalValues(4);
                test.setNumNumeric(0);
            } else {
                test.setClassType(0);
                test.setNumNominal(0);
                test.setNumNumeric(5);
            }
            test.setNumDate(0);
            test.setNumString(0);
            test.setNumRelational(0);
            test.setNumInstances(100);
            data = test.generate();
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Generating test data failed: " + e);
            return;
        }
        try {
            originalResults = this.trainAndSerializeClassifier(data);
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Training base classifier failed: " + e);
            return;
        }
        try {
            this.m_Classifier = new SerializedClassifier();
            this.m_Classifier.setModelFile(new File(MODEL_FILENAME));
            this.m_Classifier.buildClassifier(data);
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Loading/testing of classifier failed: " + e);
        }
        try {
            double[] testResults = new double[data.numInstances()];
            int i = 0;
            while (i < testResults.length) {
                testResults[i] = this.m_Classifier.classifyInstance(data.instance(i));
                ++i;
            }
            i = 0;
            while (i < originalResults.length) {
                if (originalResults[i] != testResults[i]) {
                    throw new Exception("Result #" + (i + 1) + " differs!");
                }
                ++i;
            }
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Comparing results failed: " + e);
        }
    }

    public void testNominalClass() {
        this.performTest(true);
    }

    public void testNumericClass() {
        this.performTest(true);
    }

    protected String predictionsToString(FastVector predictions) {
        StringBuffer sb = new StringBuffer();
        sb.append(predictions.size()).append(" predictions\n");
        int i = 0;
        while (i < predictions.size()) {
            sb.append(predictions.elementAt(i)).append('\n');
            ++i;
        }
        return sb.toString();
    }

    public void testRegression() {
        Instances data;
        Regression reg = new Regression(this.getClass());
        try {
            TestInstances testInst = new TestInstances();
            testInst.setClassType(1);
            testInst.setNumNominal(5);
            testInst.setNumNominalValues(4);
            testInst.setNumNumeric(0);
            testInst.setNumDate(0);
            testInst.setNumString(0);
            testInst.setNumRelational(0);
            testInst.setNumInstances(100);
            data = testInst.generate();
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Failed generating data: " + e);
            return;
        }
        int tot = data.numInstances();
        int mid = tot / 2;
        Instances train = null;
        Instances test = null;
        try {
            train = new Instances(data, 0, mid);
            test = new Instances(data, mid, tot - mid);
            this.m_Classifier = new SerializedClassifier();
            this.m_Classifier.setModelFile(new File(MODEL_FILENAME));
        }
        catch (Exception e) {
            e.printStackTrace();
            SerializedClassifierTest.fail("Problem setting up to use classifier: " + e);
        }
        EvaluationUtils evaluation = new EvaluationUtils();
        try {
            this.trainAndSerializeClassifier(train);
            FastVector regressionResults = evaluation.getTrainTestPredictions(this.m_Classifier, train, test);
            reg.println(this.predictionsToString(regressionResults));
        }
        catch (Exception e) {
            SerializedClassifierTest.fail("Failed obtaining classifier predictions: " + e);
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                SerializedClassifierTest.fail("Regression test failed. Difference:\n" + diff);
            }
        }
        catch (IOException ex) {
            SerializedClassifierTest.fail("Problem during regression testing.\n" + ex);
        }
    }

    public void testListOptions() {
        if (!this.m_OptionTester.checkListOptions()) {
            SerializedClassifierTest.fail("Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            SerializedClassifierTest.fail("setOptions method failed.");
        }
    }

    public void testRemainingOptions() {
        if (!this.m_OptionTester.checkRemainingOptions()) {
            SerializedClassifierTest.fail("There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (!this.m_OptionTester.checkCanonicalUserOptions()) {
            SerializedClassifierTest.fail("setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (!this.m_OptionTester.checkSetOptions()) {
            SerializedClassifierTest.fail("Resetting of options failed");
        }
    }

    public static Test suite() {
        return new TestSuite(SerializedClassifierTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(SerializedClassifierTest.suite());
    }
}

