/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.supportVector;

import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.RevisionUtils;

public class MIPolyKernel
extends PolyKernel
implements MultiInstanceCapabilitiesHandler {
    private static final long serialVersionUID = 7926421479341051777L;

    public MIPolyKernel() {
    }

    public MIPolyKernel(Instances data, int cacheSize, double exponent, boolean lowerOrder) throws Exception {
        super(data, cacheSize, exponent, lowerOrder);
    }

    @Override
    protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
        Instances data1 = new Instances(inst1.relationalValue(1));
        Instances data2 = id1 == id2 ? new Instances(data1) : new Instances(this.m_data.instance(id2).relationalValue(1));
        double res = 0.0;
        int i = 0;
        while (i < data1.numInstances()) {
            int j = 0;
            while (j < data2.numInstances()) {
                double result = this.dotProd(data1.instance(i), data2.instance(j));
                if (this.getUseLowerOrder()) {
                    result += 1.0;
                }
                if (this.getExponent() != 1.0) {
                    result = Math.pow(result, this.getExponent());
                }
                res += result;
                ++j;
            }
            ++i;
        }
        return res;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.disable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void clean() {
        this.m_storage = null;
        this.m_keys = null;
        this.m_kernelMatrix = null;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10036 $");
    }
}

