/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.classifiers.AbstractClassifierTest;
import weka.classifiers.Classifier;
import weka.classifiers.evaluation.EvaluationUtils;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.meta.ThresholdSelector;
import weka.classifiers.meta.ThresholdSelectorDummyClassifier;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.NoSupportForMissingValuesException;
import weka.core.SelectedTag;
import weka.core.UnsupportedAttributeTypeException;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.RemoveType;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class ThresholdSelectorTest
extends AbstractClassifierTest {
    private static double[] DIST1 = new double[]{0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0};
    protected transient Instances m_Instances;
    protected transient EvaluationUtils m_Evaluation;

    public ThresholdSelectorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Evaluation = new EvaluationUtils();
        this.m_Instances = new Instances(new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("weka/classifiers/data/ClassifierTest.arff"))));
    }

    @Override
    public Classifier getClassifier() {
        return this.getClassifier(DIST1);
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        this.m_Evaluation = null;
    }

    public Classifier getClassifier(double[] dist) {
        return this.getClassifier(new ThresholdSelectorDummyClassifier(dist));
    }

    public Classifier getClassifier(Classifier classifier) {
        ThresholdSelector t = new ThresholdSelector();
        t.setClassifier(classifier);
        return t;
    }

    /*
     * Unable to fully structure code
     */
    protected FastVector useClassifier() throws Exception {
        dc = null;
        tot = this.m_Instances.numInstances();
        mid = tot / 2;
        train = null;
        test = null;
        try {
            train = new Instances(this.m_Instances, 0, mid);
            test = new Instances(this.m_Instances, mid, tot - mid);
            dc = this.m_Classifier;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ThresholdSelectorTest.fail("Problem setting up to use classifier: " + ex);
        }
        counter = 0;
        while (true) {
            try {
                return this.m_Evaluation.getTrainTestPredictions(dc, train, test);
            }
            catch (UnsupportedAttributeTypeException ex) {
                tag = null;
                invert = false;
                msg = ex.getMessage();
                if (msg.indexOf("string") != -1 && msg.indexOf("attributes") != -1) {
                    System.err.println("\nDeleting string attributes.");
                    tag = new SelectedTag(2, RemoveType.TAGS_ATTRIBUTETYPE);
                } else if (msg.indexOf("only") != -1 && msg.indexOf("nominal") != -1) {
                    System.err.println("\nDeleting non-nominal attributes.");
                    tag = new SelectedTag(1, RemoveType.TAGS_ATTRIBUTETYPE);
                    invert = true;
                } else if (msg.indexOf("only") != -1 && msg.indexOf("numeric") != -1) {
                    System.err.println("\nDeleting non-numeric attributes.");
                    tag = new SelectedTag(0, RemoveType.TAGS_ATTRIBUTETYPE);
                    invert = true;
                } else {
                    throw ex;
                }
                attFilter = new RemoveType();
                attFilter.setAttributeType(tag);
                attFilter.setInvertSelection(invert);
                attFilter.setInputFormat(train);
                train = Filter.useFilter(train, attFilter);
                attFilter.batchFinished();
                test = Filter.useFilter(test, attFilter);
                if (++counter <= 2) continue;
                throw ex;
            }
            catch (NoSupportForMissingValuesException ex2) {
                System.err.println("\nReplacing missing values.");
                rmFilter = new ReplaceMissingValues();
                rmFilter.setInputFormat(train);
                train = Filter.useFilter(train, rmFilter);
                rmFilter.batchFinished();
                test = Filter.useFilter(test, rmFilter);
                continue;
            }
            catch (IllegalArgumentException ex3) {
                msg = ex3.getMessage();
                if (msg.indexOf("Not enough instances") == -1) break;
                System.err.println("\nInflating training data.");
                trainNew = new Instances(train);
                i = 0;
                ** while (i < train.numInstances())
            }
lbl-1000:
            // 1 sources

            {
                trainNew.add(train.instance(i));
                ++i;
                continue;
            }
lbl68:
            // 1 sources

            train = trainNew;
        }
        throw ex3;
    }

    public void testRangeNone() throws Exception {
        int cind = 0;
        ((ThresholdSelector)this.m_Classifier).setDesignatedClass(new SelectedTag(0, ThresholdSelector.TAGS_OPTIMIZE));
        ((ThresholdSelector)this.m_Classifier).setRangeCorrection(new SelectedTag(0, ThresholdSelector.TAGS_RANGE));
        FastVector result = null;
        this.m_Instances.setClassIndex(1);
        result = this.useClassifier();
        ThresholdSelectorTest.assertTrue(result.size() != 0);
        double minp = 0.0;
        double maxp = 0.0;
        int i = 0;
        while (i < result.size()) {
            NominalPrediction p = (NominalPrediction)result.elementAt(i);
            double prob = p.distribution()[cind];
            if (i == 0 || prob < minp) {
                minp = prob;
            }
            if (i == 0 || prob > maxp) {
                maxp = prob;
            }
            ++i;
        }
        ThresholdSelectorTest.assertTrue("Upper limit shouldn't increase", maxp <= 1.0);
        ThresholdSelectorTest.assertTrue("Lower limit shouldn'd decrease", minp >= 0.25);
    }

    public void testDesignatedClass() throws Exception {
        boolean cind = false;
        int i = 0;
        while (i < ThresholdSelector.TAGS_OPTIMIZE.length) {
            ((ThresholdSelector)this.m_Classifier).setDesignatedClass(new SelectedTag(ThresholdSelector.TAGS_OPTIMIZE[i].getID(), ThresholdSelector.TAGS_OPTIMIZE));
            this.m_Instances.setClassIndex(1);
            FastVector result = this.useClassifier();
            ThresholdSelectorTest.assertTrue(result.size() != 0);
            ++i;
        }
    }

    public void testEvaluationMode() throws Exception {
        boolean cind = false;
        int i = 0;
        while (i < ThresholdSelector.TAGS_EVAL.length) {
            ((ThresholdSelector)this.m_Classifier).setEvaluationMode(new SelectedTag(ThresholdSelector.TAGS_EVAL[i].getID(), ThresholdSelector.TAGS_EVAL));
            this.m_Instances.setClassIndex(1);
            FastVector result = this.useClassifier();
            ThresholdSelectorTest.assertTrue(result.size() != 0);
            ++i;
        }
    }

    public void testNumXValFolds() throws Exception {
        try {
            ((ThresholdSelector)this.m_Classifier).setNumXValFolds(0);
            ThresholdSelectorTest.fail("Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        boolean cind = false;
        int i = 2;
        while (i < 20) {
            ((ThresholdSelector)this.m_Classifier).setNumXValFolds(i);
            this.m_Instances.setClassIndex(1);
            FastVector result = this.useClassifier();
            ThresholdSelectorTest.assertTrue(result.size() != 0);
            i += 2;
        }
    }

    public static Test suite() {
        return new TestSuite(ThresholdSelectorTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(ThresholdSelectorTest.suite());
    }
}

