/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.AttributeTransformer;
import weka.attributeSelection.UnsupervisedAttributeEvaluator;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.core.matrix.SingularValueDecomposition;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.Remove;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class LatentSemanticAnalysis
extends UnsupervisedAttributeEvaluator
implements AttributeTransformer,
OptionHandler {
    static final long serialVersionUID = -8712112988018106198L;
    private Instances m_trainInstances;
    private Instances m_trainHeader;
    private Instances m_transformedFormat;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttributes;
    private int m_numInstances;
    private boolean m_transpose = false;
    private Matrix m_u = null;
    private Matrix m_s = null;
    private Matrix m_v = null;
    private Matrix m_transformationMatrix = null;
    private ReplaceMissingValues m_replaceMissingFilter;
    private Normalize m_normalizeFilter;
    private NominalToBinary m_nominalToBinaryFilter;
    private Remove m_attributeFilter;
    private int m_outputNumAttributes = -1;
    private boolean m_normalize = false;
    private double m_rank = 0.95;
    private double m_sumSquaredSingularValues = 0.0;
    private int m_actualRank = -1;
    private int m_maxAttributesInName = 5;

    public String globalInfo() {
        return "Performs latent semantic analysis and transformation of the data. Use in conjunction with a Ranker search. A low-rank approximation of the full data is found by either specifying the number of singular values to use or specifying a proportion of the singular values to cover.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> options = new Vector<Option>(4);
        options.addElement(new Option("\tNormalize input data.", "N", 0, "-N"));
        options.addElement(new Option("\tRank approximation used in LSA. \n\tMay be actual number of LSA attributes \n\tto include (if greater than 1) or a \n\tproportion of total singular values to \n\taccount for (if between 0 and 1). \n\tA value less than or equal to zero means \n\tuse all latent variables.(default = 0.95)", "R", 1, "-R"));
        options.addElement(new Option("\tMaximum number of attributes to include\n\tin transformed attribute names.\n\t(-1 = include all)", "A", 1, "-A"));
        return options.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        String optionString = Utils.getOption('R', options);
        if (optionString.length() != 0) {
            double temp = Double.valueOf(optionString);
            this.setRank(temp);
        }
        if ((optionString = Utils.getOption('A', options)).length() != 0) {
            this.setMaximumAttributeNames(Integer.parseInt(optionString));
        }
        this.setNormalize(Utils.getFlag('N', options));
    }

    private void resetOptions() {
        this.m_rank = 0.95;
        this.m_normalize = true;
        this.m_maxAttributesInName = 5;
    }

    public String normalizeTipText() {
        return "Normalize input data.";
    }

    public void setNormalize(boolean newNormalize) {
        this.m_normalize = newNormalize;
    }

    public boolean getNormalize() {
        return this.m_normalize;
    }

    public String rankTipText() {
        return "Matrix rank to use for data reduction. Can be a proportion to indicate desired coverage";
    }

    public void setRank(double newRank) {
        this.m_rank = newRank;
    }

    public double getRank() {
        return this.m_rank;
    }

    public String maximumAttributeNamesTipText() {
        return "The maximum number of attributes to include in transformed attribute names.";
    }

    public void setMaximumAttributeNames(int newMaxAttributes) {
        this.m_maxAttributesInName = newMaxAttributes;
    }

    public int getMaximumAttributeNames() {
        return this.m_maxAttributesInName;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[5];
        int current = 0;
        if (this.getNormalize()) {
            options[current++] = "-N";
        }
        options[current++] = "-R";
        options[current++] = "" + this.getRank();
        options[current++] = "-A";
        options[current++] = "" + this.getMaximumAttributeNames();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.buildAttributeConstructor(data);
    }

    private void buildAttributeConstructor(Instances data) throws Exception {
        int i;
        this.m_transpose = false;
        this.m_s = null;
        this.m_u = null;
        this.m_v = null;
        this.m_outputNumAttributes = -1;
        this.m_actualRank = -1;
        this.m_sumSquaredSingularValues = 0.0;
        this.m_trainInstances = new Instances(data);
        this.m_trainHeader = null;
        this.m_attributeFilter = null;
        this.m_nominalToBinaryFilter = null;
        this.m_replaceMissingFilter = new ReplaceMissingValues();
        this.m_replaceMissingFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_replaceMissingFilter);
        Vector<Integer> attributesToRemove = new Vector<Integer>();
        if (this.m_trainInstances.classIndex() >= 0) {
            this.m_hasClass = true;
            this.m_classIndex = this.m_trainInstances.classIndex();
            attributesToRemove.addElement(new Integer(this.m_classIndex));
        }
        this.m_trainHeader = new Instances(this.m_trainInstances, 0);
        if (this.m_normalize) {
            this.m_normalizeFilter = new Normalize();
            this.m_normalizeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_normalizeFilter);
        }
        this.m_nominalToBinaryFilter = new NominalToBinary();
        this.m_nominalToBinaryFilter.setInputFormat(this.m_trainInstances);
        this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_nominalToBinaryFilter);
        int i2 = 0;
        while (i2 < this.m_trainInstances.numAttributes()) {
            if (this.m_trainInstances.numDistinctValues(i2) <= 1) {
                attributesToRemove.addElement(new Integer(i2));
            }
            ++i2;
        }
        if (attributesToRemove.size() > 0) {
            this.m_attributeFilter = new Remove();
            int[] todelete = new int[attributesToRemove.size()];
            i = 0;
            while (i < attributesToRemove.size()) {
                todelete[i] = (Integer)attributesToRemove.elementAt(i);
                ++i;
            }
            this.m_attributeFilter.setAttributeIndicesArray(todelete);
            this.m_attributeFilter.setInvertSelection(false);
            this.m_attributeFilter.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_attributeFilter);
        }
        this.getCapabilities().testWithFail(this.m_trainInstances);
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_numAttributes = this.m_trainInstances.numAttributes();
        double[][] trainValues = new double[this.m_numAttributes][this.m_numInstances];
        i = 0;
        while (i < this.m_numAttributes) {
            trainValues[i] = this.m_trainInstances.attributeToDoubleArray(i);
            ++i;
        }
        Matrix trainMatrix = new Matrix(trainValues);
        if (this.m_numAttributes < this.m_numInstances) {
            this.m_transpose = true;
            trainMatrix = trainMatrix.transpose();
        }
        SingularValueDecomposition trainSVD = trainMatrix.svd();
        this.m_u = trainSVD.getU();
        this.m_s = trainSVD.getS();
        this.m_v = trainSVD.getV();
        int maxSingularValues = trainSVD.rank();
        int i3 = 0;
        while (i3 < this.m_s.getRowDimension()) {
            this.m_sumSquaredSingularValues += this.m_s.get(i3, i3) * this.m_s.get(i3, i3);
            ++i3;
        }
        if (maxSingularValues == 0) {
            this.m_s = null;
            this.m_u = null;
            this.m_v = null;
            this.m_sumSquaredSingularValues = 0.0;
            throw new Exception("SVD computation produced no non-zero singular values.");
        }
        if (this.m_rank > (double)maxSingularValues || this.m_rank <= 0.0) {
            this.m_actualRank = maxSingularValues;
        } else if (this.m_rank < 1.0) {
            double currentSumOfSquaredSingularValues = 0.0;
            int i4 = 0;
            while (i4 < this.m_s.getRowDimension() && this.m_actualRank == -1) {
                if ((currentSumOfSquaredSingularValues += this.m_s.get(i4, i4) * this.m_s.get(i4, i4)) / this.m_sumSquaredSingularValues >= this.m_rank) {
                    this.m_actualRank = i4 + 1;
                }
                ++i4;
            }
        } else {
            this.m_actualRank = (int)this.m_rank;
        }
        if (this.m_transpose) {
            Matrix tempMatrix = this.m_u;
            this.m_u = this.m_v;
            this.m_v = tempMatrix;
        }
        this.m_u = this.m_u.getMatrix(0, this.m_u.getRowDimension() - 1, 0, this.m_actualRank - 1);
        this.m_s = this.m_s.getMatrix(0, this.m_actualRank - 1, 0, this.m_actualRank - 1);
        this.m_v = this.m_v.getMatrix(0, this.m_v.getRowDimension() - 1, 0, this.m_actualRank - 1);
        this.m_transformationMatrix = this.m_u.times(this.m_s.inverse());
        this.m_transformedFormat = this.setOutputFormat();
    }

    private Instances setOutputFormat() {
        if (this.m_s == null) {
            return null;
        }
        this.m_outputNumAttributes = this.m_hasClass ? this.m_actualRank + 1 : this.m_actualRank;
        int numAttributesInName = this.m_maxAttributesInName;
        if (numAttributesInName <= 0 || numAttributesInName >= this.m_numAttributes) {
            numAttributesInName = this.m_numAttributes;
        }
        FastVector attributes = new FastVector(this.m_outputNumAttributes);
        int i = 0;
        while (i < this.m_actualRank) {
            String attributeName = "";
            double[] attributeCoefficients = this.m_transformationMatrix.getMatrix(0, this.m_numAttributes - 1, i, i).getColumnPackedCopy();
            int j = 0;
            while (j < numAttributesInName) {
                if (j > 0) {
                    attributeName = String.valueOf(attributeName) + "+";
                }
                attributeName = String.valueOf(attributeName) + Utils.doubleToString(attributeCoefficients[j], 5, 3);
                attributeName = String.valueOf(attributeName) + this.m_trainInstances.attribute(j).name();
                ++j;
            }
            if (numAttributesInName < this.m_numAttributes) {
                attributeName = String.valueOf(attributeName) + "...";
            }
            attributes.addElement(new Attribute(attributeName));
            ++i;
        }
        if (this.m_hasClass) {
            attributes.addElement(this.m_trainHeader.classAttribute().copy());
        }
        Instances outputFormat = new Instances(String.valueOf(this.m_trainInstances.relationName()) + "_LSA", attributes, 0);
        this.m_outputNumAttributes = outputFormat.numAttributes();
        if (this.m_hasClass) {
            outputFormat.setClassIndex(this.m_outputNumAttributes - 1);
        }
        return outputFormat;
    }

    @Override
    public Instances transformedHeader() throws Exception {
        if (this.m_s == null) {
            throw new Exception("Latent Semantic Analysis hasn't been successfully performed.");
        }
        return this.m_transformedFormat;
    }

    @Override
    public Instances transformedData(Instances data) throws Exception {
        if (this.m_s == null) {
            throw new Exception("Latent Semantic Analysis hasn't been built yet");
        }
        Instances output = new Instances(this.m_transformedFormat, this.m_numInstances);
        int i = 0;
        while (i < data.numInstances()) {
            Instance currentInstance = data.instance(i);
            double[] newValues = new double[this.m_outputNumAttributes];
            int j = 0;
            while (j < this.m_actualRank) {
                newValues[j] = this.m_v.get(i, j);
                ++j;
            }
            if (this.m_hasClass) {
                newValues[this.m_outputNumAttributes - 1] = currentInstance.classValue();
            }
            Instance newInstance = currentInstance instanceof SparseInstance ? new SparseInstance(currentInstance.weight(), newValues) : new Instance(currentInstance.weight(), newValues);
            output.add(newInstance);
            ++i;
        }
        return output;
    }

    @Override
    public double evaluateAttribute(int att) throws Exception {
        if (this.m_s == null) {
            throw new Exception("Latent Semantic Analysis hasn't been successfully performed yet!");
        }
        return this.m_s.get(att, att) * this.m_s.get(att, att) / this.m_sumSquaredSingularValues;
    }

    @Override
    public Instance convertInstance(Instance instance) throws Exception {
        if (this.m_s == null) {
            throw new Exception("convertInstance: Latent Semantic Analysis not performed yet.");
        }
        double[] newValues = new double[this.m_outputNumAttributes];
        Instance tempInstance = (Instance)instance.copy();
        if (!instance.dataset().equalHeaders(this.m_trainHeader)) {
            throw new Exception("Can't convert instance: headers don't match: LatentSemanticAnalysis");
        }
        this.m_replaceMissingFilter.input(tempInstance);
        this.m_replaceMissingFilter.batchFinished();
        tempInstance = this.m_replaceMissingFilter.output();
        if (this.m_normalize) {
            this.m_normalizeFilter.input(tempInstance);
            this.m_normalizeFilter.batchFinished();
            tempInstance = this.m_normalizeFilter.output();
        }
        this.m_nominalToBinaryFilter.input(tempInstance);
        this.m_nominalToBinaryFilter.batchFinished();
        tempInstance = this.m_nominalToBinaryFilter.output();
        if (this.m_attributeFilter != null) {
            this.m_attributeFilter.input(tempInstance);
            this.m_attributeFilter.batchFinished();
            tempInstance = this.m_attributeFilter.output();
        }
        if (this.m_hasClass) {
            newValues[this.m_outputNumAttributes - 1] = instance.classValue();
        }
        double[][] oldInstanceValues = new double[1][this.m_numAttributes];
        oldInstanceValues[0] = tempInstance.toDoubleArray();
        Matrix instanceVector = new Matrix(oldInstanceValues);
        instanceVector = instanceVector.times(this.m_transformationMatrix);
        int i = 0;
        while (i < this.m_actualRank) {
            newValues[i] = instanceVector.get(0, i);
            ++i;
        }
        if (instance instanceof SparseInstance) {
            return new SparseInstance(instance.weight(), newValues);
        }
        return new Instance(instance.weight(), newValues);
    }

    public String toString() {
        if (this.m_s == null) {
            return "Latent Semantic Analysis hasn't been built yet!";
        }
        return "\tLatent Semantic Analysis Attribute Transformer\n\n" + this.lsaSummary();
    }

    private String lsaSummary() {
        int j;
        StringBuffer result = new StringBuffer();
        result.append("Number of latent variables utilized: " + this.m_actualRank);
        result.append("\n\nSingularValue\tLatentVariable#\n");
        int i = 0;
        while (i < this.m_actualRank) {
            result.append(String.valueOf(Utils.doubleToString(this.m_s.get(i, i), 9, 5)) + "\t" + (i + 1) + "\n");
            ++i;
        }
        result.append("\nAttribute vectors (left singular vectors) -- row vectors show\nthe relation between the original attributes and the latent \nvariables computed by the singular value decomposition:\n");
        i = 0;
        while (i < this.m_actualRank) {
            result.append("LatentVariable#" + (i + 1) + "\t");
            ++i;
        }
        result.append("AttributeName\n");
        i = 0;
        while (i < this.m_u.getRowDimension()) {
            j = 0;
            while (j < this.m_u.getColumnDimension()) {
                result.append(String.valueOf(Utils.doubleToString(this.m_u.get(i, j), 9, 5)) + "\t\t");
                ++j;
            }
            result.append(String.valueOf(this.m_trainInstances.attribute(i).name()) + "\n");
            ++i;
        }
        result.append("\n\nInstance vectors (right singular vectors) -- column\nvectors show the relation between the original instances and the\nlatent variables computed by the singular value decomposition:\n");
        i = 0;
        while (i < this.m_numInstances) {
            result.append("Instance#" + (i + 1) + "\t");
            ++i;
        }
        result.append("LatentVariable#\n");
        i = 0;
        while (i < this.m_v.getColumnDimension()) {
            j = 0;
            while (j < this.m_v.getRowDimension()) {
                result.append(String.valueOf(Utils.doubleToString(this.m_v.get(j, i), 9, 5)) + "\t");
                ++j;
            }
            result.append(String.valueOf(i + 1) + "\n");
            ++i;
        }
        return result.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5728 $");
    }

    public static void main(String[] argv) {
        LatentSemanticAnalysis.runEvaluator(new LatentSemanticAnalysis(), argv);
    }
}

