/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;
import weka.filters.unsupervised.attribute.NumericToBinary;

public class InfoGainAttributeEval
extends ASEvaluation
implements AttributeEvaluator,
OptionHandler {
    static final long serialVersionUID = -1949849512589218930L;
    private boolean m_missing_merge;
    private boolean m_Binarize;
    private double[] m_InfoGains;

    public String globalInfo() {
        return "InfoGainAttributeEval :\n\nEvaluates the worth of an attribute by measuring the information gain with respect to the class.\n\nInfoGain(Class,Attribute) = H(Class) - H(Class | Attribute).\n";
    }

    public InfoGainAttributeEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\ttreat missing values as a seperate value.", "M", 0, "-M"));
        newVector.addElement(new Option("\tjust binarize numeric attributes instead \n\tof properly discretizing them.", "B", 0, "-B"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setMissingMerge(!Utils.getFlag('M', options));
        this.setBinarizeNumericAttributes(Utils.getFlag('B', options));
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        if (!this.getMissingMerge()) {
            options[current++] = "-M";
        }
        if (this.getBinarizeNumericAttributes()) {
            options[current++] = "-B";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String binarizeNumericAttributesTipText() {
        return "Just binarize numeric attributes instead of properly discretizing them.";
    }

    public void setBinarizeNumericAttributes(boolean b) {
        this.m_Binarize = b;
    }

    public boolean getBinarizeNumericAttributes() {
        return this.m_Binarize;
    }

    public String missingMergeTipText() {
        return "Distribute counts for missing values. Counts are distributed across other values in proportion to their frequency. Otherwise, missing is treated as a separate value.";
    }

    public void setMissingMerge(boolean b) {
        this.m_missing_merge = b;
    }

    public boolean getMissingMerge() {
        return this.m_missing_merge;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        Instance inst;
        this.getCapabilities().testWithFail(data);
        int classIndex = data.classIndex();
        int numInstances = data.numInstances();
        if (!this.m_Binarize) {
            Discretize disTransform = new Discretize();
            disTransform.setUseBetterEncoding(true);
            disTransform.setInputFormat(data);
            data = Filter.useFilter(data, disTransform);
        } else {
            NumericToBinary binTransform = new NumericToBinary();
            binTransform.setInputFormat(data);
            data = Filter.useFilter(data, binTransform);
        }
        int numClasses = data.attribute(classIndex).numValues();
        double[][][] counts = new double[data.numAttributes()][][];
        int k = 0;
        while (k < data.numAttributes()) {
            if (k != classIndex) {
                int numValues = data.attribute(k).numValues();
                counts[k] = new double[numValues + 1][numClasses + 1];
            }
            ++k;
        }
        double[] temp = new double[numClasses + 1];
        int k2 = 0;
        while (k2 < numInstances) {
            inst = data.instance(k2);
            if (inst.classIsMissing()) {
                int n = numClasses;
                temp[n] = temp[n] + inst.weight();
            } else {
                int n = (int)inst.classValue();
                temp[n] = temp[n] + inst.weight();
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < counts.length) {
            if (k2 != classIndex) {
                int i = 0;
                while (i < temp.length) {
                    counts[k2][0][i] = temp[i];
                    ++i;
                }
            }
            ++k2;
        }
        k2 = 0;
        while (k2 < numInstances) {
            inst = data.instance(k2);
            int i = 0;
            while (i < inst.numValues()) {
                if (inst.index(i) != classIndex) {
                    if (inst.isMissingSparse(i) || inst.classIsMissing()) {
                        if (!inst.isMissingSparse(i)) {
                            double[] dArray = counts[inst.index(i)][(int)inst.valueSparse(i)];
                            int n = numClasses;
                            dArray[n] = dArray[n] + inst.weight();
                            double[] dArray2 = counts[inst.index(i)][0];
                            int n2 = numClasses;
                            dArray2[n2] = dArray2[n2] - inst.weight();
                        } else if (!inst.classIsMissing()) {
                            double[] dArray = counts[inst.index(i)][data.attribute(inst.index(i)).numValues()];
                            int n = (int)inst.classValue();
                            dArray[n] = dArray[n] + inst.weight();
                            double[] dArray3 = counts[inst.index(i)][0];
                            int n3 = (int)inst.classValue();
                            dArray3[n3] = dArray3[n3] - inst.weight();
                        } else {
                            double[] dArray = counts[inst.index(i)][data.attribute(inst.index(i)).numValues()];
                            int n = numClasses;
                            dArray[n] = dArray[n] + inst.weight();
                            double[] dArray4 = counts[inst.index(i)][0];
                            int n4 = numClasses;
                            dArray4[n4] = dArray4[n4] - inst.weight();
                        }
                    } else {
                        double[] dArray = counts[inst.index(i)][(int)inst.valueSparse(i)];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + inst.weight();
                        double[] dArray5 = counts[inst.index(i)][0];
                        int n5 = (int)inst.classValue();
                        dArray5[n5] = dArray5[n5] - inst.weight();
                    }
                }
                ++i;
            }
            ++k2;
        }
        if (this.m_missing_merge) {
            k2 = 0;
            while (k2 < data.numAttributes()) {
                if (k2 != classIndex) {
                    int numValues = data.attribute(k2).numValues();
                    double[] rowSums = new double[numValues];
                    double[] columnSums = new double[numClasses];
                    double sum = 0.0;
                    int i = 0;
                    while (i < numValues) {
                        int j = 0;
                        while (j < numClasses) {
                            int n = i;
                            rowSums[n] = rowSums[n] + counts[k2][i][j];
                            int n6 = j;
                            columnSums[n6] = columnSums[n6] + counts[k2][i][j];
                            ++j;
                        }
                        sum += rowSums[i];
                        ++i;
                    }
                    if (Utils.gr(sum, 0.0)) {
                        int j;
                        double[][] additions = new double[numValues][numClasses];
                        int i2 = 0;
                        while (i2 < numValues) {
                            j = 0;
                            while (j < numClasses) {
                                additions[i2][j] = rowSums[i2] / sum * counts[k2][numValues][j];
                                ++j;
                            }
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < numClasses) {
                            j = 0;
                            while (j < numValues) {
                                double[] dArray = additions[j];
                                int n = i2;
                                dArray[n] = dArray[n] + columnSums[i2] / sum * counts[k2][j][numClasses];
                                ++j;
                            }
                            ++i2;
                        }
                        i2 = 0;
                        while (i2 < numClasses) {
                            j = 0;
                            while (j < numValues) {
                                double[] dArray = additions[j];
                                int n = i2;
                                dArray[n] = dArray[n] + counts[k2][j][i2] / sum * counts[k2][numValues][numClasses];
                                ++j;
                            }
                            ++i2;
                        }
                        double[][] newTable = new double[numValues][numClasses];
                        int i3 = 0;
                        while (i3 < numValues) {
                            int j2 = 0;
                            while (j2 < numClasses) {
                                newTable[i3][j2] = counts[k2][i3][j2] + additions[i3][j2];
                                ++j2;
                            }
                            ++i3;
                        }
                        counts[k2] = newTable;
                    }
                }
                ++k2;
            }
        }
        this.m_InfoGains = new double[data.numAttributes()];
        int i = 0;
        while (i < data.numAttributes()) {
            if (i != classIndex) {
                this.m_InfoGains[i] = ContingencyTables.entropyOverColumns(counts[i]) - ContingencyTables.entropyConditionedOnRows(counts[i]);
            }
            ++i;
        }
    }

    protected void resetOptions() {
        this.m_InfoGains = null;
        this.m_missing_merge = true;
        this.m_Binarize = false;
    }

    @Override
    public double evaluateAttribute(int attribute) throws Exception {
        return this.m_InfoGains[attribute];
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_InfoGains == null) {
            text.append("Information Gain attribute evaluator has not been built");
        } else {
            text.append("\tInformation Gain Ranking Filter");
            if (!this.m_missing_merge) {
                text.append("\n\tMissing values treated as seperate");
            }
            if (this.m_Binarize) {
                text.append("\n\tNumeric attributes are just binarized");
            }
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5511 $");
    }

    public static void main(String[] args) {
        InfoGainAttributeEval.runEvaluator(new InfoGainAttributeEval(), args);
    }
}

