/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.SubsetEvaluator;
import weka.attributeSelection.UnsupervisedSubsetEvaluator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class ExhaustiveSearch
extends ASSearch
implements OptionHandler {
    static final long serialVersionUID = 5741842861142379712L;
    private BitSet m_bestGroup;
    private double m_bestMerit;
    private boolean m_hasClass;
    private int m_classIndex;
    private int m_numAttribs;
    private boolean m_verbose;
    private int m_evaluations;

    public String globalInfo() {
        return "ExhaustiveSearch : \n\nPerforms an exhaustive search through the space of attribute subsets starting from the empty set of attrubutes. Reports the best subset found.";
    }

    public ExhaustiveSearch() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(2);
        newVector.addElement(new Option("\tOutput subsets as the search progresses.\n\t(default = false).", "V", 0, "-V"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setVerbose(Utils.getFlag('V', options));
    }

    public String verboseTipText() {
        return "Print progress information. Sends progress info to the terminal as the search progresses.";
    }

    public void setVerbose(boolean v) {
        this.m_verbose = v;
    }

    public boolean getVerbose() {
        return this.m_verbose;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[1];
        int current = 0;
        if (this.m_verbose) {
            options[current++] = "-V";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("\tExhaustive Search.\n\tStart set: ");
        text.append("no attributes\n");
        text.append("\tNumber of evaluations: " + this.m_evaluations + "\n");
        text.append("\tMerit of best subset found: " + Utils.doubleToString(Math.abs(this.m_bestMerit), 8, 3) + "\n");
        return text.toString();
    }

    @Override
    public int[] search(ASEvaluation ASEval, Instances data) throws Exception {
        int tempSize;
        boolean done = false;
        BigInteger space = BigInteger.ZERO;
        this.m_evaluations = 0;
        this.m_numAttribs = data.numAttributes();
        this.m_bestGroup = new BitSet(this.m_numAttribs);
        if (!(ASEval instanceof SubsetEvaluator)) {
            throw new Exception(String.valueOf(ASEval.getClass().getName()) + " is not a " + "Subset evaluator!");
        }
        if (ASEval instanceof UnsupervisedSubsetEvaluator) {
            this.m_hasClass = false;
        } else {
            this.m_hasClass = true;
            this.m_classIndex = data.classIndex();
        }
        SubsetEvaluator ASEvaluator = (SubsetEvaluator)((Object)ASEval);
        this.m_numAttribs = data.numAttributes();
        double best_merit = ASEvaluator.evaluateSubset(this.m_bestGroup);
        ++this.m_evaluations;
        int sizeOfBest = this.countFeatures(this.m_bestGroup);
        BitSet tempGroup = new BitSet(this.m_numAttribs);
        double tempMerit = ASEvaluator.evaluateSubset(tempGroup);
        if (this.m_verbose) {
            System.out.println("Zero feature subset (" + Utils.doubleToString(Math.abs(tempMerit), 8, 5) + ")");
        }
        if (tempMerit >= best_merit) {
            tempSize = this.countFeatures(tempGroup);
            if (tempMerit > best_merit || tempSize < sizeOfBest) {
                best_merit = tempMerit;
                this.m_bestGroup = (BitSet)tempGroup.clone();
                sizeOfBest = tempSize;
            }
        }
        int numatts = this.m_hasClass ? this.m_numAttribs - 1 : this.m_numAttribs;
        BigInteger searchSpaceEnd = BigInteger.ONE.add(BigInteger.ONE).pow(numatts).subtract(BigInteger.ONE);
        while (!done) {
            if ((space = space.add(BigInteger.ONE)).equals(searchSpaceEnd)) {
                done = true;
            }
            tempGroup.clear();
            int i = 0;
            while (i < numatts) {
                if (space.testBit(i)) {
                    if (!this.m_hasClass) {
                        tempGroup.set(i);
                    } else {
                        int j = i >= this.m_classIndex ? i + 1 : i;
                        tempGroup.set(j);
                    }
                }
                ++i;
            }
            tempMerit = ASEvaluator.evaluateSubset(tempGroup);
            ++this.m_evaluations;
            if (!(tempMerit >= best_merit)) continue;
            tempSize = this.countFeatures(tempGroup);
            if (!(tempMerit > best_merit) && tempSize >= sizeOfBest) continue;
            best_merit = tempMerit;
            this.m_bestGroup = (BitSet)tempGroup.clone();
            sizeOfBest = tempSize;
            if (!this.m_verbose) continue;
            System.out.println("New best subset (" + Utils.doubleToString(Math.abs(best_merit), 8, 5) + "): " + this.printSubset(this.m_bestGroup));
        }
        this.m_bestMerit = best_merit;
        return this.attributeList(this.m_bestGroup);
    }

    private int countFeatures(BitSet featureSet) {
        int count = 0;
        int i = 0;
        while (i < this.m_numAttribs) {
            if (featureSet.get(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private String printSubset(BitSet temp) {
        StringBuffer text = new StringBuffer();
        int j = 0;
        while (j < this.m_numAttribs) {
            if (temp.get(j)) {
                text.append(String.valueOf(j + 1) + " ");
            }
            ++j;
        }
        return text.toString();
    }

    private int[] attributeList(BitSet group) {
        int count = 0;
        int i = 0;
        while (i < this.m_numAttribs) {
            if (group.get(i)) {
                ++count;
            }
            ++i;
        }
        int[] list = new int[count];
        count = 0;
        int i2 = 0;
        while (i2 < this.m_numAttribs) {
            if (group.get(i2)) {
                list[count++] = i2;
            }
            ++i2;
        }
        return list;
    }

    private void generateNextSubset(int size, BitSet temp) {
        int counter = 0;
        boolean done = false;
        BitSet temp2 = (BitSet)temp.clone();
        System.err.println("Size: " + size);
        int i = 0;
        while (i < this.m_numAttribs) {
            temp2.clear(i);
            ++i;
        }
        block1: while (!done && counter < size) {
            i = this.m_numAttribs - 1 - counter;
            while (i >= 0) {
                if (temp.get(i)) {
                    temp.clear(i);
                    if (i != this.m_numAttribs - 1 - counter) {
                        int newP = i + 1;
                        if (newP == this.m_classIndex) {
                            ++newP;
                        }
                        if (newP < this.m_numAttribs) {
                            temp.set(newP);
                            int j = 0;
                            while (j < counter) {
                                if (newP + 1 + j == this.m_classIndex) {
                                    ++newP;
                                }
                                if (newP + 1 + j < this.m_numAttribs) {
                                    temp.set(newP + 1 + j);
                                }
                                ++j;
                            }
                            done = true;
                            continue block1;
                        }
                        ++counter;
                        continue block1;
                    }
                    ++counter;
                    continue block1;
                }
                --i;
            }
        }
        if (temp.cardinality() < size) {
            temp.clear();
        }
        System.err.println(this.printSubset(temp).toString());
    }

    private void resetOptions() {
        this.m_verbose = false;
        this.m_evaluations = 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.15 $");
    }
}

