/*
 * Decompiled with CFR 0.152.
 */
package weka.associations.tertius;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SimpleLinkedList
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -1491148276509976299L;
    private Entry first = new Entry(null, null, null);
    private Entry last;

    public SimpleLinkedList() {
        this.first.next = this.last = new Entry(null, null, null);
        this.last.previous = this.first;
    }

    public Object removeFirst() {
        if (this.first.next == this.last) {
            throw new NoSuchElementException();
        }
        Object result = this.first.next.element;
        this.first.next.next.previous = this.first;
        this.first.next = this.first.next.next;
        return result;
    }

    public Object getFirst() {
        if (this.first.next == this.last) {
            throw new NoSuchElementException();
        }
        return this.first.next.element;
    }

    public Object getLast() {
        if (this.last.previous == this.first) {
            throw new NoSuchElementException();
        }
        return this.last.previous.element;
    }

    public void addFirst(Object o) {
        Entry newEntry;
        this.first.next.previous = newEntry = new Entry(o, this.first.next, this.first);
        this.first.next = newEntry;
    }

    public void add(Object o) {
        Entry newEntry;
        this.last.previous.next = newEntry = new Entry(o, this.last, this.last.previous);
        this.last.previous = newEntry;
    }

    public void addAll(SimpleLinkedList list) {
        this.last.previous.next = list.first.next;
        list.first.next.previous = this.last.previous;
        this.last = list.last;
    }

    public void clear() {
        this.first.next = this.last;
        this.last.previous = this.first;
    }

    public boolean isEmpty() {
        return this.first.next == this.last;
    }

    public LinkedListIterator iterator() {
        return new LinkedListIterator();
    }

    public LinkedListInverseIterator inverseIterator() {
        return new LinkedListInverseIterator();
    }

    public int size() {
        int result = 0;
        LinkedListIterator iter = new LinkedListIterator();
        while (iter.hasNext()) {
            ++result;
            iter.next();
        }
        return result;
    }

    public void merge(SimpleLinkedList list, Comparator comp) {
        LinkedListIterator iter1 = this.iterator();
        LinkedListIterator iter2 = list.iterator();
        Object elem1 = iter1.next();
        Object elem2 = iter2.next();
        while (elem2 != null) {
            if (elem1 == null || comp.compare(elem2, elem1) < 0) {
                iter1.addBefore(elem2);
                elem2 = iter2.next();
                continue;
            }
            elem1 = iter1.next();
        }
    }

    public void sort(Comparator comp) {
        LinkedListIterator iter = this.iterator();
        if (iter.hasNext()) {
            SimpleLinkedList lower = new SimpleLinkedList();
            SimpleLinkedList upper = new SimpleLinkedList();
            Object ref = iter.next();
            while (iter.hasNext()) {
                Object elem = iter.next();
                if (comp.compare(elem, ref) < 0) {
                    lower.add(elem);
                    continue;
                }
                upper.add(elem);
            }
            lower.sort(comp);
            upper.sort(comp);
            this.clear();
            this.addAll(lower);
            this.add(ref);
            this.addAll(upper);
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        LinkedListIterator iter = this.iterator();
        text.append("[");
        while (iter.hasNext()) {
            text.append(String.valueOf(iter.next()));
            if (!iter.hasNext()) continue;
            text.append(", ");
        }
        text.append("]");
        return text.toString();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size());
        Entry e = this.first.next;
        while (e != this.last) {
            s.writeObject(e.element);
            e = e.next;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this.first = new Entry(null, null, null);
        this.first.next = this.last = new Entry(null, null, null);
        this.last.previous = this.first;
        int i = 0;
        while (i < size) {
            this.add(s.readObject());
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }

    private static class Entry
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 7888492479685339831L;
        Object element;
        Entry next;
        Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.6 $");
        }
    }

    public class LinkedListInverseIterator
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = 6290379064027832108L;
        Entry current;
        Entry lastReturned;

        public LinkedListInverseIterator() {
            this.current = SimpleLinkedList.this.last;
            this.lastReturned = null;
        }

        public boolean hasPrevious() {
            return this.current.previous != SimpleLinkedList.this.first;
        }

        public Object previous() {
            if (this.current == SimpleLinkedList.this.first) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.current = this.current.previous;
            return this.current.element;
        }

        public void remove() {
            if (this.lastReturned == SimpleLinkedList.this.first || this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.previous.next = this.lastReturned.next;
            this.lastReturned.next.previous = this.lastReturned.previous;
            this.current = this.lastReturned.next;
            this.lastReturned = null;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.6 $");
        }
    }

    public class LinkedListIterator
    implements Serializable,
    RevisionHandler {
        private static final long serialVersionUID = -2448555236100426759L;
        Entry current;
        Entry lastReturned;

        public LinkedListIterator() {
            this.current = SimpleLinkedList.this.first;
            this.lastReturned = null;
        }

        public boolean hasNext() {
            return this.current.next != SimpleLinkedList.this.last;
        }

        public Object next() {
            if (this.current == SimpleLinkedList.this.last) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.current = this.current.next;
            return this.current.element;
        }

        public void remove() {
            if (this.lastReturned == SimpleLinkedList.this.last || this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.previous.next = this.lastReturned.next;
            this.lastReturned.next.previous = this.lastReturned.previous;
            this.current = this.lastReturned.previous;
            this.lastReturned = null;
        }

        public void addBefore(Object o) {
            Entry newEntry;
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.previous.next = newEntry = new Entry(o, this.lastReturned, this.lastReturned.previous);
            this.lastReturned.previous = newEntry;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 1.6 $");
        }
    }
}

