/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "utils/utils.cu"

#include "test.h"
#include "utils/test_utils.h"

int test_src_utils_utils( char* function )
{
	if( !strcmp( function, "distribute_blocks" ) )
	{
		struct distribution distribution;
		distribute_blocks( 10, 2, &distribution );
		TEST( distribution.block_size == 5 );
		TEST( distribution.num_blocks == 2 );
		TEST( distribution.num_full_blocks == 2 );

		distribute_blocks( 10, 3, &distribution );
		TEST( distribution.block_size == 4 );
		TEST( distribution.num_blocks == 3 );
		TEST( distribution.num_full_blocks == 2 );
		TEST( distribution.rest_block_size == 2 );

		distribute_blocks( 49, 20, &distribution );
		TEST( distribution.block_size == 3 );
		TEST( distribution.num_blocks == 17 );
		TEST( distribution.num_full_blocks == 16 );
		TEST( distribution.rest_block_size == 1 );

		END_TEST();
	}

	TEST( 0 );
}
