/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "solvers/fft_ser.cu"

#include "test.h"
#include "solvers/test_fft_ser.h"

int test_src_solvers_fft_ser( char* function )
{
	if( !strcmp( function, "init_fft_solver" ) )
	{
		cup_grid_t grid;
		cup_solver_t solver;
		cup_error_t status;
		int nps[] = {10, 10 ,10};
		double size[] = {1.0, 1.0, 1.0};

		cup_init( 1, NULL );

		cup_create_grid( 3, nps, size, &grid );

		cup_create_solver( CUP_FFT_SOLVER, grid, CUP_BND_PERIODIC, &solver );

		solver->status = CUP_SUCCESS;
		solver->state = SOLVER_RUNNING;
		solver->state_sync->counter = 0;

		status = init_fft_solver( solver );
		TEST( status == CUP_SUCCESS );

		cup_destroy_grid( grid );
		cup_destroy_solver( solver );

		cup_finish();

		END_TEST();
	}

	TEST( 0 );
}
