/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/********************************************
 * Includes                                 *
 ********************************************/

#include "core/grid.c"

#include "test.h"
#include "core/test_grid.h"

/********************************************
 * Public functions                         *
 ********************************************/
int test_src_core_grid( char* function )
{
	cup_error_t status;

	if( !strcmp( function, "copy_grid" ) )
	{
		struct cup_grid* in,
		               * out;
		int nps[] = { 10, 10, 10 };
		double size[] = { 1.0, 1.0, 1.0 };

		status = cup_create_grid( 3, nps, size, ( cup_grid_t* ) &in );
		TEST( status == CUP_SUCCESS );

		status = copy_grid( &out, in );
		TEST( status == CUP_SUCCESS );

		TEST( out->dim == in->dim );
		TEST( out->np == in->np );
		TEST( out->nps != in->nps );
		TEST( out->nps[0] == in->nps[0] );
		TEST( out->nps[1] == in->nps[1] );
		TEST( out->nps[2] == in->nps[2] );
		TEST( out->size[0] == in->size[0] );
		TEST( out->size[1] == in->size[1] );
		TEST( out->size[2] == in->size[2] );

		cup_destroy_grid( ( cup_grid_t ) in );
		cup_destroy_grid( ( cup_grid_t ) out );

		END_TEST();
	}

	TEST( 0 );
}
