#    Copyright (C) 2016 University of the Basque Country, UPV/EHU.
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

######################################################
function( add_suffix_to_filename module FILE )
	get_filename_component( FILE_PATH ${FILE} PATH )
	get_filename_component( FILE_NAME ${FILE} NAME_WE )
	get_filename_component( FILE_EXT ${FILE} EXT )
	set( DERIVED_FILE "${FILE_PATH}/${FILE_NAME}_${module}${FILE_EXT}" PARENT_SCOPE )
endfunction( add_suffix_to_filename module file )

function( create_files module files )
	foreach( FILE ${files} )
		add_suffix_to_filename( ${module} ${FILE} ) 
		set( MULTI_MOD_FILE "${cuPoisson_SOURCE_DIR}/${FILE}" )
		configure_file(
			"${cuPoisson_SOURCE_DIR}/multi_mod.in"
			"${PROJECT_BINARY_DIR}/multi_mod/${DERIVED_FILE}"
		)
		set( SRC ${SRC} "${PROJECT_BINARY_DIR}/multi_mod/${DERIVED_FILE}" PARENT_SCOPE )
	endforeach( FILE ${files} )
endfunction( create_files module files )
######################################################
if( EXISTS "${PROJECT_BINARY_DIR}/multi_mod" )
        file( REMOVE_RECURSE "${PROJECT_BINARY_DIR}/multi_mod" )
endif( EXISTS "${PROJECT_BINARY_DIR}/multi_mod" )

if( MOD_SERIAL )
	set( MOD_EXCL_SERIAL 1 )
	unset( MOD_EXCL_MPI )
	create_files( "ser" ${MULTI_SRC_SERIAL} )
endif( MOD_SERIAL )

if( MOD_MPI )
	unset( MOD_EXCL_SERIAL )
	set( MOD_EXCL_MPI 1 )
	create_files( "mpi" ${MULTI_SRC_MPI} )
endif( MOD_MPI )
