/*
    Copyright (C) 2016 University of the Basque Country, UPV/EHU.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CUP_CUPOISSON_MPI_H_
#define CUP_CUPOISSON_MPI_H_

#include <mpi.h>

/**********************************
 * Constants and enumerations exported by the library
 *********************************/
// Solvers
struct cup_mpi_solver;
typedef struct cup_mpi_solver* cup_mpi_solver_t;

/**********************************
 * Functions exported by the library.
 *********************************/
#ifdef __cplusplus
extern "C" {
#endif

// Solvers
cup_error_t cup_mpi_get_solver_data( cup_mpi_solver_t solver,
                                     double***        data,
                                     int*             offset,
                                     int*             sizes );
cup_error_t cup_mpi_create_solver( cup_solver_type_t type,
                                   cup_grid_t        grid,
                                   cup_bnd_type      boundary_type,
                                   MPI_Comm          comm,
                                   cup_mpi_solver_t* solver );
cup_error_t cup_mpi_destroy_solver( cup_mpi_solver_t solver );
cup_error_t cup_mpi_exec_solver( cup_mpi_solver_t solver,
                                 const double*    input,
                                 double*          output );
cup_error_t cup_mpi_wait_solver( cup_mpi_solver_t solver, cup_error_t* status );
cup_error_t cup_mpi_is_solver_ready( cup_mpi_solver_t solver, int* is_ready );

#ifdef __cplusplus
}
#endif

#endif /* CUP_CUPOISSON_MPI_H_ */
