#!/bin/bash

def_confs="Debug Release"
create=0
serial="-D MOD_SERIAL=Off"
mpi="-D MOD_MPI=Off"

while [ : ]
do
	if [ $# -eq 0 ]
	then
		break
	else
		case $1 in
			"-c")
				create=1
				shift
				;;
			"-s")
				serial="-D MOD_SERIAL=On"
				shift
				;;
			"-m")
				mpi="-D MOD_MPI=On"
				shift
				;;
			*)
				break
		esac
	fi
done

if [ $# -eq 0 ]
then
	confs=$def_confs
else
	confs=$@
fi

for conf in $confs
do
	confdir=${conf}${suffix}
	echo "Running CMake for $conf configuration..."
	if [ ! -d $confdir -a $create -eq 1 ]
	then
		echo "Creating $conf_dir folder..."
		mkdir $confdir
	elif [ ! -d $confdir ]
	then
		echo "Error: $conf folder does not exist. Use -c option to create the folder when needed."
	fi

	if [ -d $confdir ]
	then
		cd $confdir
		cmake -G "Unix Makefiles" -D CMAKE_BUILD_TYPE=$conf $serial $mpi VERBOSE=1 ..
		cd ..
	fi
done
